/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.cube.model.DependentTransactionalCubes;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeSubDimension;
import oracle.olap.cubexml.CubeDimensionXML;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.db.IdentifierElement;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.AbstractOLAPDBObjectBuilder;
import oracle.olap.db.model.LanguageDescription;
import oracle.olapi.syntax.OrderByClause;
import oracle.olapi.syntax.OrderByElement;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.TypedExpression;

public class CubeDimensionBuilder
extends AbstractOLAPDBObjectBuilder<CubeDimension> {
    private static final String DIMENSION = "DIMENSION";
    private static final String DIMENSION_LEVEL = "DIMENSION LEVEL";

    public CubeDimensionBuilder(OracleDatabaseImpl oracleDatabaseImpl) {
        super((AbstractDBObjectProvider)oracleDatabaseImpl, "CUBE DIMENSION");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    public CubeDimension createObject(String string, Schema schema, DBObjectID dBObjectID) {
        CubeDimension cubeDimension = new CubeDimension();
        cubeDimension.setName(string);
        cubeDimension.setSchema(schema);
        cubeDimension.setID(dBObjectID);
        return cubeDimension;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"description", "analyticWorkspace"})
    public void buildProperties(final CubeDimension cubeDimension) throws DBException {
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), "select /*+ NO_QUERY_TRANSFORMATION */ aw_name, dimension_type, default_hierarchy_name, description, custom_order from all_cube_dimensions  where dimension_name = ? and owner = ?", new Object[]{cubeDimension.getName(), cubeDimension.getSchema()});
        try {
            queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        if (resultSet.next()) {
                            String string = resultSet.getString(1);
                            String string2 = resultSet.getString(2);
                            String string3 = resultSet.getString(3);
                            String string4 = resultSet.getString(4);
                            Clob clob = resultSet.getClob(5);
                            String string5 = null;
                            if (clob != null) {
                                long l = clob.length();
                                string5 = clob.getSubString(1L, (int)l);
                            }
                            cubeDimension.setDescription(string4);
                            cubeDimension.setAnalyticWorkspace(string);
                            cubeDimension.setDimensionDefaultHierarchyName(string3);
                            cubeDimension.setCustomOrderStr(string5);
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException((DBObject)cubeDimension, sQLException);
                    }
                }
            });
        }
        catch (DBException dBException) {
            System.out.println(dBException.toString());
            throw dBException;
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"shortDescription", "longDescription", "dimensionType", "levels", "hierarchies", "attributes", "hierarchyDefault"})
    public void buildDetails(CubeDimension cubeDimension) throws DBException, SQLException, IOException, JAXBException {
        Database database = (Database)this.getProvider();
        cubeDimension.removeAllAttributes();
        cubeDimension.removeAllHierarchies();
        cubeDimension.removeAllLevels();
        try {
            this.build(cubeDimension);
            String string = cubeDimension.getSchema().getName();
            String string2 = String.format("%s.%s", string, cubeDimension.getName());
            Object object = this.getObject(database.getConnection(), string2);
            MetadataContext metadataContext = new MetadataContext(this.getProvider());
            CubeDimensionXML cubeDimensionXML = new CubeDimensionXML(metadataContext, object, cubeDimension);
            cubeDimensionXML.loadModel();
            if (cubeDimension.getCustomOrderStr() != null) {
                this.setCustomOrderDetails(cubeDimension, cubeDimension.getCustomOrderStr());
            }
            cubeDimension.setFullyLoaded(true);
        }
        catch (DBException dBException) {
            dBException.printStackTrace();
            throw dBException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void buildFromCache(CubeDimension cubeDimension) throws DBException, SQLException, IOException {
        CubeSubDimension cubeSubDimension;
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        String string = cubeDimension.getSchema().getName();
        String string2 = Connections.getInstance().getConnectionName(oracleDatabaseImpl.getConnection());
        oracle.olap.app.olapmetadata.Schema schema = OLAPMetadataCache.getUpdatedSchema(string2, string);
        Dimension dimension = schema.findDimension(cubeDimension.getName());
        for (DimensionLevel subDimension : dimension.getLevels()) {
            cubeSubDimension = new CubeDimensionLevel(subDimension.getName());
            cubeDimension.addLevel((CubeDimensionLevel)cubeSubDimension);
        }
        for (DimensionHierarchy dimensionHierarchy : dimension.getHierarchies()) {
            Object object;
            cubeSubDimension = new CubeDimensionHierarchy(dimensionHierarchy.getName());
            ((CubeDimensionHierarchy)cubeSubDimension).setHierarchyLevelType(dimensionHierarchy.isLevelBased());
            ((CubeDimensionHierarchy)cubeSubDimension).setNotRagged(!dimensionHierarchy.isRagged());
            ((CubeDimensionHierarchy)cubeSubDimension).setNotSkipLevel(!dimensionHierarchy.isSkipLevel());
            ((CubeDimensionHierarchy)cubeSubDimension).setViewName(dimensionHierarchy.getViewName());
            if (dimensionHierarchy == dimension.getDefaultHierarchy()) {
                ((CubeDimensionHierarchy)cubeSubDimension).setHierarchyDefault(true);
            }
            cubeDimension.addHierarchy((CubeDimensionHierarchy)cubeSubDimension);
            List<DimensionHierarchyLevel> list = dimensionHierarchy.getHierarchyLevels();
            ArrayList<DimensionHierarchyLevel> arrayList = new ArrayList<DimensionHierarchyLevel>();
            for (DimensionHierarchyLevel dimensionHierarchyLevel : list) {
                object = new DimensionHierarchyLevel(dimensionHierarchyLevel.getHierarchy(), dimensionHierarchyLevel.getLevel(), dimensionHierarchyLevel.getDescription());
                arrayList.add((DimensionHierarchyLevel)object);
            }
            Collections.reverse(arrayList);
            for (DimensionHierarchyLevel dimensionHierarchyLevel : arrayList) {
                object = cubeDimension.findLevel(dimensionHierarchyLevel.getLevelName());
                CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel = new CubeDimensionHierarchyLevel((CubeDimensionHierarchy)cubeSubDimension, (CubeDimensionLevel)object);
                ((CubeDimensionHierarchy)cubeSubDimension).addHierarchyLevel(cubeDimensionHierarchyLevel);
            }
        }
    }

    public void build(final CubeDimension cubeDimension) throws DBException, SQLException {
        Database database = (Database)this.getProvider();
        cubeDimension.removeAllAttributes();
        cubeDimension.removeAllHierarchies();
        cubeDimension.removeAllLevels();
        String string = String.format("SELECT /*+ NO_QUERY_TRANSFORMATION */ object_name , object_type, language, description_type, description_value from all_cube_descriptions where owner = ? and (object_name = '%1$s' or object_name like '%1$s.%%') and object_type in('DIMENSION','DIMENSION LEVEL','HIERARCHY','ATTRIBUTE') and language <> ? order by object_name,language", cubeDimension.getName());
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), string, new Object[]{cubeDimension.getSchema(), this.getDefaultLanguage()});
        final QueryWrapper queryWrapper2 = new QueryWrapper((Database)this.getProvider(), "select /*+ NO_QUERY_TRANSFORMATION */ level_name from all_cube_dim_levels  where dimension_name = ? and owner = ? order by level_name", new Object[]{cubeDimension.getName(), cubeDimension.getSchema()});
        QueryWrapper queryWrapper3 = new QueryWrapper((Database)this.getProvider(), "select /*+ NO_QUERY_TRANSFORMATION */ hierarchy_name, hierarchy_type from all_cube_hierarchies  where dimension_name = ? and owner = ? order by hierarchy_name", new Object[]{cubeDimension.getName(), cubeDimension.getSchema()});
        QueryWrapper queryWrapper4 = new QueryWrapper((Database)this.getProvider(), "select /*+ NO_QUERY_TRANSFORMATION */ all_cube_hierarchies.hierarchy_name, all_cube_hierarchies.hierarchy_type, \nall_cube_hierarchies.is_ragged, all_cube_hierarchies.is_skip_level, all_cube_hier_views.view_name \nfrom all_cube_hierarchies, all_cube_hier_views \nwhere all_cube_hierarchies.dimension_name = ? and all_cube_hierarchies.owner = ? \nand all_cube_hierarchies.owner = all_cube_hier_views.owner \nand all_cube_hierarchies.dimension_name = all_cube_hier_views.dimension_name\nand all_cube_hierarchies.hierarchy_name = all_cube_hier_views.hierarchy_name\norder by all_cube_hierarchies.owner, all_cube_hierarchies.dimension_name, all_cube_hierarchies.hierarchy_name", new Object[]{cubeDimension.getName(), cubeDimension.getSchema()});
        QueryWrapper queryWrapper5 = new QueryWrapper((Database)this.getProvider(), "select /*+ NO_QUERY_TRANSFORMATION */ hierarchy_name, level_name from all_cube_hier_levels  where dimension_name = ? and owner = ? order by hierarchy_name, order_num desc", new Object[]{cubeDimension.getName(), cubeDimension.getSchema()});
        QueryWrapper queryWrapper6 = new QueryWrapper((Database)this.getProvider(), "select /*+ NO_QUERY_TRANSFORMATION */ attribute_name,  data_type  || DECODE(data_type, 'CHAR', '('  || data_length  ||')', 'VARCHAR', '('  || data_length  ||')', 'VARCHAR2', '('  || data_length  ||')', 'NCHAR', '('  || data_length  ||')', 'NVARCHAR', '('  || data_length  ||')', 'NVARCHAR2', '('  || data_length  ||')', 'NUMBER', '('  || NVL(data_precision,data_length)  || DECODE(data_scale,NULL,NULL, ','  ||data_scale)  ||')', NULL) DATATYPE,   attribute_role from all_cube_attributes  where dimension_name = ? and owner = ? order by attribute_name", new Object[]{cubeDimension.getName(), cubeDimension.getSchema()});
        final QueryWrapper queryWrapper7 = new QueryWrapper((Database)this.getProvider(), "select /*+ NO_QUERY_TRANSFORMATION */ distinct mviews.owner, dimension_name, rewrite_enabled, refresh_method,  fast_refreshable, last_refresh_type  from all_cube_hierarchies ch, all_mviews mviews  where ch.owner = ? and dimension_name = ? and ch.refresh_mview_name = mviews.mview_name", new Object[]{cubeDimension.getSchema(), cubeDimension.getName()});
        queryWrapper2.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        CubeDimensionLevel cubeDimensionLevel = new CubeDimensionLevel(string);
                        cubeDimension.addLevel(cubeDimensionLevel);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper2.throwDBException((DBObject)cubeDimension, sQLException);
                }
            }
        });
        queryWrapper4.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        BigDecimal bigDecimal = resultSet.getBigDecimal(3);
                        BigDecimal bigDecimal2 = resultSet.getBigDecimal(4);
                        String string3 = resultSet.getString(5);
                        CubeDimensionHierarchy cubeDimensionHierarchy = new CubeDimensionHierarchy(string);
                        if (string2.equals("LEVEL")) {
                            cubeDimensionHierarchy.setHierarchyLevelType(true);
                        } else {
                            cubeDimensionHierarchy.setHierarchyValueType(true);
                        }
                        if (bigDecimal.intValue() == 0) {
                            cubeDimensionHierarchy.setNotRagged(true);
                        } else {
                            cubeDimensionHierarchy.setNotRagged(false);
                        }
                        if (bigDecimal2.intValue() == 0) {
                            cubeDimensionHierarchy.setNotSkipLevel(true);
                        } else {
                            cubeDimensionHierarchy.setNotSkipLevel(false);
                        }
                        cubeDimensionHierarchy.setViewName(string3);
                        String string4 = cubeDimension.getDimensionDefaultHierarchyName();
                        if (string4 != null && string4.equals(string)) {
                            cubeDimensionHierarchy.setHierarchyDefault(true);
                        }
                        cubeDimension.addHierarchy(cubeDimensionHierarchy);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper2.throwDBException((DBObject)cubeDimension, sQLException);
                }
            }
        });
        queryWrapper5.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        CubeDimensionHierarchy cubeDimensionHierarchy = cubeDimension.findHierarchy(string);
                        CubeDimensionLevel cubeDimensionLevel = cubeDimension.findLevel(string2);
                        CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel = new CubeDimensionHierarchyLevel(cubeDimensionHierarchy, cubeDimensionLevel);
                        cubeDimensionHierarchy.addHierarchyLevel(cubeDimensionHierarchyLevel);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper2.throwDBException((DBObject)cubeDimension, sQLException);
                }
            }
        });
        queryWrapper6.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = CubeDimensionBuilder.getRootDataType(string2);
                        String string4 = resultSet.getString(3);
                        CubeDimensionAttribute cubeDimensionAttribute = new CubeDimensionAttribute(string);
                        cubeDimensionAttribute.setDataType(string3);
                        cubeDimensionAttribute.setRole(string4);
                        cubeDimensionAttribute.setPersistedOrSpecial(true);
                        cubeDimensionAttribute.setOriginalAttributeName(string);
                        cubeDimension.addAttribute(cubeDimensionAttribute);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper2.throwDBException((DBObject)cubeDimension, sQLException);
                }
            }
        });
        queryWrapper7.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString("dimension_name");
                        cubeDimension.setDimensionMVEnabled(true);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper7.throwDBException((DBObject)cubeDimension, sQLException);
                }
            }
        });
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    CubeDimensionBuilder.this.processLanguageDescriptionsResultSet(resultSet, cubeDimension);
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)cubeDimension, sQLException);
                }
            }
        });
    }

    public void buildDependentCubes(final CubeDimension cubeDimension) throws DBException {
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), "select /*+ NO_QUERY_TRANSFORMATION */ cdy.cube_name cube_name from all_cube_dimensionality cdy  where cdy.owner = ? and cdy.dimension_name = ? order by cube_name", new Object[]{cubeDimension.getSchema(), cubeDimension.getName()});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    cubeDimension.setDimensionUsedInCube("FALSE");
                    while (resultSet.next()) {
                        cubeDimension.setDimensionUsedInCube("TRUE");
                        arrayList.add(resultSet.getString(1));
                    }
                    cubeDimension.setDimensionCubeNames(arrayList);
                    DependentTransactionalCubes dependentTransactionalCubes = DependentTransactionalCubes.getInstance();
                    dependentTransactionalCubes.reset();
                    dependentTransactionalCubes.setDimension(cubeDimension);
                    dependentTransactionalCubes.setDatabaseProvider((OracleDatabaseImpl)CubeDimensionBuilder.this.getProvider());
                    dependentTransactionalCubes.loadMetadata();
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)cubeDimension, sQLException);
                }
            }
        });
    }

    private void processLanguageDescriptionsResultSet(ResultSet resultSet, CubeDimension cubeDimension) throws DBException, SQLException {
        String string = "";
        boolean bl = true;
        LanguageDescription languageDescription = null;
        int n = 0;
        while (resultSet.next()) {
            if (bl) {
                string = resultSet.getString("language");
                languageDescription = new LanguageDescription(string);
                languageDescription.setLanguage(string);
                bl = false;
            }
            if (string.equals(resultSet.getString("language"))) {
                if (resultSet.getString("description_type").equalsIgnoreCase("Description")) {
                    languageDescription.setDescription(resultSet.getString("description_value"));
                    ++n;
                } else if (resultSet.getString("description_type").equalsIgnoreCase("ShortDescription")) {
                    languageDescription.setShortDescription(resultSet.getString("description_value"));
                    ++n;
                } else if (resultSet.getString("description_type").equalsIgnoreCase("LongDescription")) {
                    languageDescription.setLongDescription(resultSet.getString("description_value"));
                    ++n;
                }
                if (n == 3) {
                    AbstractChildObjectWithDesc abstractChildObjectWithDesc;
                    this.checkForNullLanguageDescriptionValues(languageDescription);
                    String string2 = resultSet.getString("object_name");
                    if (resultSet.getString("object_type").equalsIgnoreCase(DIMENSION)) {
                        if (cubeDimension.getName().equalsIgnoreCase(string2)) {
                            cubeDimension.addLanguageDescription(languageDescription);
                        }
                    } else if (resultSet.getString("object_type").equalsIgnoreCase(DIMENSION_LEVEL)) {
                        abstractChildObjectWithDesc = cubeDimension.findLevel(string2.substring(string2.indexOf(".") + 1));
                        if (abstractChildObjectWithDesc != null) {
                            abstractChildObjectWithDesc.addLanguageDescription(languageDescription);
                        }
                    } else if (resultSet.getString("object_type").equalsIgnoreCase("HIERARCHY")) {
                        abstractChildObjectWithDesc = cubeDimension.findHierarchy(string2.substring(string2.indexOf(".") + 1));
                        if (abstractChildObjectWithDesc != null) {
                            abstractChildObjectWithDesc.addLanguageDescription(languageDescription);
                        }
                    } else if (resultSet.getString("object_type").equalsIgnoreCase("ATTRIBUTE") && (abstractChildObjectWithDesc = cubeDimension.findAttribute(string2.substring(string2.indexOf(".") + 1))) != null) {
                        abstractChildObjectWithDesc.addLanguageDescription(languageDescription);
                    }
                    n = 0;
                    languageDescription = new LanguageDescription(resultSet.getString("language"));
                    languageDescription.setLanguage(resultSet.getString("language"));
                }
            } else {
                languageDescription = new LanguageDescription(resultSet.getString("language"));
                languageDescription.setLanguage(resultSet.getString("language"));
                if (resultSet.getString("description_type").equalsIgnoreCase("Description")) {
                    languageDescription.setDescription(resultSet.getString("description_value"));
                    ++n;
                } else if (resultSet.getString("description_type").equalsIgnoreCase("ShortDescription")) {
                    languageDescription.setShortDescription(resultSet.getString("description_value"));
                    ++n;
                } else if (resultSet.getString("description_type").equalsIgnoreCase("LongDescription")) {
                    languageDescription.setLongDescription(resultSet.getString("description_value"));
                    ++n;
                }
            }
            string = resultSet.getString("language");
        }
    }

    public static String getRootDataType(String string) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (string.startsWith("TIMESTAMP") || string.startsWith("INTERVAL")) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!Character.isLetter(c) && !Character.isSpaceChar(c)) continue;
                stringBuffer.append(c);
            }
        } else {
            stringBuffer = new StringBuffer(string);
        }
        return stringBuffer.toString();
    }

    private void setCustomOrderDetails(CubeDimension cubeDimension, String string) {
        Object object;
        OrderByClause orderByClause = (OrderByClause)SyntaxObject.fromSyntax((String)string, null);
        OrderByElement orderByElement = orderByClause.getElements()[0];
        boolean bl = orderByElement.isAscending();
        boolean bl2 = orderByElement.isNullsFirst();
        String[] stringArray = null;
        String string2 = null;
        TypedExpression typedExpression = orderByElement.getExpression();
        if (typedExpression != null && (object = typedExpression.toSyntax()) != null) {
            IdentifierElement identifierElement = new IdentifierElement((String)object);
            if (identifierElement.getCount() == 2) {
                string2 = identifierElement.getSecond();
            }
            if (identifierElement.getCount() == 3) {
                string2 = identifierElement.getThird();
            }
            if (string2.indexOf("\"") >= 0) {
                stringArray = string2.split("\"");
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    if (string3.length() == 0) continue;
                    stringBuffer.append(string3);
                }
                string2 = stringBuffer.toString();
            }
        }
        if ((object = cubeDimension.findAttribute(string2)) != null) {
            cubeDimension.setDimensionSortAttributeName(((CubeDimensionAttribute)object).getOriginalAttributeName());
        }
        if (bl) {
            cubeDimension.setDimensionSortOrder("ASC");
        } else {
            cubeDimension.setDimensionSortOrder("DESC");
        }
        if (bl2) {
            cubeDimension.setDimensionNullSortOrder("FIRST");
        } else {
            cubeDimension.setDimensionNullSortOrder("LAST");
        }
    }
}

