/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels.aggregation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import oracle.olap.OLAPResources;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.templates.templatedialog.SyntaxListener;
import oracle.olap.app.templates.templatedialog.TemplateGUI;
import oracle.olap.app.templates.templatedialogimpl.TemplateHelperImpl;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateMetadata;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.app.templates.view.TemplateHyperContextImpl;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.util.OLAPFetchIcon;

public class AggregationBuilderPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(AggregationBuilderPanel.class.getName());
    private Schema schema;
    private String cubeName;
    private Connection conn;
    private JPanel templateContainer;
    private JTextPane expressionPane;

    public AggregationBuilderPanel() {
        super(new BorderLayout());
        this.layoutComponents();
    }

    public String getExpression() {
        String string = this.expressionPane.getText();
        string = string.replaceAll("'", "''");
        return string;
    }

    public void layoutComponents() {
        this.templateContainer = new JPanel(new BorderLayout());
        this.expressionPane = new JTextPane();
        JScrollPane jScrollPane = new JScrollPane(this.expressionPane);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.templateContainer, "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "Center");
    }

    public void initializePanel(Schema schema, String string, Connection connection) {
        try {
            this.schema = schema;
            this.conn = connection;
            Cube cube = schema.findCube(string);
            this.expressionPane.setText(cube.getConsistentSolveSpec());
            TemplateGroup templateGroup = (TemplateGroup)JavaXMLBind.BindToJava(AggregationBuilderPanel.class.getResource("aggregationtemplates.xml"), "oracle.olap.app.templates.templatelist", null);
            TemplateMetadata templateMetadata = new TemplateMetadata(cube);
            TemplateContext templateContext = new TemplateContext(null, templateMetadata);
            OLAPResources oLAPResources = new OLAPResources("/oracle/olap/cube/panels/aggregation/aggregationtemplates.xml");
            TemplateHyperContextImpl templateHyperContextImpl = new TemplateHyperContextImpl(connection, oLAPResources, new OLAPFetchIcon(), TemplateHyperContext.ResizeMode.TEMPLATE);
            Properties properties = new Properties();
            properties.setProperty("CUBE", cube.getName());
            OLAPISyntaxParser oLAPISyntaxParser = new OLAPISyntaxParser(schema, properties);
            TemplateHelperImpl templateHelperImpl = new TemplateHelperImpl(templateGroup, templateContext, templateHyperContextImpl, oLAPISyntaxParser);
            TemplateGUI templateGUI = templateHelperImpl.getGUI(true);
            Component component = templateGUI.getComponent();
            this.templateContainer.add(component);
            ParseNode parseNode = this.getParseTree(cube, oLAPISyntaxParser);
            templateGUI.loadParseNode(parseNode.getChildren().get(0), cube.getConsistentSolveSpec());
            LOG.finest(String.format("Solve Expression matches: %s", templateHelperImpl.matchesPattern(parseNode.getChildren().get(0))));
            templateGUI.addSyntaxListener(new SyntaxListener(){

                @Override
                public void syntaxChanged(Object object, String string) {
                    AggregationBuilderPanel.this.expressionPane.setText(string);
                }
            });
            component.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    AggregationBuilderPanel.this.templateContainer.validate();
                    AggregationBuilderPanel.this.templateContainer.getParent().validate();
                }
            });
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Error initializing aggregation builder panel", exception);
        }
    }

    private ParseNode getParseTree(Cube cube, SyntaxParser syntaxParser) {
        ParseNode parseNode = new ParseNode();
        syntaxParser.setSyntax(cube.getConsistentSolveSpec());
        boolean bl = syntaxParser.parseSyntax(parseNode);
        if (!bl) {
            LOG.severe(String.format("Consistent Solve [%s] is invalid", cube.getConsistentSolveSpec()));
        }
        for (Throwable serializable : syntaxParser.getExceptions()) {
            LOG.log(Level.SEVERE, "Error Parsing Solve", serializable);
        }
        ParseNode parseNode2 = parseNode.getChildren().get(0);
        if (parseNode2.getChildCount() < cube.getDimensions().size()) {
            Object object;
            ParseNode parseNode3 = parseNode2.getChildren().get(0);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SOLVE (");
            String string = parseNode3.getFullValue();
            int n = string.lastIndexOf("ALL");
            string = string.substring(0, n);
            Iterator<Dimension> iterator = cube.getDimensions().iterator();
            if (iterator.hasNext()) {
                object = iterator.next();
                stringBuilder.append(string);
                stringBuilder.append(((NamedObject)object).getName());
                while (iterator.hasNext()) {
                    object = iterator.next();
                    stringBuilder.append(',');
                    stringBuilder.append(string);
                    stringBuilder.append(((NamedObject)object).getName());
                }
            }
            stringBuilder.append(')');
            object = stringBuilder.toString();
            syntaxParser.setSyntax((String)object);
            bl = syntaxParser.parseSyntax(parseNode);
            if (!bl) {
                LOG.severe(String.format("Built Consistent Solve [%s] is invalid", object));
            }
            for (Throwable throwable : syntaxParser.getExceptions()) {
                LOG.log(Level.SEVERE, "Error Parsing Built Solve", throwable);
            }
        }
        return parseNode;
    }
}

