/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.buildreports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ControlBar;
import oracle.olap.OLAPArb;
import oracle.olap.app.table.QueryComponent;
import oracle.olap.app.table.QueryPanel;
import oracle.olap.buildreports.BuildTimerComboBox;
import oracle.olap.util.SQLViewerDialogLauncher;

public class BuildSummaryPanel
extends JPanel {
    private static final Pattern integer = Pattern.compile("[\\d]+");
    private QueryPanel m_summaryPanel;
    private GridBagConstraints bottomConstraints;
    private BuildTimerComboBox m_queryDelayComboBox;
    private JLabel m_timerLabel;
    private Runnable runnableQueries;
    private JButton showSQLBtn;
    private JLabel totalsLabel;
    private static final int ROWS_ADDED = 3;
    private static final int ROWS_DELETED = 4;
    private static final int ROWS_REJECTED = 5;

    public BuildSummaryPanel(QueryComponent queryComponent, Runnable runnable) {
        this.runnableQueries = runnable;
        this.m_summaryPanel = (QueryPanel)queryComponent;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = null;
            String string2 = exception.getLocalizedMessage();
            if (string2 == null || string2.length() == 0) {
                string2 = exception.getClass().toString();
            }
            String string3 = OLAPArb.get("BUILD_ERROR_DLG_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string);
        }
    }

    private void init() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(300, 300);
        this.setPreferredSize(new Dimension(300, 300));
        JLabel jLabel = new JLabel(OLAPArb.get("BUILD_WIZARD_SUMMARY"));
        this.m_timerLabel = new JLabel(OLAPArb.get("BUILD_WIZARD.STATUS.BUILD_MAINTENANCE_QUERYTIMER"));
        this.m_queryDelayComboBox = new BuildTimerComboBox(this.runnableQueries);
        this.showSQLBtn = new JButton(OLAPArb.getString("TIME_GEN_WIZARD_SHOW_SQL"));
        this.showSQLBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLViewerDialogLauncher.launchDialog(BuildSummaryPanel.this.m_summaryPanel, BuildSummaryPanel.this.m_summaryPanel.getQuerySQL(), BuildSummaryPanel.this.m_summaryPanel.getQuery().getName(), 1);
            }
        });
        this.totalsLabel = new JLabel(" ");
        this.bottomConstraints = new GridBagConstraints();
        this.bottomConstraints.gridx = 0;
        this.bottomConstraints.gridy = 0;
        this.bottomConstraints.gridwidth = 3;
        this.bottomConstraints.gridheight = 1;
        this.bottomConstraints.weightx = 1.0;
        this.bottomConstraints.weighty = 0.0;
        this.bottomConstraints.fill = 0;
        this.bottomConstraints.anchor = 10;
        this.bottomConstraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)jLabel, this.bottomConstraints);
        JPanel jPanel = new JPanel();
        jPanel.add(this.m_timerLabel);
        jPanel.add(this.m_queryDelayComboBox);
        jPanel.add(this.showSQLBtn);
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)jPanel);
        this.m_summaryPanel.addTitleControlBar(controlBar);
        this.m_summaryPanel.setTitlebarLabel(this.totalsLabel);
        this.bottomConstraints.anchor = 10;
        this.bottomConstraints.gridx = 0;
        this.bottomConstraints.gridy = 2;
        this.bottomConstraints.gridwidth = 5;
        this.bottomConstraints.gridheight = 1;
        this.bottomConstraints.weightx = 1.0;
        this.bottomConstraints.weighty = 1.0;
        this.bottomConstraints.insets = new Insets(0, 0, 0, 0);
        this.bottomConstraints.fill = 1;
        this.bottomConstraints.anchor = 10;
        this.add((Component)this.m_summaryPanel, this.bottomConstraints);
    }

    public void stopTimer() {
        this.m_queryDelayComboBox.setEnabled(false);
    }

    public void setDelayTimer(int n) {
        this.m_queryDelayComboBox.setTimerDelay(n);
    }

    public void refresh() throws Exception {
        this.m_summaryPanel.refresh();
        this.updateTotalsLabel();
    }

    public void cleanup() {
        this.m_summaryPanel.cleanup();
        this.m_summaryPanel = null;
        this.bottomConstraints = null;
        this.m_timerLabel = null;
        this.m_queryDelayComboBox = null;
        this.runnableQueries = null;
    }

    public void updateTotalsLabel() {
        this.totalsLabel.setText(this.calculateTotals());
    }

    protected boolean isInteger(String string) {
        return string != null && string.length() > 0 ? integer.matcher(string).matches() : false;
    }

    private String calculateTotals() {
        TableModel tableModel = this.m_summaryPanel.getQueryTableModel();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = tableModel.getRowCount();
        for (int i = 0; i < n4; ++i) {
            String string;
            String string2;
            String string3 = (String)tableModel.getValueAt(i, 3);
            if (this.isInteger(string3)) {
                n += Integer.valueOf(string3).intValue();
            }
            if (this.isInteger(string2 = (String)tableModel.getValueAt(i, 4))) {
                n2 += Integer.valueOf(string2).intValue();
            }
            if (!this.isInteger(string = (String)tableModel.getValueAt(i, 5))) continue;
            n3 += Integer.valueOf(string).intValue();
        }
        return OLAPArb.format("TIME_GEN_WIZARD_TOTALS_SUMMARY_LABEL", n, n2, n3);
    }
}

