/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.olap.OLAPArb;
import oracle.olap.app.Resources;
import oracle.olap.app.hyper.HyperLabel;
import oracle.olap.app.hyper.HyperLabelActionListener;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templatelist.QDRData;
import oracle.olap.app.templates.templateview.MeasureSelector;
import oracle.olap.app.templates.templateview.MeasureTreeNode;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.syntaxbuilder.olapihelpers.Type;
import oracle.olap.syntaxbuilder.spec.Filter;
import oracle.olap.syntaxbuilder.spec.FilterIterator;

public class TemplateHyperParamMeasure
extends TemplateHyperParam {
    private static final int LENGTH = 30;
    private static final Logger LOG = Logger.getLogger(TemplateHyperParamMeasure.class.getName());
    private static final String DEFAULT_NAME = "measure";
    private final String PROPERTY_ID = "id";
    private static final String BASE = "BASE";
    private static final String DERIVED = "DERIVED";
    private static final ParseNode pattern = new ParseNode("measure", Type.MEASURE.toString(), ParseNode.PatternType.SKIP_CHILDREN);
    private final HyperLabel qdrComponent;
    protected final HyperLabel button;
    private final JLabel label;
    private final JPanel gui = new JPanel(new FlowLayout(0, 0, 0));
    private String measure;
    private List<QDRData> qdr;
    protected Cube cube;
    protected MeasureSelector selector;
    protected MeasureTreeNode root;
    private boolean abreviate;
    private DimensionHierarchy selectedHierarchy;
    private Dimension lastDimSelection;

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() instanceof DimensionHierarchy) {
            this.selectedHierarchy = (DimensionHierarchy)propertyChangeEvent.getNewValue();
        } else if (propertyChangeEvent.getNewValue() instanceof Dimension) {
            Dimension dimension = (Dimension)propertyChangeEvent.getNewValue();
            if (!(this.getTemplateHyperContext().isTimeTemplate() || this.lastDimSelection != null && this.lastDimSelection.getName().equals(dimension.getName()))) {
                this.lastDimSelection = dimension;
                this.refreshQDR();
            }
            DimensionHierarchy dimensionHierarchy = dimension.getDefaultHierarchy();
            if (this.selectedHierarchy != null && dimensionHierarchy != null && !dimensionHierarchy.getDimension().getName().equals(this.selectedHierarchy.getDimension().getName())) {
                this.selectedHierarchy = dimensionHierarchy;
            }
        }
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    private void setDefaultValue() {
        if (this.root == null) {
            return;
        }
        MeasureTreeNode measureTreeNode = null;
        int[] nArray = new int[]{0};
        try {
            String string = this.getDefault();
            if (string != null) {
                nArray[0] = Math.max(0, Integer.parseInt(string) - 1);
            }
        }
        catch (Exception exception) {
            nArray[0] = 0;
        }
        measureTreeNode = this.iterateCubes(BASE, nArray);
        if (nArray[0] >= 0) {
            measureTreeNode = this.iterateCubes(DERIVED, nArray);
        }
        if (measureTreeNode != null) {
            this.setQDR(null, false);
            this.setValue(measureTreeNode);
        }
    }

    private MeasureTreeNode iterateCubes(String string, int[] nArray) {
        FilterIterator<Measure> filterIterator = new FilterIterator<Measure>(this.cube.getMeasures(), new MeasureFilter(string));
        MeasureTreeNode measureTreeNode = this.iterateMeasures(filterIterator, nArray);
        MeasureTreeNode measureTreeNode2 = null;
        if (nArray[0] >= 0) {
            for (Cube cube : this.cube.getSchema().getCubes()) {
                if (cube == this.cube) continue;
                filterIterator = new FilterIterator<Measure>(cube.getMeasures(), new MeasureFilter(BASE));
                measureTreeNode2 = this.iterateMeasures(filterIterator, nArray);
                if (measureTreeNode2 != null) {
                    measureTreeNode = measureTreeNode2;
                }
                if (nArray[0] >= 0) continue;
                break;
            }
        }
        return measureTreeNode;
    }

    private MeasureTreeNode iterateMeasures(FilterIterator<Measure> filterIterator, int[] nArray) {
        MeasureTreeNode measureTreeNode = null;
        MeasureTreeNode measureTreeNode2 = null;
        for (Measure measure : filterIterator) {
            measureTreeNode = this.root.find(measure.getID());
            if (measureTreeNode == null) continue;
            measureTreeNode2 = measureTreeNode;
            int n = nArray[0];
            nArray[0] = n - 1;
            if (n > 0) continue;
            break;
        }
        return measureTreeNode2;
    }

    public TemplateHyperParamMeasure() {
        this.gui.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.button = this.createButton();
        this.label = new JLabel(OLAPArb.getString("CALC_EDITOR_NESTED_EXPRESION_LABEL"));
        this.label.setVisible(false);
        this.qdrComponent = this.getQDRComponent();
        this.setName(DEFAULT_NAME);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(this.label);
        jPanel.add(this.button);
        this.gui.add(this.button);
        this.gui.add(this.label);
        if (this.qdrComponent != null) {
            this.gui.add(this.qdrComponent);
        }
    }

    private HyperLabel createButton() {
        HyperLabel hyperLabel = new HyperLabel("");
        hyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                if (TemplateHyperParamMeasure.this.measure != null) {
                    TemplateHyperParamMeasure.this.selector.setNode(TemplateHyperParamMeasure.this.measure);
                }
                if (TemplateHyperParamMeasure.this.selector.showPickerDialog()) {
                    TemplateHyperParamMeasure.this.setValue(TemplateHyperParamMeasure.this.selector.getValue());
                }
            }
        });
        return hyperLabel;
    }

    @Override
    public Component getComponent() {
        return this.gui;
    }

    @Override
    public Object getValue() {
        return this.measure;
    }

    @Override
    public boolean setValue(Object object) {
        MeasureTreeNode measureTreeNode = null;
        List<QDRData> list = null;
        String string = null;
        String string2 = null;
        if (this.cube != null) {
            string2 = this.cube.getSchema().getName();
        }
        if (object == null) {
            this.setDefaultValue();
            return true;
        }
        if (object instanceof ParseNode) {
            ParseNode parseNode = (ParseNode)object;
            string = Type.valueFrom(parseNode.getType()) == Type.QDR ? ((ParseNode)parseNode.getChildAt(0)).getFullValue() : parseNode.getFullValue();
            measureTreeNode = this.selector.setNode(this.stripSchema(string, string2));
            list = this.buildQDR();
            QDRData qDRData = null;
            block0: for (ParseNode parseNode2 : parseNode.getChildren()) {
                int n;
                String string3;
                if (parseNode2.getType().equals(Type.DIMENSION.toString())) {
                    string3 = this.stripSchema(parseNode2.getValue(), string2);
                    n = 0;
                    if (string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                        ++n;
                    }
                    for (QDRData qDRData2 : list) {
                        if (!string3.regionMatches(true, n, qDRData2.getDimension(), 0, qDRData2.getDimension().length())) continue;
                        qDRData = qDRData2;
                        continue block0;
                    }
                    continue;
                }
                if (qDRData == null) continue;
                string3 = parseNode2.getFullValue();
                if (parseNode2.getType().equals(Type.STRING.toString())) {
                    qDRData.setQuoteMemberExpression(true);
                    n = 0;
                    int n2 = string3.length();
                    if (string3.indexOf(39) == 0) {
                        n = 1;
                    }
                    if (string3.lastIndexOf(39) == string3.length() - 1) {
                        n2 = string3.length() - 1;
                    }
                    if (n != 0 || n2 != string3.length()) {
                        string3 = string3.substring(n, n2);
                    }
                } else {
                    string3 = parseNode2.getFullValue();
                    qDRData.setQuoteMemberExpression(false);
                }
                qDRData.setMemberKey(string3);
                qDRData.setMemberDescription(null);
                qDRData = null;
            }
        } else if (object != null && this.selector != null) {
            string = object.toString();
            measureTreeNode = this.selector.setNode(this.stripSchema(object.toString(), string2));
        }
        if (measureTreeNode != null) {
            this.setQDR(list, false);
            this.button.setVisible(true);
            this.label.setVisible(false);
            this.setValue(measureTreeNode);
            this.abreviate = false;
        } else if (string != null) {
            this.setQDR(list, false);
            this.button.setVisible(false);
            this.label.setVisible(true);
            this.setValue(string, "");
            this.abreviate = true;
        } else {
            this.setQDR(list, true);
        }
        return true;
    }

    void setValue(String string, String string2) {
        if (this.measure != null && this.measure.equals(string)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", this.measure, string);
        boolean bl = this.isValid();
        this.measure = string;
        this.button.setToolTipText(string);
        this.label.setToolTipText(string);
        if (string2.length() > 30) {
            string2 = String.format("%s...", string2.substring(0, 27));
        }
        this.button.setText(string2);
        this.firePropertyChangeEvent(propertyChangeEvent);
        boolean bl2 = this.isValid();
        if (bl2 != bl) {
            propertyChangeEvent = new PropertyChangeEvent(this, "VALID_PROPERTY", bl, bl2);
            this.firePropertyChangeEvent(propertyChangeEvent);
        }
    }

    void setValue(MeasureTreeNode measureTreeNode) {
        this.setValue(measureTreeNode.getID(), measureTreeNode.toString());
    }

    @Override
    public String getExpression(String string) {
        if ("id".equals(string)) {
            return this.measure;
        }
        String string2 = this.generateQDRText(false);
        if (string2 != null) {
            return this.measure + string2;
        }
        return this.measure;
    }

    @Override
    public String getExpression() {
        return this.getExpression(null);
    }

    void setCube(Cube cube) {
        this.cube = cube;
        Resources resources = this.getTemplateHyperContext().getResources();
        this.root = new MeasureTreeNode(cube.getAWName(), cube, cube.getSchema().getCubes(), resources, this.getTemplateHyperContext().getFetchIcon());
        this.selector = new MeasureSelector(this.root, resources, this.button);
    }

    public boolean setQDR(List<QDRData> list, boolean bl) {
        Object object;
        if (this.qdr == null) {
            return false;
        }
        boolean bl2 = false;
        if (list == null) {
            for (QDRData qDRData : this.qdr) {
                if (qDRData.getMemberKey() == null) continue;
                bl2 = true;
                qDRData.setMemberDescription(null);
                qDRData.setMemberKey(null);
            }
        } else {
            object = this.getTemplateHyperContext().getConnection();
            DBUtil dBUtil = DBUtil.getInstance((Connection)object);
            for (QDRData qDRData : this.qdr) {
                boolean bl3 = true;
                for (QDRData qDRData2 : list) {
                    if (!qDRData.getDimension().equals(qDRData2.getDimension())) continue;
                    bl3 = false;
                    if (qDRData.equals(qDRData2)) continue;
                    bl2 = true;
                    qDRData.setData(qDRData2);
                    if (qDRData.getMemberKey() == null || qDRData.getMemberDescription() != null) break;
                    this.getMemberFromDB(qDRData, (Connection)object, dBUtil);
                    break;
                }
                if (!bl3 || qDRData.getMemberKey() == null) continue;
                bl2 = true;
                qDRData.setMemberDescription(null);
                qDRData.setMemberKey(null);
            }
        }
        if (bl2 && bl) {
            this.refreshQDR();
        } else {
            object = this.generateQDRText(true);
            this.setQDRText(this.qdrComponent, (String)object);
        }
        return bl2;
    }

    private void refreshQDR() {
        String string = this.generateQDRText(true);
        this.setQDRText(this.qdrComponent, string);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", null, this.qdr);
        LOG.finest("Firing change" + propertyChangeEvent);
        this.firePropertyChangeEvent(propertyChangeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMemberFromDB(QDRData qDRData, Connection connection, DBUtil dBUtil) {
        Dimension dimension = this.cube.getSchema().findDimension(qDRData.getDimension());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("key", qDRData.getMemberKey());
        String string = "SELECT %1$s KEY, %2$s VALUE FROM %3$s WHERE %1$s = :key";
        String string2 = dimension.getKeyColumnName();
        String string3 = dimension.getShortDescriptionColumnName();
        String string4 = dimension.getViewName();
        string = String.format(string, string2, string3, string4);
        if (Connections.getInstance().lock(connection)) {
            ResultSet resultSet;
            block5: {
                resultSet = null;
                try {
                    resultSet = dBUtil.executeQuery(string, hashMap);
                    if (!resultSet.next()) break block5;
                    String string5 = resultSet.getString("VALUE");
                    qDRData.setMemberDescription(string5);
                }
                catch (SQLException sQLException) {
                    try {
                        LOG.warning(String.format("Could not load member value for %s", qDRData.getExpression()));
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
    }

    public Cube getCube() {
        return this.cube;
    }

    protected HyperLabel getQDRComponent() {
        HyperLabel hyperLabel = new HyperLabel("(...)");
        hyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                String string2 = null;
                if (TemplateHyperParamMeasure.this.selectedHierarchy != null) {
                    string2 = TemplateHyperParamMeasure.this.selectedHierarchy.getName();
                }
                ArrayList<QDRData> arrayList = TemplateHyperParamMeasure.this.qdr;
                if (TemplateHyperParamMeasure.this.lastDimSelection != null) {
                    ArrayList<QDRData> arrayList2 = new ArrayList<QDRData>();
                    for (QDRData qDRData : arrayList) {
                        if (TemplateHyperParamMeasure.this.lastDimSelection.getName().equals(qDRData.getDimension())) continue;
                        arrayList2.add(qDRData);
                    }
                    arrayList = arrayList2;
                }
                if ((arrayList = TemplateHyperParamMeasure.this.getTemplateHyperContext().showQDRSelector((List<QDRData>)arrayList, TemplateHyperParamMeasure.this.getCube().getSchema().getName(), string2)) != null) {
                    TemplateHyperParamMeasure.this.setQDR(arrayList, true);
                }
            }
        });
        return hyperLabel;
    }

    private String generateQDRText(boolean bl) {
        if (this.qdr == null) {
            return null;
        }
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder("[");
        for (QDRData qDRData : this.qdr) {
            if (this.lastDimSelection != null && qDRData.getDimension().equals(this.lastDimSelection.getName())) {
                qDRData.setMemberDescription(null);
                qDRData.setMemberKey(null);
                continue;
            }
            if (qDRData.getMemberKey() == null) continue;
            bl2 = true;
            if (bl) {
                stringBuilder.append(qDRData.toString());
            } else {
                stringBuilder.append(qDRData.getExpression());
            }
            stringBuilder.append(",");
        }
        if (bl2) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
        return null;
    }

    private void setQDRText(JComponent jComponent, String string) {
        if (jComponent == null) {
            return;
        }
        if (string == null) {
            ((HyperLabel)jComponent).setText("(...)");
        } else {
            ((HyperLabel)jComponent).setText(string);
        }
    }

    @Override
    public void init() {
        this.setCube(this.getTemplateContext().getCube());
        this.qdr = this.buildQDR();
        this.setDefaultValue();
    }

    protected List<QDRData> buildQDR() {
        ArrayList<QDRData> arrayList = new ArrayList<QDRData>(this.getCube().getDimensions().size());
        for (Dimension dimension : this.getCube().getDimensions()) {
            arrayList.add(new QDRData(dimension.getName(), null, null));
        }
        return arrayList;
    }

    @Override
    public int getPixelSize(int n) {
        int n2 = 0;
        if (this.qdrComponent != null) {
            String string = this.qdrComponent.getText();
            if (string == null) {
                string = "(...)";
            }
            n2 = this.qdrComponent.getFontMetrics(this.qdrComponent.getFont()).stringWidth(string);
        }
        if (this.abreviate) {
            return n2 + this.label.getFontMetrics(this.label.getFont()).stringWidth(this.label.getText());
        }
        return n2 + this.button.getFontMetrics(this.button.getFont()).stringWidth(this.button.getText());
    }

    @Override
    public boolean isValid() {
        return this.getValue() != null;
    }

    private class MeasureFilter
    implements Filter<Measure> {
        private String type;

        public MeasureFilter(String string) {
            this.type = string;
        }

        @Override
        public boolean matches(Measure measure) {
            return this.type.equals(measure.getType());
        }
    }
}

