/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.dbtools.db.DBUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.hyper.HyperLabel;
import oracle.olap.app.hyper.HyperLabelActionListener;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templatelist.Param;
import oracle.olap.app.templates.templatelist.QDRData;
import oracle.olap.app.templates.templateview.ItemElement;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.tree.model.DefaultNode;
import oracle.olap.app.tree.model.HierarchyNodeData;
import oracle.olap.ddl.Identifier;
import oracle.olap.hierarchyviewer.HierarchyET;
import oracle.olap.hierarchyviewer.HierarchyViewerDialog;
import oracle.olap.stringexpr.ParamProperty;
import oracle.olap.stringexpr.ParamStringExpr;
import oracle.olap.syntaxbuilder.olapihelpers.Type;
import oracle.olap.util.OLAPErrorDisplay;

public class TemplateHyperParamDimensionMembers
extends TemplateHyperParam
implements PropertyChangeListener {
    private static Logger LOG = Logger.getLogger(TemplateHyperParamDimensionMembers.class.getName());
    private oracle.olap.app.olapmetadata.Dimension dimension;
    private HyperLabel membersHyperLabel;
    private QDRData[] qdrs = new QDRData[]{new QDRData("", "0", "")};
    private static final String TEMP_DEFAULT = "'Q1'";
    public static final String DIMENSION_PROPERTY = "dimension";
    private static final ParseNode pattern = new ParseNode("dimension_members", null, ParseNode.PatternType.LOOP);

    public TemplateHyperParamDimensionMembers() {
        this.membersHyperLabel = new HyperLabel(TEMP_DEFAULT);
        this.membersHyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                TemplateHyperParamDimensionMembers.this.showDimensionMembersDialog();
            }
        });
    }

    @Override
    public Component getComponent() {
        return this.membersHyperLabel;
    }

    private void showDimensionMembersDialog() {
        block16: {
            TreePath[] treePathArray;
            CharSequence charSequence;
            TreePath[] treePathArray2;
            OLAPErrorDisplay oLAPErrorDisplay = new OLAPErrorDisplay();
            String string = OLAPArb.getString("DIMENSION_MEMBER_SELECTOR_TITLE");
            OLAPResources oLAPResources = new OLAPResources();
            Connection connection = this.getTemplateHyperContext().getConnection();
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            ArrayList<HierarchyET> arrayList = new ArrayList<HierarchyET>();
            List<DimensionHierarchy> list = this.dimension.getHierarchies();
            String string2 = null;
            try {
                if (list == null || list != null && list.isEmpty()) {
                    arrayList.add(new HierarchyET(connection, this.dimension, null));
                } else {
                    boolean bl = false;
                    for (final DimensionHierarchy dimensionHierarchy : list) {
                        treePathArray2 = new HierarchyET(connection, this.dimension, dimensionHierarchy);
                        arrayList.add((HierarchyET)treePathArray2);
                        if (bl) continue;
                        charSequence = "select count({hierarchy.keyColumnName}) from {hierarchy.viewName} where {hierarchy.keyColumnName} in ({hierarchy_members})";
                        ParamProperty paramProperty = new ParamProperty(){

                            @Override
                            public String getParamPropertyValue(String string, String string2, Measure measure, ItemElement itemElement, HashMap<String, String> hashMap) throws SQLException, IOException {
                                Object object = this.getMetadataProperty(string, string2);
                                String string3 = object != null ? object.toString() : null;
                                return string3;
                            }

                            private Object getMetadataProperty(String string, String string2) {
                                Object object = null;
                                if (string.equalsIgnoreCase("hierarchy")) {
                                    object = dimensionHierarchy.getValue(string2);
                                }
                                if (string.equalsIgnoreCase("hierarchy_members")) {
                                    int n = 0;
                                    StringBuffer stringBuffer = new StringBuffer();
                                    for (QDRData qDRData : TemplateHyperParamDimensionMembers.this.qdrs) {
                                        String string3 = qDRData.getMemberKey();
                                        string3 = n == 0 ? "'" + string3 + "'" : ",'" + string3 + "'";
                                        stringBuffer.append(string3);
                                        ++n;
                                    }
                                    return stringBuffer;
                                }
                                return object;
                            }
                        };
                        treePathArray = ParamStringExpr.getInstance();
                        String string3 = treePathArray.getExpression((String)charSequence, null, paramProperty, null, null, null);
                        String string4 = dBUtil.executeReturnOneCol(string3, new ArrayList());
                        int n = Integer.valueOf(string4);
                        if (n != this.qdrs.length) continue;
                        bl = true;
                        string2 = dimensionHierarchy.getName();
                    }
                }
            }
            catch (SQLException sQLException) {
                LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
            }
            catch (IOException iOException) {
                LOG.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
            }
            if (arrayList.size() > 0) {
                try {
                    Object object;
                    String string5 = null;
                    if (string2 != null) {
                        string5 = string2;
                    } else {
                        object = this.dimension.getDefaultHierarchy();
                        if (object != null) {
                            string5 = ((NamedObject)object).getName();
                        }
                    }
                    HierarchyViewerDialog hierarchyViewerDialog = new HierarchyViewerDialog(SwingUtilities.getWindowAncestor(this.membersHyperLabel), string, arrayList, string5, oLAPResources, "SELECT_DIMENSION_MEMBERS_MODE", this.qdrs);
                    hierarchyViewerDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                    object = new Dimension(350, 400);
                    hierarchyViewerDialog.setPreferredSize((Dimension)object);
                    hierarchyViewerDialog.setSize((Dimension)object);
                    hierarchyViewerDialog.setLocationRelativeTo(this.membersHyperLabel);
                    hierarchyViewerDialog.setVisible(true);
                    boolean bl = hierarchyViewerDialog.isOKSelected();
                    if (!bl) break block16;
                    treePathArray2 = hierarchyViewerDialog.getTree().getSelectionPaths();
                    charSequence = new StringBuffer();
                    if (treePathArray2 != null) {
                        this.qdrs = new QDRData[treePathArray2.length];
                        int n = 0;
                        for (TreePath treePath : treePathArray2) {
                            Object object2 = treePath.getLastPathComponent();
                            DefaultNode defaultNode = (DefaultNode)object2;
                            if (!(defaultNode.getUserObject() instanceof HierarchyNodeData)) continue;
                            HierarchyNodeData hierarchyNodeData = (HierarchyNodeData)defaultNode.getUserObject();
                            ((StringBuffer)charSequence).append("'" + hierarchyNodeData.dimKey + "'");
                            ((StringBuffer)charSequence).append(",");
                            this.qdrs[n++] = new QDRData(this.dimension, hierarchyNodeData.dimKey, hierarchyNodeData.desc);
                        }
                        if (((StringBuffer)charSequence).charAt(((StringBuffer)charSequence).length() - 1) == ',') {
                            ((StringBuffer)charSequence).deleteCharAt(((StringBuffer)charSequence).length() - 1);
                        }
                        this.setValue(charSequence);
                        treePathArray = null;
                        CharSequence charSequence2 = charSequence;
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", treePathArray, charSequence2);
                        this.firePropertyChangeEvent(propertyChangeEvent);
                    }
                }
                catch (Exception exception) {
                    oLAPErrorDisplay.show(exception, OLAPArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR"), OLAPArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR_TITLE"), this.membersHyperLabel);
                    LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
            } else {
                String string6 = null;
                MessageDialog.error((Component)this.membersHyperLabel, (Object)OLAPArb.get("DIMENSION_MEMBER_SELECTOR_NOT_FOUND"), (String)OLAPArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR_TITLE"), string6);
            }
        }
    }

    @Override
    public int getPixelSize(int n) {
        String string = this.membersHyperLabel.getText();
        if (string.length() > 0) {
            return this.membersHyperLabel.getFontMetrics(this.membersHyperLabel.getFont()).stringWidth(string);
        }
        return 100;
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() instanceof oracle.olap.app.olapmetadata.Dimension) {
            oracle.olap.app.olapmetadata.Dimension dimension = (oracle.olap.app.olapmetadata.Dimension)propertyChangeEvent.getNewValue();
            this.setDimension(dimension);
        }
    }

    private void setDimension(oracle.olap.app.olapmetadata.Dimension dimension) {
        if (this.dimension == dimension) {
            return;
        }
        this.dimension = dimension;
        Param param = this.getParam();
        if (param == null) {
            return;
        }
        String string = param.getDefault();
        Connection connection = this.getTemplateHyperContext().getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        this.setValue(TEMP_DEFAULT);
        try {
            String string2 = this.getBaseTemplateHyperView().getExpression(string, null);
            String string3 = dBUtil.executeReturnOneCol(string2, new ArrayList());
            if (string3 != null) {
                this.qdrs = new QDRData[]{new QDRData(dimension, string3, "")};
                this.setValue("'" + string3 + "'");
            }
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
    }

    @Override
    public Object getValue() {
        return this.qdrs;
    }

    @Override
    public String getExpression() {
        return this.membersHyperLabel.getText();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    public void setDefault(String string) {
        if (!string.toLowerCase().startsWith("select ")) {
            super.setDefault(string);
        }
    }

    @Override
    public boolean setValue(Object object) {
        if (object instanceof List) {
            StringBuffer stringBuffer = new StringBuffer();
            List list = (List)object;
            this.qdrs = new QDRData[list.size()];
            int n = 0;
            for (ParseNode parseNode : list) {
                stringBuffer.append(parseNode.getValue() + ",");
                String string = parseNode.getValue();
                string = Identifier.stripQuotes(string);
                this.qdrs[n++] = new QDRData(this.dimension, string, string);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            this.membersHyperLabel.setText(stringBuffer.toString());
        } else {
            this.membersHyperLabel.setText(object.toString());
        }
        return true;
    }

    static {
        pattern.add(new ParseNode("dimension_members", Type.STRING.toString(), ParseNode.PatternType.NONE));
    }
}

