/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.editor.EditorManager;
import oracle.olap.OLAPArb;
import oracle.olap.app.hyper.HyperLabel;
import oracle.olap.app.hyper.HyperLabelActionListener;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.TemplateHyperParamCombo;
import oracle.olap.dml.DMLProgram;
import oracle.olap.dml.NewDMLProgram;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class TemplateHyperParamDMLProgram
extends TemplateHyperParamCombo {
    private static final Logger LOG = Logger.getLogger(TemplateHyperParamDMLProgram.class.getName());
    private static final ParseNode pattern = new ParseNode("dmlprogram", Type.DMLPROGRAM.toString(), false);
    private final JPanel gui;
    private final HyperLabel dots;
    private final DMLProgram newProgram = new DMLProgram(null, null, null, OLAPArb.getString("EXPRESSION_EDITOR_NEW_PROGRAM"));
    static final HashMap<String, SQLDetails> dmlTosql;

    @Override
    public boolean setValue(Object object) {
        Object object2;
        String string = null;
        if (object instanceof ParseNode) {
            object2 = (ParseNode)object;
            if (Type.valueFrom(((ParseNode)object2).getType()) == Type.DMLPROGRAM) {
                string = ((ParseNode)object2).getValue();
                int n = string.indexOf(33);
                n = n == -1 ? 1 : ++n;
                string = string.substring(n, string.length() - 1);
            }
        } else {
            string = String.valueOf(object);
        }
        if (string != null) {
            object2 = this.getTemplateContext().getCube().getAWName();
            AnalyticWorkspace analyticWorkspace = this.getTemplateContext().getSchema().findAW((String)object2);
            DMLProgram dMLProgram = analyticWorkspace.findDMLProgram(string);
            if (dMLProgram != null) {
                this.setSelectedElement(dMLProgram);
            }
        }
        return false;
    }

    public TemplateHyperParamDMLProgram() {
        this.newProgram.setDataType("DECIMAL");
        final ListCellRenderer listCellRenderer = this.hyperCombo.getRenderer();
        this.hyperCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                DMLProgram dMLProgram = (DMLProgram)object;
                return listCellRenderer.getListCellRendererComponent(jList, dMLProgram.getName(), n, bl, bl2);
            }
        });
        this.gui = new JPanel(new FlowLayout(0, 3, 0));
        this.gui.add(this.hyperCombo);
        this.dots = new HyperLabel("...");
        this.gui.add(this.dots);
        this.dots.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                TemplateHyperParamDMLProgram.this.displaySource();
            }
        });
    }

    private void displaySource() {
        DMLProgram dMLProgram = (DMLProgram)this.getValue();
        if (dMLProgram == this.newProgram) {
            this.createProgram();
        } else {
            String string = this.getTemplateContext().getSchema().getName();
            Connection connection = this.getTemplateHyperContext().getConnection();
            String string2 = Connections.getInstance().getConnectionName(connection);
            String string3 = dMLProgram.getAWName();
            String string4 = dMLProgram.getName();
            URL uRL = NewDMLProgram.buildProgramURL(string2, string, string3, string4);
            EditorManager.getEditorManager().openDefaultEditorInFrame(uRL);
        }
    }

    @Override
    public int getPixelSize(int n) {
        int n2 = this.dots.getFontMetrics(this.dots.getFont()).stringWidth("...");
        return super.getPixelSize(n) + n2;
    }

    @Override
    public Component getComponent() {
        return this.gui;
    }

    @Override
    public String getErrorMessage() {
        return OLAPArb.getString("EXPRESSION_EDITOR_ERROR_NO_DML_PROGRAM");
    }

    @Override
    public String getExpression() {
        DMLProgram dMLProgram = (DMLProgram)this.getSelectedElement();
        if (dMLProgram != null) {
            return String.format("'%s!%s'", dMLProgram.getAWName(), dMLProgram.getName());
        }
        return "''";
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItem() == this.newProgram && itemEvent.getStateChange() == 1 && this.getComboBoxModel().getSize() > 1) {
            this.createProgram();
            return;
        }
        super.itemStateChanged(itemEvent);
    }

    /*
     * Exception decompiling
     */
    private void createProgram() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void init() {
        this.dots.getFontMetrics(this.dots.getFont()).stringWidth("...");
        String string = this.getTemplateContext().getCube().getAWName();
        AnalyticWorkspace analyticWorkspace = this.getTemplateContext().getSchema().findAW(string);
        if (analyticWorkspace != null) {
            for (DMLProgram dMLProgram : analyticWorkspace.getDMLPrograms()) {
                if (dMLProgram.getDataType() == null || dMLProgram.getDataType().length() <= 0) continue;
                this.addElement(dMLProgram);
            }
            this.addElement(this.newProgram);
        }
    }

    static {
        pattern.addParamName("dmlprogram");
        dmlTosql = new HashMap();
        dmlTosql.put("BOOLEAN", new SQLDetails("NUMBER(1)", "return 1"));
        dmlTosql.put("DATE", new SQLDetails("DATE", "return 'DATE'"));
        dmlTosql.put("DATETIME", new SQLDetails("DATE", "return 'DATETIME'"));
        dmlTosql.put("DECIMAL", new SQLDetails("DECIMAL(5,2)", "return 1.1"));
        dmlTosql.put("ID", new SQLDetails("NUMBER", "return 1"));
        dmlTosql.put("INTEGER", new SQLDetails("INTEGER", "return 1"));
        dmlTosql.put("LONGINTEGER", new SQLDetails("NUMBER", "return 1"));
        dmlTosql.put("NTEXT", new SQLDetails("NCLOB", "return 'nclob'"));
        dmlTosql.put("NUMBER", new SQLDetails("NUMBER", "return 1"));
        dmlTosql.put("SHORTINTEGER", new SQLDetails("NUMBER", "return 1"));
        dmlTosql.put("SHORT", new SQLDetails("NUMBER", "return 1"));
        dmlTosql.put("TEXT", new SQLDetails("CLOB", "return 'clob'"));
    }

    static class SQLDetails {
        final String sqldataType;
        final String returnStatement;

        public SQLDetails(String string, String string2) {
            this.sqldataType = string;
            this.returnStatement = string2;
        }
    }
}

