/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.dimension;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.olap.app.dimension.ModelRow;

public class SelectMemberTableModel
extends AbstractTableModel {
    Connection m_connection;
    String m_owner;
    String m_dimension;
    String m_hierarchy;
    String m_whereClause = "";
    String m_viewName;
    String m_memberColumn;
    String m_depthColumn;
    String m_descColumn;
    String m_sortColumn;
    String[] m_columnNames = new String[]{"Member", "Description"};
    List<ModelRow> m_modelRows = new ArrayList<ModelRow>();
    private int fetchSize = 1000;

    public SelectMemberTableModel(Connection connection, String string, String string2, String string3) throws SQLException {
        this.m_connection = connection;
        this.m_owner = string;
        this.m_dimension = string2;
        this.m_hierarchy = string3;
        this.cacheViewMetadata();
        this.refresh();
    }

    private void cacheViewMetadata() throws SQLException {
        String string = this.m_hierarchy == null ? "all_cube_dim_view_columns" : "all_cube_hier_view_columns";
        String string2 = this.m_hierarchy == null ? "" : "\n  AND hierarchy_name = ? \n";
        String string3 = this.m_hierarchy == null ? "DIM_ORDER" : "HIER_ORDER";
        String string4 = "SELECT VIEW_NAME, COLUMN_NAME, COLUMN_TYPE \nFROM   " + string + " \n" + "WHERE  owner = ? \n" + "  AND  dimension_name = ? \n" + string2 + "  AND (column_type in ('KEY', '" + string3 + "', 'DEPTH') \n " + "  OR   column_name in ('SHORT_DESCRIPTION', 'LONG_DESCRIPTION'))";
        PreparedStatement preparedStatement = this.m_connection.prepareStatement(string4, 1004, 1007);
        preparedStatement.setString(1, this.m_owner);
        preparedStatement.setString(2, this.m_dimension);
        if (this.m_hierarchy != null) {
            preparedStatement.setString(3, this.m_hierarchy);
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        while (resultSet.next()) {
            this.m_viewName = resultSet.getString("VIEW_NAME");
            string5 = resultSet.getString("COLUMN_TYPE");
            string6 = resultSet.getString("COLUMN_NAME");
            if (string5.equalsIgnoreCase("KEY")) {
                this.m_memberColumn = string6;
                continue;
            }
            if (string5.equalsIgnoreCase("DIM_ORDER") || string5.equalsIgnoreCase("HIER_ORDER")) {
                this.m_sortColumn = string6;
                continue;
            }
            if (string5.equalsIgnoreCase("DEPTH")) {
                this.m_depthColumn = string6;
                continue;
            }
            if (string6.equalsIgnoreCase("SHORT_DESCRIPTION")) {
                string8 = string6;
                continue;
            }
            if (!string6.equalsIgnoreCase("LONG_DESCRIPTION")) continue;
            string7 = string6;
        }
        this.m_descColumn = string7 != null ? string7 : string8;
        this.m_descColumn = this.m_descColumn != null ? this.m_descColumn : "null";
        String string9 = this.m_sortColumn = this.m_sortColumn != null ? this.m_sortColumn : this.m_descColumn;
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private String getQuery() {
        String string = "SELECT member, description";
        if (this.m_sortColumn != null) {
            string = string + ", " + this.m_sortColumn + " \n";
        }
        string = string + "FROM ( \n" + "  SELECT " + this.m_memberColumn + " as MEMBER, ";
        string = this.m_depthColumn != null ? string + "LPAD(' ', " + this.m_depthColumn + " * 3, ' ') || " + this.m_descColumn + " AS DESCRIPTION" : string + this.m_descColumn + " AS DESCRIPTION";
        string = this.m_sortColumn != null ? string + ", " + this.m_sortColumn + " \n" : string + " \n";
        string = string + "   FROM " + this.m_viewName + " \n )";
        if (!this.m_whereClause.equalsIgnoreCase("")) {
            string = string + " \n WHERE " + this.m_whereClause;
        }
        if (this.m_sortColumn != null) {
            string = string + "\n ORDER BY " + this.m_sortColumn + " ASC";
        }
        return string;
    }

    public void setWhereClause(String string) throws SQLException {
        this.m_whereClause = string;
        this.refresh();
    }

    private void refresh() throws SQLException {
        String string = this.getQuery();
        Statement statement = this.m_connection.createStatement(1004, 1007);
        statement.setFetchSize(this.fetchSize);
        ResultSet resultSet = statement.executeQuery(string);
        this.m_modelRows.clear();
        while (resultSet.next()) {
            ModelRow modelRow = new ModelRow();
            modelRow.setValue(resultSet.getString(1));
            modelRow.setDescription(resultSet.getString(2));
            this.m_modelRows.add(modelRow);
        }
        statement.close();
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.m_modelRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.m_columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ModelRow modelRow = this.m_modelRows.get(n);
        if (n2 == 0) {
            return modelRow.getValue();
        }
        return modelRow.getDescription();
    }
}

