/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.privs.PrivAction;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.help.HelpSystem;
import oracle.olap.OLAPResources;
import oracle.olap.actions.CheckBoxActionControl;
import oracle.olap.app.Resources;

public class OLAPPrivAction
extends PrivAction {
    private String op;
    private Connection connection;
    Resources resources = new OLAPResources();
    private static final String EXTEND_TO_AW = "extendToAW";
    private static final String GRANT_ALL = "grantAll";
    private static final String REVOKE_ALL = "revokeAll";
    private static final String USERS = "users";
    private static final String OBJECT = "object";
    private static final String EXTEND_TO_VIEW = "extendToView";
    private static final String WITH_GRANT = "withGrant";
    private static final String SCHEMA = "schema";
    private static final String SHUTTLE = "shuttle";
    private static final String ADDED = "added";
    private static final String REMOVED = "removed";
    private static final String SELECTED = "selected";
    private static final String TRUE = "true";
    private static final String CUBE_NODE = "CUBE_NODE";
    private static final String CUBE_DIMENSION_NODE = "CUBE_DIMENSION_NODE";

    private void loadArgs() {
        String string = this.getArgs();
        String[] stringArray = string.split(",");
        this.op = stringArray[0];
    }

    private Operation getOperation() {
        try {
            Operation operation = Operation.valueOf(this.op);
            return operation;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDBObjectName() {
        String string = super.getDBObjectName();
        String string2 = this.getDbObjectType();
        if (string2.equalsIgnoreCase("OLAPAW")) {
            string = "AW$" + super.getDBObjectName();
        }
        return string;
    }

    protected List<ActionControl> getCustomControls(Connection connection) {
        this.connection = connection;
        this.loadArgs();
        String string = this.getDbObjectType();
        if (string.equalsIgnoreCase("CUBE") || string.equalsIgnoreCase("CUBE DIMENSION") || string.equalsIgnoreCase(CUBE_NODE) || string.equalsIgnoreCase(CUBE_DIMENSION_NODE)) {
            String string2 = "";
            String string3 = "";
            if (string.equalsIgnoreCase("CUBE") || string.equalsIgnoreCase(CUBE_NODE)) {
                string2 = this.resources.getString("OBJECT_SECURITY_CUBE_EXTEND_PRIVS_TO_AW_LABEL", this.getAWName(this.getDBObject()));
                string3 = this.resources.getString("OBJECT_SECURITY_CUBE_EXTEND_PRIVS_TO_ET_VIEWS_LABEL");
            } else if (string.equalsIgnoreCase("CUBE DIMENSION") || string.equalsIgnoreCase(CUBE_DIMENSION_NODE)) {
                string2 = this.resources.getString("OBJECT_SECURITY_DIM_EXTEND_PRIVS_TO_AW_LABEL", this.getAWName(this.getDBObject()));
                string3 = this.resources.getString("OBJECT_SECURITY_DIM_EXTEND_PRIVS_TO_ET_VIEWS_LABEL");
            }
            ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
            CheckBoxActionControl checkBoxActionControl = new CheckBoxActionControl(EXTEND_TO_AW, string2, true);
            arrayList.add((ActionControl)checkBoxActionControl);
            CheckBoxActionControl checkBoxActionControl2 = new CheckBoxActionControl(EXTEND_TO_VIEW, string3, true);
            arrayList.add((ActionControl)checkBoxActionControl2);
            return arrayList;
        }
        return null;
    }

    protected String getCustomSql(ActionDialog.Values values) {
        Operation operation = this.getOperation();
        if (operation == Operation.GRANT) {
            return this.getGrantCommands(values);
        }
        if (operation == Operation.REVOKE) {
            return this.getRevokeCommands(values);
        }
        return "";
    }

    private String getGrantCommands(ActionDialog.Values values) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        List list = values.getList(SHUTTLE, ADDED);
        boolean bl2 = bl = values.get(GRANT_ALL) != null && values.get(GRANT_ALL).equals(TRUE);
        if (values.get(EXTEND_TO_AW) != null && values.get(EXTEND_TO_AW).equals(TRUE) && !values.get(USERS).equals("") && (values.getList(SHUTTLE, ADDED).size() > 0 || bl)) {
            String string2;
            stringBuilder.append("grant ");
            if (bl) {
                stringBuilder.append("all ");
            } else {
                for (String string2 : list) {
                    stringBuilder.append(string2 + ", ");
                }
                if (stringBuilder.lastIndexOf(",") > -1) {
                    stringBuilder.replace(stringBuilder.lastIndexOf(","), stringBuilder.lastIndexOf(",") + 1, "");
                }
            }
            String string3 = String.format("\"AW$%s\"", this.getAWName(this.getDBObject()));
            string2 = String.format("on \"%s\".%s to \"%s\"", values.get(SCHEMA), string3, values.get(USERS));
            if (values.get(WITH_GRANT).equals(TRUE)) {
                string2 = string2 + " with grant option";
            }
            stringBuilder.append(string2);
            stringBuilder.append(";\r");
        }
        if (values.get(USERS) != null && !values.get(USERS).equals("") && values.get(EXTEND_TO_VIEW) != null && values.get(EXTEND_TO_VIEW).equals(TRUE) && (list != null && list.contains("SELECT") || bl)) {
            stringBuilder.append(this.getETGrantCommands(values));
        }
        if (stringBuilder.toString() == null) {
            return "";
        }
        return stringBuilder.toString();
    }

    private String getRevokeCommands(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        List list = values.getList(SHUTTLE, SELECTED);
        stringBuilder.append(";\r");
        boolean bl = false;
        if (list.contains("SELECT") || values.get(REVOKE_ALL) != null && values.get(REVOKE_ALL).equals(TRUE)) {
            bl = true;
        }
        if (bl && !values.get(USERS).equals("")) {
            stringBuilder.append(this.getETRevokeCommands(values));
            return stringBuilder.toString();
        }
        return "";
    }

    private String getETGrantCommands(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        if (values.get(GRANT_ALL) != null && values.get(GRANT_ALL).equals(TRUE)) {
            List<String> list = this.getViewNames(this.getDBObject());
            for (String string : list) {
                stringBuilder.append("grant SELECT on ");
                stringBuilder.append(String.format("\"%s\".\"%s\"", values.get(SCHEMA), string));
                stringBuilder.append(String.format(" to \"%s\"", values.get(USERS)));
                if (values.get(WITH_GRANT).equals(TRUE)) {
                    stringBuilder.append(" with grant option");
                }
                stringBuilder.append(";\r");
            }
            return stringBuilder.toString();
        }
        List list = values.getList(SHUTTLE, ADDED);
        for (String string : list) {
            List<String> list2 = this.getViewNames(this.getDBObject());
            for (String string2 : list2) {
                if (!string.equalsIgnoreCase("SELECT")) continue;
                stringBuilder.append("grant SELECT on ");
                stringBuilder.append(String.format("\"%s\".\"%s\"", values.get(SCHEMA), string2));
                stringBuilder.append(String.format(" to \"%s\"", values.get(USERS)));
                if (values.get(WITH_GRANT).equals(TRUE)) {
                    stringBuilder.append(" with grant option");
                }
                stringBuilder.append(";\r");
            }
        }
        return stringBuilder.toString();
    }

    private String getETRevokeCommands(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        if (values.get(REVOKE_ALL) != null && values.get(REVOKE_ALL).equals(TRUE)) {
            List<String> list = this.getViewNames(this.getDBObject());
            this.verifyGrantEnabledOnViews(this.getDBObject(), values, list);
            for (String string : list) {
                stringBuilder.append("revoke SELECT on ");
                stringBuilder.append(String.format("\"%s\".\"%s\"", values.get(SCHEMA), string));
                stringBuilder.append(String.format(" from \"%s\"", values.get(USERS)));
                stringBuilder.append(";\r");
            }
            return stringBuilder.toString();
        }
        List list = values.getList(SHUTTLE, SELECTED);
        for (String string : list) {
            if (!string.equalsIgnoreCase("SELECT")) continue;
            List<String> list2 = this.getViewNames(this.getDBObject());
            this.verifyGrantEnabledOnViews(this.getDBObject(), values, list2);
            for (String string2 : list2) {
                stringBuilder.append("revoke SELECT on ");
                stringBuilder.append(String.format("\"%s\".\"%s\"", values.get(SCHEMA), string2));
                stringBuilder.append(String.format(" from \"%s\"", values.get(USERS)));
                stringBuilder.append(";\r");
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private List<String> getViewNames(DBObject dBObject) {
        String string;
        String string2;
        String string3 = dBObject.getObjectName();
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.connection);
        String string4 = dBObject.getSchemaName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", string4);
        hashMap.put("name", string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (dBObject.getObjectType().equals("CUBE DIMENSION")) {
            string2 = "select view_name from all_cube_dim_views where owner = :owner and dimension_name = :name";
            string = dBUtil.executeReturnOneCol(string2, hashMap);
            arrayList.add(string);
            string2 = "select view_name from all_cube_hier_views where owner = :owner and dimension_name =:name";
            List list = dBUtil.executeReturnList(string2, hashMap);
            for (Map map : list) {
                for (Object v : map.values()) {
                    arrayList.add((String)v);
                }
            }
        }
        if (dBObject.getObjectType().equals("CUBE")) {
            string2 = "select view_name from all_cube_views where owner = :owner and cube_name = :name";
            string = dBUtil.executeReturnOneCol(string2, hashMap);
            arrayList.add(string);
        }
        return arrayList;
    }

    private List<String> verifyGrantEnabledOnViews(DBObject dBObject, ActionDialog.Values values, List<String> list) {
        String string = values.get(USERS);
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.connection);
        String string2 = dBObject.getSchemaName();
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", string2);
        hashMap.put("grantee", string);
        hashMap.put("grantor", string2);
        for (String string3 : list) {
            hashMap.put("table_name", string3);
            String string4 = "select TO_CHAR(count(*)) count from user_tab_privs where grantee = :grantee and grantor = :grantor and table_name = :table_name and owner = :owner and privilege = 'SELECT'";
            String string5 = dBUtil.executeReturnOneCol(string4, hashMap).trim();
            if (!string5.equals("0")) continue;
            arrayList.add(string3);
        }
        for (String string3 : arrayList) {
            list.remove(string3);
        }
        return list;
    }

    private String getAWName(DBObject dBObject) {
        String string;
        String string2;
        String string3 = dBObject.getObjectName();
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.connection);
        String string4 = dBObject.getSchemaName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", string4);
        hashMap.put("name", string3);
        if (dBObject.getObjectType().equals("CUBE DIMENSION")) {
            string2 = "select aw_name from all_cube_dimensions where owner = :owner and dimension_name = :name";
            string3 = string = dBUtil.executeReturnOneCol(string2, hashMap);
        }
        if (dBObject.getObjectType().equals("CUBE")) {
            string2 = "select aw_name from all_cubes where owner = :owner and cube_name = :name";
            string3 = string = dBUtil.executeReturnOneCol(string2, hashMap);
        }
        return string3;
    }

    protected void initializeValues(JEWTDialog jEWTDialog) {
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        String string = this.getDbObjectType();
        Operation operation = this.getOperation();
        String string2 = null;
        if (operation == Operation.GRANT) {
            string2 = "olap_perform_grant_action_analytic_workspace";
            if (string.equalsIgnoreCase("CUBE") || string.equalsIgnoreCase(CUBE_NODE)) {
                string2 = "olap_perform_grant_action_cube";
            } else if (string.equalsIgnoreCase("CUBE DIMENSION") || string.equalsIgnoreCase(CUBE_DIMENSION_NODE)) {
                string2 = "olap_perform_grant_action_dimension";
            }
            HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), string2);
        } else if (operation == Operation.REVOKE) {
            string2 = "olap_perform_revoke_action_analytic_workspace";
            if (string.equalsIgnoreCase("CUBE") || string.equalsIgnoreCase(CUBE_NODE)) {
                string2 = "olap_perform_revoke_action_cube";
            } else if (string.equalsIgnoreCase("CUBE DIMENSION") || string.equalsIgnoreCase(CUBE_DIMENSION_NODE)) {
                string2 = "olap_perform_revoke_action_dimension";
            }
            HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), string2);
        }
    }

    private static enum Operation {
        GRANT,
        REVOKE;

    }
}

