/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.sql.Connection;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.app.olapmetadata.OLAPMetadataReader;
import oracle.olap.cube.CubeBuilder;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeMeasureFolderContents;
import oracle.olap.cubebuildprocess.CubeBuildProcessBuilder;
import oracle.olap.cubebuildprocess.model.CubeBuildProcess;
import oracle.olap.cubedimension.CubeDimensionBuilder;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.measurefolder.MeasureFolderBuilder;
import oracle.olap.measurefolder.model.MeasureFolder;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureNode;

public class OLAPObjectHelper {
    public static Cube loadCube(DBObject dBObject) {
        Object object;
        Cube cube = new Cube();
        String string = "";
        if (dBObject.getNode() instanceof ObjectNode) {
            object = (ObjectNode)dBObject.getNode();
            string = (String)object.getProperty("CUBE_NAME");
        } else if (dBObject.getNode() instanceof CalculatedMeasureNode) {
            object = (CalculatedMeasureNode)dBObject.getNode();
            string = (String)((CalculatedMeasureNode)object).getProperty("CUBE_NAME");
        }
        object = new CubeBuilder((OracleDatabaseImpl)dBObject.getDatabase());
        cube.setName(string);
        cube.setSchema(new Schema(dBObject.getSchemaName()));
        try {
            ((CubeBuilder)((Object)object)).buildDetails(cube);
            ((CubeBuilder)((Object)object)).buildProperties(cube);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        return cube;
    }

    public static Cube loadCube(DBObject dBObject, String string) {
        Cube cube = new Cube();
        CubeBuilder cubeBuilder = new CubeBuilder((OracleDatabaseImpl)dBObject.getDatabase());
        cube.setName(string);
        cube.setSchema(new Schema(dBObject.getSchemaName()));
        try {
            cubeBuilder.buildDetails(cube);
            cubeBuilder.buildProperties(cube);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        return cube;
    }

    public static Cube loadCube(String string, String string2, OracleDatabaseImpl oracleDatabaseImpl) {
        Cube cube = new Cube();
        CubeBuilder cubeBuilder = new CubeBuilder(oracleDatabaseImpl);
        cube.setName(string);
        cube.setSchema(new Schema(string2));
        try {
            cubeBuilder.buildDetails(cube);
            cubeBuilder.buildProperties(cube);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        return cube;
    }

    public static CubeDimension loadDimension(DBObject dBObject) {
        Object object;
        CubeDimension cubeDimension = new CubeDimension();
        String string = "";
        if (dBObject.getNode() instanceof ObjectNode) {
            object = (ObjectNode)dBObject.getNode();
            string = (String)object.getProperty("DIMENSION_NAME");
        }
        object = new CubeDimensionBuilder((OracleDatabaseImpl)dBObject.getDatabase());
        cubeDimension.setName(string);
        cubeDimension.setSchema(new Schema(dBObject.getSchemaName()));
        try {
            ((CubeDimensionBuilder)((Object)object)).buildProperties(cubeDimension);
            ((CubeDimensionBuilder)((Object)object)).buildDetails(cubeDimension);
            ((CubeDimensionBuilder)((Object)object)).buildDependentCubes(cubeDimension);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cubeDimension;
    }

    public static CubeDimension loadDimension(DBObject dBObject, String string) {
        return OLAPObjectHelper.loadDimension(dBObject, string, true);
    }

    public static CubeDimension loadDimension(DBObject dBObject, String string, boolean bl) {
        CubeDimension cubeDimension = new CubeDimension();
        CubeDimensionBuilder cubeDimensionBuilder = new CubeDimensionBuilder((OracleDatabaseImpl)dBObject.getDatabase());
        cubeDimension.setName(string);
        cubeDimension.setSchema(new Schema(dBObject.getSchemaName()));
        try {
            cubeDimensionBuilder.buildProperties(cubeDimension);
            cubeDimensionBuilder.buildDetails(cubeDimension);
            if (bl) {
                cubeDimensionBuilder.buildDependentCubes(cubeDimension);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cubeDimension;
    }

    public static CubeBuildProcess loadCubeBuildProcess(DBObject dBObject) {
        CubeBuildProcess cubeBuildProcess = new CubeBuildProcess();
        cubeBuildProcess.setName(dBObject.getObjectName());
        cubeBuildProcess.setSchema(new Schema(dBObject.getSchemaName()));
        CubeBuildProcessBuilder cubeBuildProcessBuilder = new CubeBuildProcessBuilder((OracleDatabaseImpl)dBObject.getDatabase());
        try {
            cubeBuildProcessBuilder.buildProperties(cubeBuildProcess);
            cubeBuildProcessBuilder.buildDetails(cubeBuildProcess);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cubeBuildProcess;
    }

    public static MeasureFolder loadMeasureFolder(DBObject dBObject) {
        MeasureFolder measureFolder = new MeasureFolder();
        MeasureFolderBuilder measureFolderBuilder = new MeasureFolderBuilder((OracleDatabaseImpl)dBObject.getDatabase());
        measureFolder.setName(dBObject.getObjectName());
        measureFolder.setSchema(new Schema(dBObject.getSchemaName()));
        try {
            measureFolderBuilder.buildDescription(measureFolder);
            measureFolderBuilder.buildDetails(measureFolder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return measureFolder;
    }

    public static MeasureFolder loadMeasureFolder(String string, String string2, OracleDatabaseImpl oracleDatabaseImpl) {
        MeasureFolder measureFolder = new MeasureFolder();
        MeasureFolderBuilder measureFolderBuilder = new MeasureFolderBuilder(oracleDatabaseImpl);
        measureFolder.setName(string2);
        measureFolder.setSchema(new Schema(string));
        try {
            measureFolderBuilder.buildDescription(measureFolder);
            measureFolderBuilder.buildDetails(measureFolder);
            measureFolderBuilder.buildMeasures(measureFolder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return measureFolder;
    }

    public static List<CubeMeasureFolderContents> getCubeMeasureFolderContents(String string, String string2, OracleDatabaseImpl oracleDatabaseImpl) {
        Cube cube = new Cube();
        cube.setName(string);
        CubeBuilder cubeBuilder = new CubeBuilder(oracleDatabaseImpl);
        List<CubeMeasureFolderContents> list = null;
        try {
            list = cubeBuilder.buildCubeMeasureFolderContents(cube, string, string2);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        return list;
    }

    public static boolean isTimeDimension(DBObject dBObject, String string) {
        Connection connection = dBObject.getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        String string2 = dBObject.getSchemaName();
        return OLAPMetadataReader.isTimeDimension(dBUtil, string2, string);
    }
}

