/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Frame;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.calcs.CalculatedMeasuresDialog;
import oracle.olap.cube.CubeBuilder;
import oracle.olap.cube.model.Cube;
import oracle.olap.db.CubeCalcPersistSQL;
import oracle.olap.util.OLAPErrorDisplay;

public class CalculatedMeasuresAction
extends AbstractMenuAction {
    private static final Logger LOG = Logger.getLogger(CalculatedMeasuresAction.class.getName());

    public void launch() {
        DBObject dBObject = this.getDBObject();
        Connection connection = dBObject.getConnection();
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(connection);
        Cube cube = this.getCube();
        oracle.olap.app.olapmetadata.Cube cube2 = new oracle.olap.app.olapmetadata.Cube(new Schema(cube.getSchema().getName()), cube.getAnalyticWorkspace(), cube.getName(), cube.getDescription(), "", false);
        CubeCalcPersistSQL cubeCalcPersistSQL = null;
        Database database = dBObject.getDatabase();
        try {
            cubeCalcPersistSQL = new CubeCalcPersistSQL(databaseImpl, cube2, cube);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        try {
            CalculatedMeasuresDialog calculatedMeasuresDialog = new CalculatedMeasuresDialog((Frame)Ide.getMainWindow(), OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.TITLE"), cube, connection, cubeCalcPersistSQL, new OLAPErrorDisplay(), (DBObjectProvider)database);
            calculatedMeasuresDialog.setVisible(true);
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
        }
    }

    private Cube getCube() {
        DBObject dBObject = this.getDBObject();
        CubeBuilder cubeBuilder = new CubeBuilder((OracleDatabaseImpl)dBObject.getDatabase());
        Cube cube = new Cube();
        String string = dBObject.getObjectName();
        String string2 = dBObject.getSchemaName();
        cube.setName(string);
        cube.setSchema(new oracle.javatools.db.Schema(string2));
        cube.setAnalyticWorkspace(cube.getSchema().getName());
        try {
            cubeBuilder.build(cube);
            cubeBuilder.buildDetails(cube);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        return cube;
    }
}

