/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.DynamicLibraryProvider;
import oracle.jdeveloper.library.EndorsedStandardsOverride;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.ApplicationLibraries;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.TechnologySpecificSupportProvider;
import oracle.jdeveloper.resource.ModelArb;
import oracle.jdevimpl.buildtools.ModuleConfiguration;
import oracle.jdevimpl.config.JProjectPaths;

public class PathsConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = PathsConfiguration.class.getName();
    public static final String JAVA_CONTENT_SET_LOCAL_KEY = "javaContentSet";
    public static final String JAVA_CONTENT_SET_KEY = DATA_KEY + "/" + "javaContentSet";
    private static final List<TechnologySpecificSupportProvider> SUPPORT_PROVIDERS = new ArrayList<TechnologySpecificSupportProvider>();
    private static final PatternFilter[] INCLUDE_ALL_FILTER = new PatternFilter[]{PatternFilter.newInclude((String)"**")};
    private static final String HELP_ID = "f1_idechoosepackagelocation_html";
    private Project _project;
    public static final String PROJECT_SOURCEPATH = "javaContentSet/url-path";

    private PathsConfiguration(Project project, HashStructure hash) {
        super(hash);
        if (project == null) {
            throw new IllegalArgumentException("null project");
        }
        this._project = project;
    }

    public static PathsConfiguration getInstance(Project project) {
        return PathsConfiguration.getInstance(project, (PropertyStorage)project);
    }

    public static PathsConfiguration getInstance(Project project, PropertyStorage propertyData) {
        HashStructure properties = propertyData.getProperties();
        return new PathsConfiguration(project, properties.getOrCreateHashStructure(DATA_KEY));
    }

    public ContentSet getJavaContentSet() {
        return new ContentSet(this._hash.getOrCreateHashStructure(JAVA_CONTENT_SET_LOCAL_KEY));
    }

    public URLPath getProjectSourcePath() {
        ContentSet javaContentSet = this.getJavaContentSet();
        return javaContentSet.getAllRootDirs();
    }

    public boolean setProjectSourcePath(URLPath urlPath) {
        ContentSet contentSet = this.getJavaContentSet();
        contentSet.getURLPath().setEntries(null);
        contentSet.getPatternFilters().setFilters(null);
        contentSet.removeAllContentSets();
        if (urlPath == null) {
            return true;
        }
        List urls = urlPath.asList();
        if (urls.size() == 1) {
            this.persistContentSet((URL)urls.get(0), contentSet);
        } else {
            for (URL url : urls) {
                if (contentSet.getURLPath().contains(url)) continue;
                ContentSet subContentSet = new ContentSet(HashStructure.newInstance());
                contentSet.addContentSet(subContentSet);
                this.persistContentSet(url, subContentSet);
            }
        }
        return true;
    }

    private void persistContentSet(URL srcRootURL, ContentSet contentSet) {
        URLPath existingURLPath = contentSet.getURLPath();
        if (existingURLPath.size() != 1 || !URLFileSystem.equals((URL)((URL)existingURLPath.asList().get(0)), (URL)srcRootURL)) {
            URL[] entries = new URL[]{srcRootURL};
            existingURLPath.setEntries(entries);
        }
        contentSet.getPatternFilters().setFilters(INCLUDE_ALL_FILTER);
    }

    public URLPath getSourcePath() {
        URLPath sourcePath = this.getProjectSourcePath();
        sourcePath.add(this.getEndorsedStandardsSourcePath());
        JProjectLibraries libs = JProjectLibraries.getInstance((PropertyStorage)this._project);
        JDK jdkDefinition = libs.getJDK();
        if (jdkDefinition != null) {
            URLPath jdkSourcePath = jdkDefinition.getSourcePath();
            sourcePath.add(jdkSourcePath);
        }
        URLPath projectPath = new URLPath();
        Iterator deps = DependencyConfiguration.getInstance((Project)this._project).getDependencies();
        while (deps.hasNext()) {
            Dependable dep = (Dependable)deps.next();
            if (!(dep instanceof Library)) continue;
            Library lib = (Library)dep;
            projectPath.add(lib.getSourcePath());
        }
        JLibrary[] defs = libs.getLibraries();
        for (int i = 0; i < defs.length; ++i) {
            URLPath librarySourcePath = defs[i].getSourcePath();
            projectPath.add(librarySourcePath);
        }
        URLPath appPath = new URLPath();
        for (JLibrary library : this.getApplicationLibraries()) {
            appPath.add(library.getSourcePath());
        }
        this.addToPath(sourcePath, projectPath, appPath);
        return sourcePath;
    }

    public URLPath getClassPath() {
        URLPath classPath = new URLPath();
        classPath.add(this.getEndorsedStandardsClassPath());
        classPath.add(this.getJdkClassPath());
        classPath.add(this.getRunClassPath());
        return classPath;
    }

    public URLPath getJdkClassPath() {
        URLPath classPath = new URLPath();
        JDK jdk = JProjectLibraries.getInstance((PropertyStorage)this._project).getJDK();
        if (jdk != null) {
            classPath.add(jdk.getClassPath());
        }
        return classPath;
    }

    public URLPath getRunClassPath() {
        return this.getRunClassPath(false);
    }

    public URLPath getRunClassPath(boolean onlyDeployLibs) {
        return this.getRunClassPath(onlyDeployLibs, false);
    }

    public URLPath getRunClassPath(boolean onlyDeployLibs, boolean onlyStaticLibs) {
        TechnologySpecificSupportProvider provider;
        URLPath classPath = new URLPath();
        URL outputDir = null;
        Iterator<TechnologySpecificSupportProvider> iterator = PathsConfiguration.getSupportProviders().iterator();
        while (iterator.hasNext() && (outputDir = (provider = iterator.next()).getProjectOutputDirectory(this._project)) == null) {
        }
        classPath.add(outputDir);
        classPath.add(JProjectPaths.getInstance((PropertyStorage)this._project).getAdditionalClassPath());
        ModuleConfiguration moduleConfig = ModuleConfiguration.getInstance(this._project);
        if (moduleConfig != null) {
            classPath.add(moduleConfig.getClassPath());
        }
        URLPath projectPath = new URLPath();
        Iterator deps = DependencyConfiguration.getInstance((Project)this._project).getDependencies();
        while (deps.hasNext()) {
            Dependable dep = (Dependable)deps.next();
            URLPath path = null;
            for (TechnologySpecificSupportProvider provider2 : PathsConfiguration.getSupportProviders()) {
                path = provider2.getClassPathIfProjectLibrary(dep, onlyDeployLibs);
                if (path == null) continue;
                projectPath.add(path);
                break;
            }
            if (path != null || !(dep instanceof Library)) continue;
            Library lib = (Library)dep;
            projectPath.add(lib.getClassPath());
        }
        JLibrary[] defs = JProjectLibraries.getInstance((PropertyStorage)this._project).getLibraries();
        for (int i = 0; i < defs.length; ++i) {
            if (onlyDeployLibs && !defs[i].getDeployedByDefault().booleanValue()) continue;
            URLPath libraryClassPath = defs[i].getClassPath();
            projectPath.add(libraryClassPath);
        }
        URLPath appPath = new URLPath();
        for (JLibrary library : this.getApplicationLibraries()) {
            if (onlyDeployLibs && !library.getDeployedByDefault().booleanValue()) continue;
            appPath.add(library.getClassPath());
        }
        this.addToPath(classPath, projectPath, appPath);
        if (!onlyStaticLibs) {
            JLibraryManager mgr = JLibraryManager.getInstance();
            for (DynamicLibraryProvider provider3 : mgr.getDynamicLibraryProviders(this.getTechnologyKeys())) {
                provider3.updateClassPath(this._project, classPath);
            }
        }
        return classPath;
    }

    public URLPath getDocPath() {
        URLPath docPath = new URLPath();
        docPath.add(this.getEndorsedStandardsDocPath());
        JDK jdk = JProjectLibraries.getInstance((PropertyStorage)this._project).getJDK();
        if (jdk != null) {
            docPath.add(jdk.getDocPath());
        }
        URLPath projectPath = new URLPath();
        Iterator deps = DependencyConfiguration.getInstance((Project)this._project).getDependencies();
        while (deps.hasNext()) {
            Dependable dep = (Dependable)deps.next();
            if (!(dep instanceof Library)) continue;
            Library lib = (Library)dep;
            projectPath.add(lib.getDocPath());
        }
        JLibrary[] defs = JProjectLibraries.getInstance((PropertyStorage)this._project).getLibraries();
        for (int i = 0; i < defs.length; ++i) {
            URLPath libraryDocPath = defs[i].getDocPath();
            projectPath.add(libraryDocPath);
        }
        URLPath appPath = new URLPath();
        for (JLibrary library : this.getApplicationLibraries()) {
            appPath.add(library.getDocPath());
        }
        this.addToPath(docPath, projectPath, appPath);
        return docPath;
    }

    public URLPath getEndorsedStandardsDirectories() {
        URLPath endorsedDirs = new URLPath();
        for (EndorsedStandardsOverride override : this.getEndorsedStandardsOverrides()) {
            endorsedDirs.add(override.getEndorsedStandardsDirectories());
        }
        return endorsedDirs;
    }

    public URLPath getEndorsedStandardsClassPath() {
        URLPath path = new URLPath();
        for (EndorsedStandardsOverride override : this.getEndorsedStandardsOverrides()) {
            for (URL dir : override.getEndorsedStandardsDirectories()) {
                URLFileSystem.FileInfo[] children = URLFileSystem.ls((URL)dir);
                if (children == null) continue;
                for (URLFileSystem.FileInfo info : children) {
                    URL url;
                    if (!info.isFile() || !JarUtil.isArchive((String)(url = info.getURL()).getPath())) continue;
                    path.add(URLFactory.newJarURL((URL)url, null));
                }
            }
        }
        return path;
    }

    public URLPath getEndorsedStandardsSourcePath() {
        URLPath srcPath = new URLPath();
        for (EndorsedStandardsOverride override : this.getEndorsedStandardsOverrides()) {
            srcPath.add(override.getEndorsedStandardsSourcePath());
        }
        return srcPath;
    }

    public URLPath getEndorsedStandardsDocPath() {
        URLPath docPath = new URLPath();
        for (EndorsedStandardsOverride override : this.getEndorsedStandardsOverrides()) {
            docPath.add(override.getEndorsedStandardsDocPath());
        }
        return docPath;
    }

    private Collection<EndorsedStandardsOverride> getEndorsedStandardsOverrides() {
        ArrayList<EndorsedStandardsOverride> projectOverrides = new ArrayList<EndorsedStandardsOverride>();
        ArrayList<EndorsedStandardsOverride> appOverrides = new ArrayList<EndorsedStandardsOverride>();
        Iterator deps = DependencyConfiguration.getInstance((Project)this._project).getDependencies();
        while (deps.hasNext()) {
            Dependable dep = (Dependable)deps.next();
            if (!(dep instanceof EndorsedStandardsOverride)) continue;
            projectOverrides.add((EndorsedStandardsOverride)dep);
        }
        for (JLibrary library : JProjectLibraries.getInstance((PropertyStorage)this._project).getLibraries()) {
            if (!(library instanceof EndorsedStandardsOverride)) continue;
            projectOverrides.add((EndorsedStandardsOverride)((Object)library));
        }
        for (JLibrary library : this.getApplicationLibraries()) {
            if (!(library instanceof EndorsedStandardsOverride)) continue;
            appOverrides.add((EndorsedStandardsOverride)((Object)library));
        }
        if (JProjectLibraries.getInstance((PropertyStorage)this._project).getOverrideApplicationLibraries()) {
            projectOverrides.addAll(appOverrides);
            return projectOverrides;
        }
        appOverrides.addAll(projectOverrides);
        return appOverrides;
    }

    private String[] getTechnologyKeys() {
        return TechnologyScopeConfiguration.getInstance((PropertyStorage)this._project).getTechnologyScope().getTechnologyKeys();
    }

    public static void addSupportProvider(TechnologySpecificSupportProvider provider) {
        SUPPORT_PROVIDERS.add(provider);
    }

    public static List<TechnologySpecificSupportProvider> getSupportProviders() {
        return SUPPORT_PROVIDERS;
    }

    public static URL getURLForPackage(String packageName, Context context) {
        RelativeDirectoryContextFolder r;
        URLPath path;
        URL packageURL = null;
        Project project = context.getProject();
        TreeSet<ProjURLPair> matchingURLs = new TreeSet<ProjURLPair>();
        Element selElement = context.getElement();
        if (context.getView() instanceof NavigatorWindow && selElement instanceof RelativeDirectoryContextFolder && (path = (r = (RelativeDirectoryContextFolder)selElement).getRootDirectories()).size() == 1) {
            packageURL = URLFactory.newDirURL((URL)path.getEntries()[0], (String)packageName);
            return packageURL;
        }
        for (TechnologySpecificSupportProvider provider : PathsConfiguration.getSupportProviders()) {
            URL parentUrl = provider.getParentUrlIfEqual(selElement, packageName);
            if (parentUrl == null) continue;
            return parentUrl;
        }
        Project[] projects = PathsConfiguration.getDependentProjects(project);
        String pkgPre = packageName;
        String pkgPost = "";
        while (matchingURLs.size() == 0 && !PathsConfiguration.addMatchingURLs(matchingURLs, project, pkgPre, pkgPost)) {
            int idx;
            if (matchingURLs.size() == 0) {
                for (Project dependentProject : projects) {
                    PathsConfiguration.addMatchingURLs(matchingURLs, dependentProject, pkgPre, pkgPost);
                }
            }
            if ((idx = pkgPre.lastIndexOf(47)) == -1) break;
            pkgPost = pkgPre.substring(idx) + "/" + pkgPost;
            pkgPre = pkgPre.substring(0, idx);
        }
        PathsConfiguration.processProject(project, matchingURLs, packageName);
        if (matchingURLs.size() == 1) {
            Project packageProject;
            ProjURLPair pair = (ProjURLPair)matchingURLs.iterator().next();
            Project contextProject = context.getProject();
            if (ModelUtil.areEqual((Object)contextProject, (Object)(packageProject = pair.getProject()))) {
                packageURL = pair.getURL();
            } else {
                PathsConfiguration.processProject(project, matchingURLs, packageName);
                packageURL = PathsConfiguration.runURLSelectionUI(matchingURLs);
            }
        } else {
            packageURL = PathsConfiguration.runURLSelectionUI(matchingURLs);
        }
        if (packageURL != null) {
            String urlString = packageURL.toString();
            if (urlString.endsWith("/")) {
                urlString = urlString.substring(0, urlString.length() - 1);
            }
            if (!urlString.endsWith(packageName)) {
                String pkgStr = URLFileSystem.getPath((URL)packageURL);
                String pkg = packageName;
                StringBuffer removedString = new StringBuffer();
                boolean found = false;
                while (!found && pkg.length() > 0) {
                    int idx = pkg.lastIndexOf(47);
                    if (idx == -1) {
                        removedString.insert(0, pkg + "/");
                        pkg = null;
                        break;
                    }
                    removedString.insert(0, pkg.substring(idx + 1, pkg.length()) + "/");
                    if (!pkgStr.endsWith(pkg = pkg.substring(0, idx))) continue;
                    break;
                }
                packageURL = URLFactory.newDirURL((URL)packageURL, (String)removedString.toString());
            }
        }
        return packageURL;
    }

    private static void processProject(Project project, Set<ProjURLPair> matches, String packageName) {
        URLPath urlPath = PathsConfiguration.getInstance(project).getProjectSourcePath();
        URL[] entries = urlPath.getEntries();
        if (entries.length > 1) {
            for (URL entry : entries) {
                matches.add(new ProjURLPair(project, URLFactory.newDirURL((URL)entry, (String)packageName)));
            }
        } else {
            ProjURLPair pair = new ProjURLPair(project, URLFactory.newDirURL((URL)entries[0], (String)packageName));
            matches.add(pair);
        }
    }

    private static URL runURLSelectionUI(Set<ProjURLPair> matches) {
        URL returnURL = null;
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("root");
        DefaultTreeModel model = new DefaultTreeModel(rootNode);
        Project project = null;
        DefaultMutableTreeNode projectNode = null;
        for (ProjURLPair pair : matches) {
            if (project != pair.getProject()) {
                projectNode = new DefaultMutableTreeNode(pair.getProject());
                model.insertNodeInto(projectNode, rootNode, rootNode.getChildCount());
                project = pair.getProject();
            }
            DefaultMutableTreeNode urlNode = new DefaultMutableTreeNode(new URLDisplayWrapper(pair.getURL()));
            model.insertNodeInto(urlNode, projectNode, projectNode.getChildCount());
        }
        final JTree tree = new JTree(model);
        tree.setCellRenderer(new PathsNodeRenderer());
        tree.setRowHeight(20);
        tree.setVisibleRowCount(8);
        tree.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        JScrollPane scrollPane = new JScrollPane(tree);
        tree.setSelectionModel(new URLTreeSelectionModel());
        tree.getSelectionModel().setSelectionMode(1);
        final JEWTDialog dialog = DialogUtil.createJEWTDialogOwnedBy((Component)Ide.getMainWindow());
        if (dialog == null) {
            return null;
        }
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                if (node == null) {
                    dialog.setOKButtonEnabled(false);
                } else {
                    dialog.setOKButtonEnabled(node.isLeaf());
                }
            }
        });
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                TreeNode selNode;
                TreePath path;
                if (event.getClickCount() == 2 && (path = tree.getSelectionPath()) != null && (selNode = (TreeNode)path.getLastPathComponent()).isLeaf()) {
                    dialog.closeDialog(false);
                }
            }
        });
        IdeUtil.expandAllTreeRows((JTree)tree);
        JWrappedLabel header = new JWrappedLabel(ModelArb.getString(140));
        header.setForeground(Colors.HINT_TEXT);
        JLabel treeLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)treeLabel, (Component)tree, (String)ModelArb.getString(139));
        JPanel content = new JPanel(new GridBagLayout());
        content.add((Component)header, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        content.add((Component)treeLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 3, 0), 0, 0));
        content.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)content, HELP_ID);
        dialog.setContent((Component)content);
        dialog.setOKButtonEnabled(false);
        dialog.setInitialFocus((Component)tree);
        dialog.setTitle(ModelArb.getString(138));
        dialog.setButtonMask(7);
        dialog.setResizable(true);
        dialog.pack();
        boolean retval = dialog.runDialog();
        if (retval) {
            TreePath treePath = tree.getSelectionPath();
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            URLDisplayWrapper urlWrapper = (URLDisplayWrapper)selNode.getUserObject();
            returnURL = urlWrapper.getURL();
        }
        dialog.dispose();
        return returnURL;
    }

    private static boolean addMatchingURLs(Set<ProjURLPair> matches, Project project, String pkgPre, String pkgPost) {
        URL[] matchingURLs;
        PathsConfiguration pathConfig = PathsConfiguration.getInstance(project);
        URLPath urlPath = pathConfig.getProjectSourcePath();
        boolean found = false;
        if (urlPath != null && (matchingURLs = urlPath.toQualifiedURL(pkgPre, false)) != null) {
            for (int i = 0; i < matchingURLs.length; ++i) {
                matches.add(new ProjURLPair(project, URLFactory.newDirURL((URL)matchingURLs[i], (String)pkgPost)));
                found = true;
            }
        }
        return found;
    }

    public static Project[] getDependentProjects(Context context) {
        return PathsConfiguration.getDependentProjects(context.getProject());
    }

    public static Project[] getDependentProjects(Project deepestProject) {
        HashSet<Object> bases = new HashSet<Object>();
        ArrayList<Object> dependables = new ArrayList<Object>();
        bases.add(deepestProject);
        dependables.add(deepestProject);
        while (!dependables.isEmpty()) {
            Project project = (Project)dependables.remove(0);
            Iterator dependencies = DependencyConfiguration.getInstance((Project)project).getDependencies();
            while (dependencies.hasNext()) {
                Dependable dependable = (Dependable)dependencies.next();
                Element dependableSource = dependable.getSource();
                if (!(dependableSource instanceof Project) || !bases.add(dependableSource)) continue;
                dependables.add(dependableSource);
            }
        }
        bases.remove(deepestProject);
        Project[] projects = bases.toArray(new Project[bases.size()]);
        return projects;
    }

    private List<JLibrary> getApplicationLibraries() {
        Workspace workspace = this._project.getWorkspace();
        return workspace == null ? Collections.emptyList() : ApplicationLibraries.getInstance(workspace).getLibraryReferences();
    }

    private void addToPath(URLPath dest, URLPath projectPath, URLPath appPath) {
        if (JProjectLibraries.getInstance((PropertyStorage)this._project).getOverrideApplicationLibraries()) {
            dest.add(projectPath);
            dest.add(appPath);
        } else {
            dest.add(appPath);
            dest.add(projectPath);
        }
    }

    private static class PathsNodeRenderer
    extends DefaultTreeCellRenderer {
        private PathsNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component cellRendererComponent = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(OracleIcons.getIcon((String)(leaf ? "folder.png" : "project.png")));
            return cellRendererComponent;
        }
    }

    private static class URLDisplayWrapper {
        private URL _url;

        public URLDisplayWrapper(URL url) {
            this._url = url;
        }

        public URL getURL() {
            return this._url;
        }

        public String toString() {
            return URLFileSystem.getPlatformPathName((URL)this._url);
        }
    }

    private static class URLTreeSelectionModel
    extends DefaultTreeSelectionModel {
        private URLTreeSelectionModel() {
        }

        @Override
        public void setSelectionPath(TreePath treePath) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (selNode.isLeaf()) {
                super.setSelectionPath(treePath);
            } else {
                super.clearSelection();
            }
        }
    }

    private static class ProjURLPair
    implements Comparable {
        private Project _project;
        private URL _url;

        public ProjURLPair(Project project, URL url) {
            this._project = project;
            this._url = url;
        }

        public Project getProject() {
            return this._project;
        }

        public URL getURL() {
            return this._url;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ProjURLPair)) {
                return false;
            }
            ProjURLPair other = (ProjURLPair)object;
            if (!(this._project != null ? this._project.equals((Object)other._project) : other._project == null)) {
                return false;
            }
            return this._url != null ? this._url.equals(other._url) : other._url == null;
        }

        public int hashCode() {
            int PRIME = 37;
            int result = 1;
            result = 37 * result + (this._project == null ? 0 : this._project.hashCode());
            result = 37 * result + (this._url == null ? 0 : this._url.hashCode());
            return result;
        }

        public int compareTo(Object o) {
            if (o instanceof ProjURLPair) {
                ProjURLPair that = (ProjURLPair)o;
                int i = this._project.getShortLabel().compareTo(that._project.getShortLabel());
                if (i == 0) {
                    i = this._url.toString().compareTo(that._url.toString());
                }
                return i;
            }
            return 0;
        }
    }
}

