/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.model.Workspace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.library.ApplicationLibraryList;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.LibraryReference;
import oracle.jdeveloper.library.UnresolvedLibrary;
import oracle.jdevimpl.library.LibrariesHook;

public final class ApplicationLibraries
extends HashStructureAdapter {
    public static final String DATA_KEY = "oracle.jdeveloper.model.ApplicationLibraries";
    public static final String REFERENCES = "libraryReferences";
    public static final String DEFINITIONS = "internalDefinitions";
    private final Workspace workspace;

    public ApplicationLibraries(HashStructure hash) {
        this(null, hash);
    }

    public ApplicationLibraries(Workspace workspace, HashStructure hash) {
        super(hash);
        this.workspace = workspace;
    }

    public static ApplicationLibraries getInstance(Workspace workspace) {
        if (workspace == null) {
            throw new NullArgumentException("null workspace");
        }
        return new ApplicationLibraries(workspace, ApplicationLibraries.findOrCreate((PropertyStorage)workspace, (String)DATA_KEY));
    }

    public static ApplicationLibraries getInstance(PropertyStorage storage) {
        boolean wasClean = storage != null && storage == Ide.getDefaultWorkspace() ? !((Workspace)storage).isDirty() : false;
        HashStructure hash = ApplicationLibraries.findOrCreate((PropertyStorage)storage, (String)DATA_KEY);
        ApplicationLibraries settings = new ApplicationLibraries(storage instanceof Workspace ? (Workspace)storage : null, hash);
        if (wasClean && ((Workspace)storage).isDirty()) {
            try {
                ((Workspace)storage).save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JLibrary> getLibraryReferences() {
        ListStructure references = this._hash.getListStructure(REFERENCES);
        if (references != null && !references.isEmpty()) {
            ApplicationLibraryList definitions = this.getLibraryDefinitions();
            Object object = references.iteratorLock();
            synchronized (object) {
                ArrayList<JLibrary> resolved = new ArrayList<JLibrary>(references.size());
                for (Object o : references) {
                    JLibrary library;
                    LibraryReference reference = new LibraryReference((HashStructure)o);
                    Object id = reference.getID();
                    JLibrary jLibrary = library = definitions == null ? null : definitions.findLibrary(id);
                    if (library == null) {
                        library = (JLibrary)reference.getLibrary();
                    }
                    if (library == null) {
                        library = new UnresolvedLibrary(id);
                    }
                    resolved.add(this.override(library));
                }
                return resolved;
            }
        }
        return Collections.emptyList();
    }

    public ApplicationLibraryList getLibraryDefinitions() {
        return new ApplicationLibraryList(this._hash.getOrCreateHashStructure(DEFINITIONS));
    }

    public void setLibraryDefinitions(ApplicationLibraryList definitions) {
        if (definitions == null) {
            this._hash.remove(DEFINITIONS);
        } else {
            definitions.copyTo(this.getLibraryDefinitions());
        }
    }

    public boolean addLibraryReference(Object id) {
        List<JLibrary> references;
        if (id == null) {
            throw new NullArgumentException("null library ID");
        }
        JLibrary library = this.resolveLibrary(id);
        if (library != null && !(references = this.getLibraryReferences()).contains(library)) {
            ArrayList<JLibrary> copy = new ArrayList<JLibrary>(references);
            copy.add(library);
            this.setLibraryReferences(copy);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLibraryReference(Object id) {
        if (id == null) {
            throw new NullArgumentException("null library ID");
        }
        List<JLibrary> references = this.getLibraryReferences();
        if (references == null) {
            return true;
        }
        JLibrary library = this.resolveLibrary(id);
        if (library != null) {
            if (references.contains(library)) {
                references.remove(library);
                this.setLibraryReferences(references);
                return true;
            }
        } else {
            ListStructure hashes = this._hash.getListStructure(REFERENCES);
            Object object = hashes.iteratorLock();
            synchronized (object) {
                Iterator iterator = hashes.iterator();
                while (iterator.hasNext()) {
                    library = new UnresolvedLibrary((HashStructure)iterator.next());
                    if (!id.equals(library.getID())) continue;
                    iterator.remove();
                    return true;
                }
            }
        }
        return false;
    }

    public JLibrary resolveLibrary(Object id) {
        JLibrary lib;
        ApplicationLibraryList list = this.getLibraryDefinitions();
        JLibrary jLibrary = lib = list == null ? null : list.findLibrary(id);
        if (lib == null) {
            lib = JLibraryManager.findLibrary(id);
        }
        return this.override(lib);
    }

    public void setLibraryReferences(List<JLibrary> libraries) {
        ArrayList<HashStructure> hashes = new ArrayList<HashStructure>(libraries.size());
        for (JLibrary library : libraries) {
            HashStructure hash = HashStructure.newInstance();
            LibraryReference reference = new LibraryReference(hash);
            reference.setLibrary(library);
            hashes.add(hash);
        }
        this._hash.getOrCreateListStructure(REFERENCES).mirror(hashes);
    }

    public boolean hasLibrary(Object id) {
        JLibrary library = this.resolveLibrary(id);
        if (library != null) {
            return this.getLibraryReferences().contains(library);
        }
        return false;
    }

    private JLibrary override(JLibrary original) {
        if (this.workspace != null && original != null && !(original instanceof UnresolvedLibrary)) {
            return LibrariesHook.getInstance().getLibraryOverride(this.workspace, null, original);
        }
        return original;
    }
}

