/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import javax.swing.Icon;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.marshal.AttributeMarker;
import oracle.jdeveloper.library.AbstractLibrary;
import oracle.jdeveloper.library.EndorsedStandardsOverride;
import oracle.jdeveloper.library.ExtensionLibrary;
import oracle.jdeveloper.library.JLibraryDefinition;

public final class AddinLibrary
extends AbstractLibrary
implements ExtensionLibrary,
EndorsedStandardsOverride {
    private static final URLPath EMPTY_URL_PATH = new URLPath();
    private final String _name;
    private final URLPath _clsPath;
    private final URLPath _srcPath;
    private final URLPath _docPath;
    private final Boolean _deployed;
    private final Boolean _forceExtInit;
    private final String _providerExtension;
    private final Boolean _hidden;
    private final URLPath _endorsedDirs;
    private final URLPath _endorsedSrcPath;
    private final URLPath _endorsedDocPath;

    public AddinLibrary(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, Boolean deployed) {
        this(name, clsPath, srcPath, docPath, deployed, true, null);
    }

    public AddinLibrary(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, Boolean deployed, Boolean forceExtInit, String providerExtension) {
        this(name, clsPath, srcPath, docPath, deployed, forceExtInit, providerExtension, false);
    }

    public AddinLibrary(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, Boolean deployed, Boolean forceExtInit, String providerExtension, Boolean hidden) {
        this(name, clsPath, srcPath, docPath, deployed, forceExtInit, providerExtension, hidden, EMPTY_URL_PATH, EMPTY_URL_PATH, EMPTY_URL_PATH);
    }

    public AddinLibrary(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, Boolean deployed, Boolean forceExtInit, String providerExtension, Boolean hidden, URLPath endorsedDirs, URLPath endorsedSrcPath, URLPath endorsedDocPath) {
        this._name = name;
        this._clsPath = new URLPath(clsPath);
        this._srcPath = new URLPath(srcPath);
        this._docPath = new URLPath(docPath);
        this._deployed = deployed != null ? deployed : Boolean.FALSE;
        this._forceExtInit = forceExtInit != null ? forceExtInit : Boolean.TRUE;
        this._providerExtension = providerExtension;
        this._hidden = hidden != null ? hidden.booleanValue() : Boolean.FALSE.booleanValue();
        this._endorsedDirs = new URLPath(endorsedDirs);
        this._endorsedSrcPath = new URLPath(endorsedSrcPath);
        this._endorsedDocPath = new URLPath(endorsedDocPath);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public URLPath getClassPath() {
        return new URLPath(this._clsPath);
    }

    @Override
    public URLPath getSourcePath() {
        return new URLPath(this._srcPath);
    }

    @Override
    public URLPath getDocPath() {
        return new URLPath(this._docPath);
    }

    @Override
    public Boolean getDeployedByDefault() throws AttributeMarker {
        return this._deployed;
    }

    @Override
    public String getShortLabel() {
        return this._name;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    @Override
    public Icon getIcon() {
        return OracleIcons.getIcon((String)"library.png");
    }

    @Override
    @Deprecated
    public JLibraryDefinition getDefaultLibraryDefinition() {
        return this;
    }

    @Override
    @Deprecated
    public JLibraryDefinition getLibraryDefinition(VersionNumber jdkVer) {
        return this;
    }

    @Override
    public void setDeployedByDefault(Boolean deployed) {
        this.immutable();
    }

    @Override
    public void markDirty(boolean dirty) {
        this.immutable();
    }

    @Override
    public void setClassPath(URLPath clsPath) {
        this.immutable();
    }

    @Override
    @Deprecated
    public void setDefaultClassPath(URLPath clsPath) {
        this.immutable();
    }

    @Override
    @Deprecated
    public void setDefaultDocPath(URLPath docPath) {
        this.immutable();
    }

    @Override
    @Deprecated
    public void setDefaultSourcePath(URLPath srcPath) {
        this.immutable();
    }

    @Override
    public void setDocPath(URLPath docPath) {
        this.immutable();
    }

    @Override
    public void setLocked(boolean isLocked) {
        this.immutable();
    }

    @Override
    public void setName(String name) {
        this.immutable();
    }

    @Override
    public void setSourcePath(URLPath srcPath) {
        this.immutable();
    }

    @Override
    public boolean getForceExtensionInitialization() {
        return this._forceExtInit;
    }

    @Override
    public String getProviderExtensionId() {
        return this._providerExtension;
    }

    @Override
    public boolean isHidden() {
        return this._hidden;
    }

    @Override
    public URLPath getEndorsedStandardsDirectories() {
        return this._endorsedDirs;
    }

    @Override
    public URLPath getEndorsedStandardsSourcePath() {
        return this._endorsedSrcPath;
    }

    @Override
    public URLPath getEndorsedStandardsDocPath() {
        return this._endorsedDocPath;
    }

    private void immutable() {
        throw new UnsupportedOperationException("AddinLibrary instances are immutable.");
    }
}

