/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

@Deprecated
public class DeployLogOutputStream
extends OutputStream {
    final Logger logger_;
    final byte[] buffer_ = new byte[256];
    int charCount_;
    Level currentLevel_ = Level.INFO;

    public DeployLogOutputStream(Logger logger) {
        this.logger_ = logger;
        this.charCount_ = 0;
    }

    public void setCurrentLevel(Level newLevel) {
        this.currentLevel_ = newLevel;
    }

    public Level getCurrentLevel() {
        return this.currentLevel_;
    }

    @Override
    public void write(int b) {
        this.buffer_[this.charCount_++] = (byte)b;
        if (this.charCount_ == this.buffer_.length || b == 10) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() {
        if (this.charCount_ == 0) {
            return;
        }
        String msg = new String(this.buffer_, 0, this.charCount_);
        Level level = this.startsWith("***", msg) || this.startsWith(">>>", msg) || this.startsWith("###", msg) || this.startsWith("WARNING", msg) ? Level.WARNING : (this.startsWith("ERROR", msg) ? Level.SEVERE : Level.INFO);
        DeployLogRecord rc = new DeployLogRecord(level, msg);
        this.logger_.log(rc);
        this.charCount_ = 0;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        super.flush();
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        super.close();
    }

    private boolean startsWith(String str, String msg) {
        int i = str.length();
        if (msg.length() < i) {
            return false;
        }
        return str.substring(0, i).toUpperCase().equals(msg.substring(0, i).toUpperCase());
    }

    class DeployLogRecord
    extends LogRecord {
        private String methodName_;
        private String className_;

        public DeployLogRecord(Level level, String msg) {
            super(level, msg);
            this.determineStackInfo();
        }

        @Override
        public String getSourceClassName() {
            return this.className_;
        }

        @Override
        public String getSourceMethodName() {
            return this.methodName_;
        }

        void determineStackInfo() {
            String packageName = DeployLogRecord.class.getPackage().getName();
            for (StackTraceElement ste : new Throwable().getStackTrace()) {
                String cn = ste.getClassName();
                if (cn.startsWith(packageName) || cn.startsWith("java.") || cn.startsWith("sun.")) continue;
                this.className_ = ste.getClassName();
                this.methodName_ = ste.getMethodName();
                return;
            }
            this.className_ = "<unknown>";
            this.methodName_ = "<unknown>";
        }
    }
}

