/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.cmd.spi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.cmd.DeployCommandState;
import oracle.jdeveloper.deploy.cmd.spi.HashDeployCommandWriter;
import oracle.jdeveloper.deploy.cmd.spi.providers.AbstractHashDeployCommandIOProvider;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public class LegacyHashDeployCommandIOProvider
extends AbstractHashDeployCommandIOProvider {
    private static final String DEPLOY_CMD_HASH = "deployCommandHashStructure";
    private static final String DEPLOY_CMD_CLASSNAME = "deployCommandClassName";
    private static final String DEPLOY_CMD = "deployCommand";

    @Override
    protected boolean canRead(Element element, HashStructure hash, ToolkitContext tkContext, Cookie cookie) {
        String className = DeployCommandState.getCommandClassName(hash);
        if (className != null) {
            cookie.put(DEPLOY_CMD_HASH, hash);
            cookie.put(DEPLOY_CMD_CLASSNAME, className);
            return true;
        }
        return false;
    }

    @Override
    protected DeployCommand read(Element element, Cookie cookie) {
        try {
            HashStructure hash = (HashStructure)cookie.get(DEPLOY_CMD_HASH);
            String className = (String)cookie.get(DEPLOY_CMD_CLASSNAME);
            Class<?> cl = this.getClass().getClassLoader().loadClass(className);
            Constructor<?> ctor = cl.getConstructor(HashStructure.class);
            DeployCommand cmd = (DeployCommand)((Object)ctor.newInstance(hash));
            return cmd;
        }
        catch (InstantiationException e) {
            LegacyHashDeployCommandIOProvider.commandInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            LegacyHashDeployCommandIOProvider.commandInstantiationException(e);
        }
        catch (InvocationTargetException e) {
            LegacyHashDeployCommandIOProvider.commandInstantiationException(e);
        }
        catch (NoSuchMethodException e) {
            LegacyHashDeployCommandIOProvider.commandInstantiationException(e);
        }
        catch (ClassNotFoundException e) {
            LegacyHashDeployCommandIOProvider.commandInstantiationException(e);
        }
        return null;
    }

    @Override
    protected boolean canWrite(Element element, DeployCommand cmd, ToolkitContext tkContext, Cookie cookie) {
        cookie.put(DEPLOY_CMD, cmd);
        return true;
    }

    @Override
    protected void write(HashStructure hash, Element element, Cookie cookie) {
        DeployCommand cmd = (DeployCommand)((Object)cookie.get(DEPLOY_CMD));
        DeployCommandState state = cmd.getState();
        state.saveTo(hash);
    }

    @Override
    protected HashDeployCommandWriter.HashDisplayable getDisplayable(Element element, Cookie cookie) {
        DeployCommand cmd = (DeployCommand)((Object)cookie.get(DEPLOY_CMD));
        return this.createDisplayable(cmd);
    }
}

