/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.wizard;
import javax.ide.command.Context;

/**
 * The Wizard interface is used to implement {@link javax.ide.model.Document}
 * creation wizards based dialogs. When a user completes the steps in a
 * wizard, a new document is generally added to the current project.  <p>
 *
 * It is up to the individual IDEs to determine where users access these
 * wizards.
 */
public interface Wizard
{
  /**
   * Invokes the object, usually called by the IDE from the button that
   * launches the wizard.
   * 
   * @param context the context of the invocation.
   * @return <CODE>true</CODE> if the invocation was successful, 
   *         <CODE>false</CODE> if it failed, or was aborted.
   * @see Context
   */
  boolean invoke( Context context );

  /**
   * Called when the availability of the wizard must be determined. IDE can
   * use the returned value to control the sensitivity of the GUI component
   * that launces this wizard.
   *
   * @param context The {@link Context} to use when invoking this 
   *                <code>Wizard</code>.
   * 
   * @return <code>true</code> if the wizard can be invoked, or 
   *         <code>false</code> otherwise.
   */
  boolean isAvailable( Context context );

}

