/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.view;

/**
 * A <code>GUIPanel</code> opaquely encapsulates the gui panel that is to 
 * be hosted by an IDE's service such as: the IDE preferences panel, 
 * the editor's panel, etc..
 * There are two components in a GUI component hierarchy that need to be 
 * identified: the root component, and the focusable component. The root
 * component will be added to the children list of the IDE host, and the 
 * focusable component will be given the focus when the IDE host becomes 
 * active.
 * For Swing based IDE's the type of the root and focusable components
 * should be: {@link javax.swing.JComponent}.
 */
public final class GUIPanel
{
  private Object _rootComponent;
  private Object _focusableComponent;

  /**
   * Constructor.
   *
   * @param  root The root component in the hierarchy of the panel encapsulated
   * by this class.
   * @param focusable The component that can take focus.
   */
  public GUIPanel( Object root, Object focusable )
  {
    _rootComponent = root;
    _focusableComponent = focusable;
  }
  
  /**
   * Constructor.
   *
   * @param  root The root component in the hierarchy of the panel encapsulated
   * by this class.
   */
  public GUIPanel( Object root )
  {
    this( root, null );
  }

  /**
   * Get the root component in the component hierarchy of the panel encapsulated
   * by this class.
   * @return The root component in the hierarchy.
   */
  public Object getRootComponent()
  {
    return _rootComponent;
  }

  /**
   * Get the component that can take input focus in the component hierarchy of 
   * the encapsulated panel.
   * @return The component that can take input focus.
   */
  public Object getFocusableComponent()
  {
    return _focusableComponent;
  }
}
