/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.property.spi;

import javax.ide.util.MetaClass;

/**
 * Record of information describing a property page and the object class
 * whose properties are edited using this page.
 */
public final class PropertyPageInfo 
{
  private String _label;
  private MetaClass _pageClass;
  private String _objectClass;
  private String _parentPage;

  /**
   * Constructor.
   */
  public PropertyPageInfo() 
  {
  }

  /**
   * Get the property page label. This label is generally displayed to the 
   * user.
   * @return The page label.
   */
  public String getLabel()
  {
    return _label;
  }

  /**
   * Set the property page label. This label is generally displayed to the 
   * user.
   * @param label The page label.
   */
  public void setLabel( String label )
  {
    _label = label;
  }
  /**
   * Get the {@link MetaClass} for this page.
   * @return The page meta class.
   */
  public MetaClass getPageClass()
  {
    return _pageClass;
  }

  /**
   * Set the {@link MetaClass} for this page.
   * @param pageClass The page meta class.
   */
  public void setPageClass( MetaClass pageClass )
  {
    _pageClass = pageClass;
  }

  /**
   * Get the object {@link MetaClass} for this page.  The EDK defines 
   * two acceptable classes: javax.ide.model.Project and javax.ide.IDE for 
   * adding property pages to the project and the IDE preferences, respectively.
   *
   * @return The object meta class. The object meta class is the class of 
   * the object for which this page is used to edit its properties.
   */
  public String getObjectClass()
  {
    return _objectClass;
  }

  /**
   * Set the object {@link MetaClass} for this page.
   * @param objectClass The object meta class. The object meta class is the class of 
   * the object for which this page is used to edit its properties.
   */
  public void setObjectClass( String objectClass )
  {
    _objectClass = objectClass;
  }
  
  public void setParentPage( String parentPage )
  {
    _parentPage = parentPage;
  }
  
  public String getParentPage()
  {
    return _parentPage;
  }
}
