/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.model.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

import javax.ide.util.MetaClass;

/**
 * Information about the recognition of one or more file suffixes as a
 * particular document type.
 */
public class SuffixRecognizer
{
  private final MetaClass _documentClass;
  private final Collection _suffixes = new HashSet();

  public SuffixRecognizer( MetaClass documentClass )
  {
    _documentClass = documentClass;
  }
  
  public final MetaClass getDocumentClass()
  {
    return _documentClass;
  }
  
  public final void addSuffix( String suffix )
  {
    // Normalize the suffix by adding a period.
    if ( suffix.charAt( 0 )  != '.' )
    {
      suffix = '.' + suffix;
    }
    _suffixes.add( suffix.toLowerCase() );
  }
  
  public Collection getSuffixes()
  {
    return Collections.unmodifiableCollection( _suffixes );
  }
  
  public final boolean containsSuffix( String suffix )
  {
    return getSuffixes().contains( suffix.toLowerCase() );
  }
}
