/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.model.spi;

import javax.ide.model.Element;

/**
 * Element factory creates instances of Elements from an implementation bridge
 * object. This should only be used for elements which do not have a URI.
 * Documents should be created via the DocumentFactory.
 */
public final class ElementFactory 
{
  private ElementFactory()
  {
  }
  
  /**
   * Create a new Element from the specified implementation bridge.
   * 
   * @param impl the implementation bridge.
   * @return an element instance.
   */
  public static Element createElement( final ElementImpl impl )
  {
    return new Element()
    {
      protected ElementImpl getElementImpl()
      {
        return impl;
      }
    };
  }
}
