/*
 * @(#)FieldVariableT.java
 */

package javax.ide.model.java.source.tree;

/**
 * A field (or enum constant) variable. <p/>
 *
 * @author Andy Yu
 * */
public interface EnumConstantT
  extends MemberVariableT
{
  /**
   * Gets the constructor invocation arguments if this is an enum
   * constant. <p/>
   *
   * If no arguments were declared, then null will be returned. If
   * this were to return a skeleton (placeholder) argument list, then
   * there would be no way to either force the empty argument list to
   * be shown or hidden. Therefore, this does not return a skeleton
   * (placeholder) argument list.<p/>
   *
   * @return Gets the argument list defined on this enum constant,
   * null if none.
   */
  public ListExpressionT getArguments();

  /**
   * Attempts to set the argument list.
   */
  public void setArguments( ListExpressionT arguments );

  /**
   * Gets the anonymous class if one was defined.
   *
   * @return Gets the anonymous class defined for this enum constant,
   * null if none, null if not an enum constant.
   */
  public ClassT getAnonymousClass();

  /**
   * Attempts to set the anonymous class.
   */
  public void setAnonymousClass( ClassT anonymousClass );
}
