/*
 * @(#)TreeTransaction.java
 */

package javax.ide.model.java.source;

import javax.ide.model.java.source.tree.FileT;
import javax.swing.undo.UndoableEdit;

/**
 * A TreeTransaction is a set of changes made to the Tree model that are
 * logically grouped into a single undoable change. <p/>
 *
 * @author Andy Yu
 */
public interface TreeTransaction
{
  /**
   * Aborts this multi-tree transaction. All changes are undone and
   * all acquired resources are released.
   * 
   * @throws IllegalStateException if this transaction has already
   * ended.
   */
  public void abort();
  
  /**
   * Logically ends a transaction, writes changes to the underlying
   * file (if any), and releases all acquired resources.
   * 
   * @return An UndoableEdit that can undo all the changes made during
   * this transaction.
   * 
   * @throws IllegalStateException if this transaction has already
   *                                  ended.
   */
  public UndoableEdit commit();

  /**
   * Gets the file involved in this transaction.
   *
   * @return The file involved in this transaction.
   */
  public FileT getFile();

  /**
   * Gets the owning manager.
   *
   * @return The owning manager.
   */
  public TreeManager getOwningManager();
}
