/*
 * @(#)PackageD.java
 */

package javax.ide.model.java.declaration;

import java.util.Collection;

/**
 * Represents a package.
 *
 * @author Andy Yu
 */
public interface PackageD
  extends Declaration, HasNameD, HasAnnotationsD
{
  /**
   * Gets the fully qualified package name.
   *
   * @return The fully qualified package name.
   */
  public String getQualifiedName();

  /**
   * Gets all known subpackages.
   *
   * @return The collection of package declarations for all known subpackages.
   * <p/>
   *
   * Collection of PackageDs.
   */
  public Collection getPackages();

  /**
   * Gets the first matching package, null if none.
   *
   * @return The package declaration for the first matching package.
   */
  public PackageD getPackage(String name);

  /**
   * Gets all known top-level classes in this package.
   *
   * @return The collection of class declarations for all known
   * top-level classes in this package.  <p/>
   *
   * Collection of ClassDs.
   */
  public Collection getClasses();
}
