/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.model;

import javax.ide.model.spi.ElementImpl;

/**
 *  The <CODE>Element</CODE> interface defines the protocol used by the
 *  IDE to communicate with data objects in order to display the objects
 *  in the UI.  For example, objects that need to be shown in an
 *  the project explorer window will need to implement the 
 *  <CODE>Element</CODE> interface.
 */
public abstract class Element
{
  protected abstract ElementImpl getElementImpl();

  public final Object getIcon()
  {
    return getElementImpl().getIcon();
  }
  
  public final String getLabel()
  {
    return getElementImpl().getLabel();
  }
  
  public final String getLongLabel()
  {
    return getElementImpl().getLongLabel();
  }
  
  public final String getToolTip()
  {
    return getElementImpl().getToolTip();
  }
}
