/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.extension;

import java.util.logging.Level;
import javax.ide.util.MetaClass;
import javax.ide.extension.spi.ExtensionVisitor;

/**
 * An abstract implementation of a visitor for manifest elements which 
 * represent meta classes.<p>
 * 
 * Subclasses provide an implementation of the 
 * {@link #metaClass( ElementContext, MetaClass )} to process the meta class
 * created for the visited xml element.
 */
public abstract class MetaClassVisitor extends ElementVisitor
{
  public final void start( ElementStartContext ctx )
  {
    // NO OP
  }
  
  public final void end( ElementEndContext ctx )
  {
    String text = ctx.getText().trim();
    if ( "".equals( text ) )
    {
      log( ctx, Level.SEVERE, "Class name is required" ); // Hmm. needs xlation
      return;
    }
    
    MetaClass mc = new MetaClass( getMetaClassLoader( ctx, text ), text );
  
    metaClass( ctx, mc );
  }
  
  /**
   * Called when a meta class is created. Subclasses will usually process or
   * store this meta class object.
   * 
   * @param context the xml context in which the meta class was created. 
   * @param mc the created meta class.
   */
  protected abstract void metaClass( ElementContext context, MetaClass mc );
  
  /**
   * Get the classloader that should be associated with the specified class.
   * 
   * This implementation returns the current classloader from the context.
   * 
   * @param context the current parsing context.
   * @param className the name of the class.
   * @return a class loader to use.
   */
  protected ClassLoader getMetaClassLoader( ElementContext context, 
    String className )
  {
    return (ClassLoader)
      context.getScopeData().get( ExtensionVisitor.KEY_CLASSLOADER );
  }
}
