/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.debug;

import java.io.IOException;

/**
 * ClientConnectors expect extension writers to start the debuggee process 
 * by calling {@link Connector#startDebuggee(Map)}. Once the debuggee is launched, 
 * the extension writer can attach the debugger to the debugge by calling 
 * {@link ClientConnector#attachDebugger()}.
 * 
 * IDE providers must provide an implementation of this interface. Extension
 * writers can access the <code>Connector</code> through the 
 * {@link Debugger#getClientConnector(Context)} method. 
 */
public abstract class ClientConnector extends Connector
{
  /**
   * Tells the debugger to attach to a debuggee process.
   * 
   * Before calling this method, the extension should either start the
   * debuggee process or tell the IDE to do so by calling
   * {@link Connector#startDebuggee(Map)}.
   * 
   * @exception IOException if the Connector is unable to attach to
   * a debuggee.
   */
  public abstract void attachDebugger() throws IOException;
}

