<?xml version="1.0"?>
<!-- 
NAME
    kustat2.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_user_pref_t UDTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
     dgagne      08/23/06 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kustat.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <xsl:param name="STAT_SCHEMA" select="''"/>
 <xsl:param name="STAT_TABLE" select="''"/>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>

 <!-- Template to recreate User Preference Statistics -->
 <xsl:template match="T_USER_PREF_STAT_T">
   <!-- This template processes user preference statistics - T_USER_PREF_STAT_T
        This template will insert rows into a stats table and then
        dbms_stats.import_table_prefs will be called to process the rows in
        the table to create the user preference statistics
     -->
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">DBMS_STATS</xsl:with-param>
     <xsl:with-param name="ObjectType">USER_PREF_STATISTICS</xsl:with-param>
     <xsl:with-param name="BaseSchemaNode" select="BASE_OBJ/OWNER_NAME"/>
     <xsl:with-param name="BaseNameNode" select="BASE_OBJ/NAME"/>
     <xsl:with-param name="BaseObjectType" select="BASE_OBJ/TYPE_NAME"/>
    </xsl:call-template>
  <!-- User Preference Statistics consists of inserts into a statistics "stat"
       table and a call to dbms_stats.import_table_prefs. -->
  <!-- Do the inserts -->
  <xsl:for-each select="UP_STATS_LIST/UP_STATS_LIST_ITEM">
   <xsl:call-template name="DoInsert">
    <xsl:with-param name="Base" select="../.."/>
    <xsl:with-param name="Node" select="."/>
    <xsl:with-param name="Truncate" select="position()=1"/>
   </xsl:call-template>
  </xsl:for-each>

  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>  DBMS_STATS.IMPORT_TABLE_PREFS('"</xsl:text>
  <xsl:call-template name="EscapeString">
   <xsl:with-param name="OrigStr" select="BASE_OBJ/OWNER_NAME"/>
  </xsl:call-template>
  <xsl:text>"', '"</xsl:text>
  <xsl:call-template name="EscapeString">
   <xsl:with-param name="OrigStr" select="BASE_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text>"', '"</xsl:text>
  <xsl:call-template name="InsertStatTabName"/>
  <xsl:text>"', NULL, '"</xsl:text>
  <xsl:call-template name="InsertStatTabSchema"/>
  <xsl:text>"'); </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>  DELETE FROM "</xsl:text>
  <xsl:call-template name="InsertStatTabSchema"/>
  <xsl:text>"."</xsl:text>
  <xsl:call-template name="InsertStatTabName"/>
  <xsl:text>"; </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>END; </xsl:text>
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>

 <xsl:template name="DoInsert">
   <!-- This template inserts a row into the statistics table.  If this is
        the first call, the anonymous pl/sql block will be initialized.
     -->
  <xsl:param name="Base"/>
  <xsl:param name="Node"/>
  <xsl:param name="Truncate"/>
  <!-- Truncate the table is this is the first statement being processed -->
  <xsl:if test="$Truncate">
   <xsl:text>BEGIN</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text>  DELETE FROM "</xsl:text>
   <xsl:call-template name="InsertStatTabSchema"/>
   <xsl:text>"."</xsl:text>
   <xsl:call-template name="InsertStatTabName"/>
   <xsl:text>"; </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:text>  INSERT INTO "</xsl:text>
  <xsl:call-template name="InsertStatTabSchema"/>
  <xsl:text>"."</xsl:text>
  <xsl:call-template name="InsertStatTabName"/>
  <xsl:text>" (type, version, c1, c2, c3, c5, d1)
               VALUES ('P', 5, '</xsl:text>
  <!--c1 is table name -->
  <xsl:call-template name="EscapeString">
   <xsl:with-param name="OrigStr" select="$Base/BASE_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text>', </xsl:text>
  <!--c2 is PNAME -->
  <xsl:choose>
   <xsl:when test="$Node/PNAME">
    <xsl:text>'</xsl:text>
    <xsl:value-of select="$Node/PNAME"/>
    <xsl:text>', </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>NULL, </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <!--c3 is valchar -->
  <xsl:choose>
   <xsl:when test="$Node/VALCHAR">
    <xsl:text>'</xsl:text>
    <xsl:value-of select="$Node/VALCHAR"/>
    <xsl:text>', </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>NULL, </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <!--c5 is schema name -->
  <xsl:text>'</xsl:text>
  <xsl:call-template name="EscapeString">
   <xsl:with-param name="OrigStr" select="$Base/BASE_OBJ/OWNER_NAME"/>
  </xsl:call-template>
  <xsl:text>', </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;       </xsl:text>
  </xsl:if>
  <!--d1 is CHGTIME -->
  <xsl:variable name="BADTIME">0000-00-00</xsl:variable>
  <xsl:choose>
   <xsl:when test="contains($Node/CHGTIME, $BADTIME)">
    <xsl:text>NULL);</xsl:text>
   </xsl:when>
   <xsl:when test="$Node/CHGTIME">
    <xsl:text>TO_DATE('</xsl:text>
    <xsl:value-of select="$Node/CHGTIME"/>
    <xsl:text>', 'YYYY-MM-DD:HH24:MI:SS'));</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>NULL);</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
