/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.jdevimpl.vcs.svn.op.ui.ValidatedPanel;
import oracle.jdevimpl.vcs.svn.res.Resource;

public class PropertyEditorPanel
extends ValidatedPanel
implements ActionListener {
    private JLabel _resourceLabel;
    private FileField _resourceField;
    private JLabel _nameLabel;
    private JComboBox _nameComboBox;
    private ComboBoxModel _fileModel;
    private ComboBoxModel _dirModel;
    private String[] _filePropertyList = new String[]{"svn:eol-style", "svn:executable", "svn:keywords", "svn:mime-type", "svn:needs-lock"};
    private String[] _dirPropertyList = new String[]{"svn:externals", "svn:ignore"};
    private ButtonGroup _valueGroup;
    private JRadioButton _stringRadio;
    private JTextArea _stringArea;
    private JScrollPane _scrollPane;
    private JButton _clearButton;
    private JRadioButton _fileRadio;
    private FileField _fileField;
    private JButton _browseButton;
    private JCheckBox _recursiveBox;
    private boolean _isRecursiveEnabled;

    public PropertyEditorPanel(boolean isRecursiveEnabled) {
        super(new GridBagLayout());
        this._isRecursiveEnabled = isRecursiveEnabled;
        this._fileModel = new PropertyComboBoxModel(this._filePropertyList);
        this._dirModel = new PropertyComboBoxModel(this._dirPropertyList);
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
    }

    private void createComponents() {
        this._resourceLabel = new JLabel();
        this._resourceField = new FileField();
        ResourceUtils.resLabel((JLabel)this._resourceLabel, (Component)this._resourceField, (String)Resource.get("UI_ADDPROPERTY_PANEL_LABEL_RESOURCE"));
        this._resourceField.setEditable(true);
        this._nameLabel = new JLabel();
        this._nameComboBox = new JComboBox();
        ResourceUtils.resLabel((JLabel)this._nameLabel, (Component)this._nameComboBox, (String)Resource.get("UI_ADDPROPERTY_PANEL_LABEL_NAME"));
        this._nameComboBox.setEditable(true);
        this._valueGroup = new ButtonGroup();
        this._stringRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._stringRadio, (String)Resource.get("UI_ADDPROPERTY_PANEL_RADIO_STRING"));
        this._stringRadio.addActionListener(this);
        this._valueGroup.add(this._stringRadio);
        this._stringArea = new JTextArea();
        this._stringArea.setText("");
        this._stringArea.setRows(3);
        this._stringArea.setLineWrap(true);
        this._scrollPane = new JScrollPane(this._stringArea, 22, 32);
        this._clearButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._clearButton, (String)Resource.get("UI_ADDPROPERTY_PANEL_BUTTON_CLEAR"));
        this.setStringRadioSelected(true);
        this._fileRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._fileRadio, (String)Resource.get("UI_ADDPROPERTY_PANEL_RADIO_FILE"));
        this._fileRadio.addActionListener(this);
        this._fileRadio.setSelected(false);
        this._valueGroup.add(this._fileRadio);
        this._fileField = new FileField();
        this._browseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._browseButton, (String)Resource.get("UI_ADDPROPERTY_PANEL_BUTTON_BROWSE"));
        this.setFileRadioSelected(false);
        this._recursiveBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._recursiveBox, (String)Resource.get("UI_ADDPROPERTY_PANEL_CHECKBOX_RECURSIVE"));
        this._recursiveBox.setEnabled(this._isRecursiveEnabled);
    }

    private void layoutComponents() {
        Insets insets = new Insets(6, 2, 2, 6);
        Insets insetsFields = new Insets(6, 95, 2, 6);
        this.add((Component)this._resourceLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._resourceField, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 13, 2, insetsFields, 0, 0));
        this.add((Component)this._nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._nameComboBox, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 13, 2, insetsFields, 0, 0));
        this.add((Component)this._stringRadio, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 3, 2, 3, 1.0, 1.0, 17, 1, insets, 0, 0));
        this.add((Component)this._clearButton, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._fileRadio, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._fileField, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._browseButton, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this._recursiveBox, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
    }

    private String chooseValueFile() {
        URLChooser chooser = DialogUtil.newURLChooser();
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(0);
        if (chooser.showOpenDialog((Component)this) == 0) {
            return URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL());
        }
        return null;
    }

    public void setResourceField(File resourceFile) {
        this._resourceField.setText(resourceFile.getAbsolutePath());
        this.setPropertyNameList(resourceFile.isFile());
        this._nameComboBox.setSelectedItem(null);
    }

    public void setResourceField(File[] resourceFiles) {
        StringBuffer resourcesStr = new StringBuffer();
        if (resourceFiles.length == 1) {
            resourcesStr.append(resourceFiles[0].getAbsolutePath());
            this.setPropertyNameList(resourceFiles[0].isFile());
        } else {
            for (File file : resourceFiles) {
                resourcesStr.append(file.getAbsolutePath());
                resourcesStr.append(";");
            }
        }
        this._resourceField.setText(resourcesStr.toString());
        this._nameComboBox.setSelectedItem(null);
    }

    public void setResourceFieldEditable(boolean editable) {
        this._resourceField.setEditable(editable);
    }

    public String getResourceField() {
        return this._resourceField.getText();
    }

    public boolean getStringRadioStatus() {
        return this._stringRadio.isSelected();
    }

    public void setStringRadioSelected(boolean isSelected) {
        this._stringRadio.setSelected(isSelected);
        this._stringArea.setEditable(isSelected);
        this._clearButton.setEnabled(isSelected);
    }

    public boolean getFileRadioStatus() {
        return this._fileRadio.isSelected();
    }

    public void setFileRadioSelected(boolean isSelected) {
        this._fileRadio.setSelected(isSelected);
        this._fileField.setEditable(isSelected);
        this._browseButton.setEnabled(isSelected);
    }

    public void setFileRadioEnabled(boolean isEnabled) {
        this._fileRadio.setEnabled(isEnabled);
        this._fileField.setEditable(isEnabled);
        this._browseButton.setEnabled(isEnabled);
    }

    public String getPropertyName() {
        return (String)this._nameComboBox.getSelectedItem();
    }

    public void setPropertyName(String propName) {
        PropertyComboBoxModel model = new PropertyComboBoxModel(new String[]{propName});
        model.setSelectedItem(propName);
        this._nameComboBox.setModel(model);
    }

    public void setPropertyNameList(boolean isFile) {
        if (isFile) {
            this._nameComboBox.setModel(this._fileModel);
        } else {
            this._nameComboBox.setModel(this._dirModel);
        }
    }

    public void setNameComboBoxEditable(boolean editable) {
        this._nameComboBox.setEditable(editable);
    }

    public String getStringPropertyValue() {
        return this._stringArea.getText();
    }

    public void setStringPropertyValue(String value) {
        this._stringArea.setText(value);
    }

    public String getFilePropertyValue() {
        return this._fileField.getText();
    }

    public void setFilePropertyValue(String fileString) {
        this._fileField.setText(fileString);
    }

    public boolean getRecursive() {
        return this._recursiveBox.isSelected();
    }

    public void setRecursieveEnabled(boolean isEnabled) {
        this._recursiveBox.setEnabled(isEnabled);
    }

    public void hideFileField() {
        this.remove(this._fileRadio);
        this.remove((Component)this._fileField);
        this.remove(this._browseButton);
        this.remove(this._recursiveBox);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._stringRadio.isSelected()) {
            this.setStringRadioSelected(true);
        } else {
            this.setStringRadioSelected(false);
        }
        if (this._fileRadio.isSelected()) {
            this.setFileRadioSelected(true);
        } else {
            this.setFileRadioSelected(false);
        }
        if (e.getSource().equals(this._clearButton)) {
            this.setStringPropertyValue("");
        }
        this.fireValidContent(this.validateContent());
        if (e.getSource().equals(this._browseButton)) {
            this.setFilePropertyValue(this.chooseValueFile());
        }
    }

    @Override
    public void initListeners() {
        this._clearButton.addActionListener(this);
        this._browseButton.addActionListener(this);
        this._resourceField.getDocument().addDocumentListener(new ValidatedPanel.FieldListener(this));
        JTextComponent editor = (JTextComponent)this._nameComboBox.getEditor().getEditorComponent();
        editor.getDocument().addDocumentListener(new ValidatedPanel.FieldListener(this));
        this._stringArea.getDocument().addDocumentListener(new ValidatedPanel.FieldListener(this));
        this._fileField.getDocument().addDocumentListener(new ValidatedPanel.FieldListener(this));
    }

    @Override
    public boolean validateContent() {
        if (this._stringRadio.isSelected()) {
            return this.resourceFieldCheck() && this.isNameComboBoxNotNull() && this.isStringAreaNotEmpty();
        }
        return this.resourceFieldCheck() && this.isNameComboBoxNotNull() && this.isFileFieldNotEmpty();
    }

    private boolean isNameComboBoxNotNull() {
        if (this._nameComboBox.isEditable()) {
            return this._nameComboBox.getEditor().getItem() != null && !this._nameComboBox.getEditor().getItem().equals("");
        }
        return this._nameComboBox.getSelectedItem() != null && !this._nameComboBox.getSelectedItem().equals("");
    }

    private boolean isStringAreaNotEmpty() {
        return !this._stringArea.getText().equals("");
    }

    private boolean isFileFieldNotEmpty() {
        return !this._fileField.getText().equals("");
    }

    private boolean isResourceFieldEditable() {
        return this._resourceField.isEditable();
    }

    private boolean resourceFieldCheck() {
        String resource = this.getResourceField();
        if (resource.equals("")) {
            return false;
        }
        if (this.isResourceFieldEditable()) {
            if (URLFileSystem.isDirectory((URL)URLFactory.newFileURL((String)resource))) {
                this.setPropertyNameList(false);
            } else {
                this.setPropertyNameList(true);
            }
        }
        return true;
    }

    protected class PropertyComboBoxModel
    implements ComboBoxModel {
        List<String> nameList;
        Object selected;
        List<ListDataListener> listenerLists;

        public PropertyComboBoxModel(String[] propNames) {
            this.nameList = new ArrayList<String>(Arrays.asList(propNames));
            this.listenerLists = new ArrayList<ListDataListener>();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selected = anItem;
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public int getSize() {
            return this.nameList.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.nameList.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listenerLists.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listenerLists.remove(l);
        }
    }
}

