/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.dbtools.raptor.ssh.core.ClientEvent;
import oracle.dbtools.raptor.ssh.core.ClientListener;
import oracle.dbtools.raptor.ssh.core.HostConnection;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ssh.core.StoreEvent;
import oracle.dbtools.raptor.ssh.core.StoreListener;
import oracle.dbtools.raptor.ssh.core.Tunnel;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.util.Logger;
import oracle.ide.model.SingletonFactory;
import oracle.ide.net.URLFileSystem;

public abstract class Client {
    private Store mStore;
    private final JSch sshClient;
    private Map<String, HostConnection> mConns = new HashMap<String, HostConnection>();
    private List<ClientListener> listeners = new CopyOnWriteArrayList<ClientListener>();
    private URL knownHosts;

    public static Client getInstance() {
        return Holder.INSTANCE;
    }

    protected Client() {
        this.sshClient = new JSch();
    }

    public Store getStore() {
        return this.mStore;
    }

    private void init() {
        URL uRL = this.getStoreURL();
        this.mStore = Store.createStore(uRL);
        try {
            this.mStore.load();
        }
        catch (IOException iOException) {
            Logger.severe(Client.class, (Throwable)iOException);
        }
        this.mStore.addStoreListener(new StoreListener(){

            @Override
            public void hostRemoved(StoreEvent storeEvent) {
                HostDescriptor hostDescriptor = storeEvent.getHostDescriptor();
                Client.this.closeConnection(hostDescriptor);
            }

            @Override
            public void hostChanged(StoreEvent storeEvent) {
                HostDescriptor hostDescriptor = (HostDescriptor)storeEvent.getOldDescriptor();
                Client.this.closeConnection(hostDescriptor);
            }

            @Override
            public void tunnelRemoved(StoreEvent storeEvent) {
                TunnelDescriptor tunnelDescriptor = storeEvent.getTunnelDescriptor();
                try {
                    Client.this.closeTunnel(tunnelDescriptor);
                }
                catch (JSchException jSchException) {
                    // empty catch block
                }
            }

            @Override
            public void tunnelChanged(StoreEvent storeEvent) {
                TunnelDescriptor tunnelDescriptor = (TunnelDescriptor)storeEvent.getOldDescriptor();
                try {
                    Client.this.closeTunnel(tunnelDescriptor);
                }
                catch (JSchException jSchException) {
                    // empty catch block
                }
            }
        });
        this.initSSHClient();
    }

    protected abstract URL getStoreURL();

    protected abstract void initSSHClient();

    protected final JSch getSSHClient() {
        return this.sshClient;
    }

    private final Session createSession(HostDescriptor hostDescriptor) throws JSchException {
        Session session = this.sshClient.getSession(hostDescriptor.getUsername(), hostDescriptor.getHostname(), hostDescriptor.getPort());
        URL uRL = this.getKnownHosts();
        if (uRL == null) {
            session.setConfig("StrictHostKeyChecking", "no");
        }
        session.setTimeout(15000);
        IdentityRepository identityRepository = this.getRepository(hostDescriptor);
        if (identityRepository != null) {
            session.setIdentityRepository(identityRepository);
        }
        this.initSession(session, hostDescriptor);
        return session;
    }

    protected URL getKnownHosts() {
        return this.knownHosts;
    }

    protected void setKnownHosts(URL uRL) {
        try {
            this.knownHosts = uRL;
            this.sshClient.setKnownHosts(URLFileSystem.getPlatformPathName((URL)this.knownHosts));
        }
        catch (JSchException jSchException) {
            Logger.severe(Client.class, (Throwable)jSchException);
        }
    }

    protected abstract IdentityRepository getRepository(HostDescriptor var1) throws JSchException;

    protected abstract void initSession(Session var1, HostDescriptor var2);

    public final synchronized HostConnection openConnection(HostDescriptor hostDescriptor) throws JSchException {
        String string = hostDescriptor.getName();
        HostConnection hostConnection = this.mConns.get(string);
        if (hostConnection == null) {
            Session session = this.createSession(hostDescriptor);
            session.connect();
            hostConnection = new HostConnection(this, session, hostDescriptor);
            this.fireConnectionOpened(hostConnection);
            this.mConns.put(string, hostConnection);
        }
        return hostConnection;
    }

    public final synchronized void closeConnection(HostDescriptor hostDescriptor) {
        String string = hostDescriptor.getName();
        HostConnection hostConnection = this.mConns.remove(string);
        if (hostConnection != null) {
            hostConnection.disconnect();
            this.fireConnectionClosed(hostConnection);
        }
    }

    public final boolean isConnectionOpen(HostDescriptor hostDescriptor) {
        String string = hostDescriptor.getName();
        return this.mConns.containsKey(string);
    }

    public final synchronized Tunnel openTunnel(TunnelDescriptor tunnelDescriptor) throws JSchException {
        HostDescriptor hostDescriptor = tunnelDescriptor.getHost();
        HostConnection hostConnection = this.openConnection(hostDescriptor);
        return hostConnection != null ? hostConnection.openTunnel(tunnelDescriptor) : null;
    }

    public final void closeTunnel(TunnelDescriptor tunnelDescriptor) throws JSchException {
        HostDescriptor hostDescriptor = tunnelDescriptor.getHost();
        String string = hostDescriptor.getName();
        HostConnection hostConnection = this.mConns.get(string);
        if (hostConnection != null) {
            hostConnection.closeTunnel(tunnelDescriptor);
        }
    }

    public final boolean isTunnelOpen(TunnelDescriptor tunnelDescriptor) {
        HostDescriptor hostDescriptor = tunnelDescriptor.getHost();
        String string = hostDescriptor.getName();
        HostConnection hostConnection = this.mConns.get(string);
        return hostConnection != null && hostConnection.isTunnelOpen(tunnelDescriptor);
    }

    public final void testConnection(HostDescriptor hostDescriptor) throws JSchException {
        Session session = this.createSession(hostDescriptor);
        session.connect();
        session.disconnect();
    }

    public final void addListener(ClientListener clientListener) {
        this.listeners.add(clientListener);
    }

    public final void removeListener(ClientListener clientListener) {
        this.listeners.remove(clientListener);
    }

    final void fireConnectionOpened(HostConnection hostConnection) {
        ClientEvent clientEvent = null;
        for (ClientListener clientListener : this.listeners) {
            if (clientEvent == null) {
                clientEvent = new ClientEvent(this, ClientEvent.EventType.SESSION_OPENED, hostConnection);
            }
            clientListener.connectionOpened(clientEvent);
        }
    }

    final void fireConnectionClosed(HostConnection hostConnection) {
        ClientEvent clientEvent = null;
        for (ClientListener clientListener : this.listeners) {
            if (clientEvent == null) {
                clientEvent = new ClientEvent(this, ClientEvent.EventType.SESSION_CLOSED, hostConnection);
            }
            clientListener.connectionClosed(clientEvent);
        }
    }

    final void fireTunnelOpened(Tunnel tunnel) {
        ClientEvent clientEvent = null;
        for (ClientListener clientListener : this.listeners) {
            if (clientEvent == null) {
                clientEvent = new ClientEvent(this, ClientEvent.EventType.TUNNEL_OPENED, tunnel);
            }
            clientListener.tunnelOpened(clientEvent);
        }
    }

    final void fireTunnelClosed(Tunnel tunnel) {
        ClientEvent clientEvent = null;
        for (ClientListener clientListener : this.listeners) {
            if (clientEvent == null) {
                clientEvent = new ClientEvent(this, ClientEvent.EventType.TUNNEL_CLOSED, tunnel);
            }
            clientListener.tunnelClosed(clientEvent);
        }
    }

    private static final class Holder {
        static final Client INSTANCE = (Client)SingletonFactory.getSingletonInstance(Client.class, (String)"SQLDeveloper.SSHClient");

        private Holder() {
        }

        static {
            Holder.INSTANCE.init();
        }
    }
}

