/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.util.List;
import oracle.ide.ceditor.find.FindController;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.find.ReplaceCriteria;
import oracle.javatools.util.Copyable;

public class FindOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "FindOptions";
    private static final String MATCH_CASE = "matchCase";
    private static final String SEARCH_FROM_BEGINNING = "searchFromBeginning";
    private static final String SEARCH_SELECTED_ONLY = "searchSelectedOnly";
    private static final String HIGHLIGHT_OCCURRENCES = "highlightOccurrences";
    private static final String WRAP_AROUND = "wrapAround";
    private static final String SEARCH_FORWARD = "searchForward";
    private static final String WHOLE_WORD_ONLY = "wholeWordOnly";
    private static final String REGEXP_SEARCH = "regexpSearch";
    private static final String PRESERVE_CASE = "preserveCase";
    private static final String SUBSTITUTE_SPECIAL = "substituteSpecial";
    private static final String SEARCH_HIST_LIST = "searchHistoryList";
    private static final String REPLACE_HIST_LIST = "replaceHistoryList";
    private static final int MAX_HIST_SIZE = 32;
    public static final int SCOPE_SINGLE = 1;
    public static final int SCOPE_PROMPTED = 2;
    public static final int SCOPE_GLOBAL = 3;
    private static final String FIND_SCOPE = "findScope";

    public FindOptions() {
        this(HashStructure.newInstance());
    }

    private FindOptions(HashStructure hash) {
        super(hash);
    }

    public static FindOptions getInstance(PropertyStorage prefs) {
        return new FindOptions(FindOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public static FindCriteria createFindCriteria() {
        FindOptions options = FindController.getFindOptions();
        FindCriteria criteria = new FindCriteria(options.getSearchText());
        criteria.setWrap(options.getWrapAround());
        criteria.setMatchCase(options.getMatchCase());
        criteria.setWholeWord(options.getWholeWordOnly());
        criteria.setRegEx(options.getRegexpSearch());
        criteria.setHighlight(options.getHighlightOccurrences());
        criteria.setDirection(options.getSearchForward() ? FindCriteria.Direction.FORWARD : FindCriteria.Direction.BACKWARD);
        return criteria;
    }

    public static ReplaceCriteria createReplaceCriteria() {
        FindOptions options = FindController.getFindOptions();
        ReplaceCriteria replaceCriteria = new ReplaceCriteria();
        replaceCriteria.setPreserveCase(options.getPreserveCase());
        replaceCriteria.setReplaceText(options.getReplaceText());
        replaceCriteria.setSubstituteSpecial(options.getSubstituteSpecial());
        switch (options.getScope()) {
            case 3: {
                replaceCriteria.setScope(ReplaceCriteria.Scope.GLOBAL);
                break;
            }
            case 2: {
                replaceCriteria.setScope(ReplaceCriteria.Scope.PROMPTED);
                break;
            }
            case 1: {
                replaceCriteria.setScope(ReplaceCriteria.Scope.SINGLE);
            }
        }
        return replaceCriteria;
    }

    public static FindCriteria createFindCriteria(BasicEditorPane editor) {
        FindCriteria criteria = FindOptions.createFindCriteria();
        FindOptions options = FindController.getFindOptions();
        if (options.getSearchSelected() && editor.hasSelection()) {
            criteria.setLowerBound(editor.getSelectionStart());
            criteria.setUpperBound(editor.getSelectionEnd());
        }
        return criteria;
    }

    @Deprecated
    public boolean getSaveOnExit() {
        return true;
    }

    @Deprecated
    public void setSaveOnExit(boolean saveOnExit) {
    }

    public boolean getMatchCase() {
        return this._hash.getBoolean(MATCH_CASE, false);
    }

    public void setMatchCase(boolean matchCase) {
        this._hash.putBoolean(MATCH_CASE, matchCase);
    }

    public boolean getSearchFromBeginning() {
        return this._hash.getBoolean(SEARCH_FROM_BEGINNING, false);
    }

    public void setSearchFromBeginning(boolean searchFromBeginning) {
        this._hash.putBoolean(SEARCH_FROM_BEGINNING, searchFromBeginning);
    }

    public boolean getSearchSelected() {
        return this._hash.getBoolean(SEARCH_SELECTED_ONLY, false);
    }

    public void setSearchSelected(boolean searchSelectedOnly) {
        this._hash.putBoolean(SEARCH_SELECTED_ONLY, searchSelectedOnly);
    }

    public boolean getHighlightOccurrences() {
        return this._hash.getBoolean(HIGHLIGHT_OCCURRENCES, true);
    }

    public void setHighlightOccurrences(boolean highlightOccurrences) {
        this._hash.putBoolean(HIGHLIGHT_OCCURRENCES, highlightOccurrences);
    }

    public boolean getWrapAround() {
        return this._hash.getBoolean(WRAP_AROUND, true);
    }

    public void setWrapAround(boolean wrapAround) {
        this._hash.putBoolean(WRAP_AROUND, wrapAround);
    }

    public boolean getSearchForward() {
        return this._hash.getBoolean(SEARCH_FORWARD, true);
    }

    public void setSearchForward(boolean searchForward) {
        this._hash.putBoolean(SEARCH_FORWARD, searchForward);
    }

    public boolean getWholeWordOnly() {
        return this._hash.getBoolean(WHOLE_WORD_ONLY, false);
    }

    public void setWholeWordOnly(boolean wholeWordOnly) {
        this._hash.putBoolean(WHOLE_WORD_ONLY, wholeWordOnly);
    }

    public boolean getRegexpSearch() {
        return this._hash.getBoolean(REGEXP_SEARCH, false);
    }

    public void setRegexpSearch(boolean regexpSearch) {
        this._hash.putBoolean(REGEXP_SEARCH, regexpSearch);
    }

    public boolean getPreserveCase() {
        return this._hash.getBoolean(PRESERVE_CASE, false);
    }

    public void setPreserveCase(boolean preserveCase) {
        this._hash.putBoolean(PRESERVE_CASE, preserveCase);
    }

    public boolean getSubstituteSpecial() {
        return this._hash.getBoolean(SUBSTITUTE_SPECIAL, false);
    }

    public void setSubstituteSpecial(boolean substituteSpecial) {
        this._hash.putBoolean(SUBSTITUTE_SPECIAL, substituteSpecial);
    }

    public List<String> getSearchHistory() {
        return this.getHistory(SEARCH_HIST_LIST);
    }

    public void setSearchText(String searchText) {
        if (searchText == null) {
            return;
        }
    }

    public String getSearchText() {
        List<String> history = this.getSearchHistory();
        return history.isEmpty() ? "" : history.get(0);
    }

    public List<String> getReplaceHistory() {
        return this.getHistory(REPLACE_HIST_LIST);
    }

    public void setReplaceText(String text) {
        if (text == null) {
            return;
        }
    }

    public String getReplaceText() {
        List<String> history = this.getReplaceHistory();
        return history.isEmpty() ? "" : history.get(0);
    }

    private List<String> getHistory(String key) {
        ListStructure listStructure = this._hash.getOrCreateListStructure(key);
        return listStructure;
    }

    void updateHistory(boolean isFind, String text) {
        String key = isFind ? SEARCH_HIST_LIST : REPLACE_HIST_LIST;
        ListStructure listStructure = this._hash.getOrCreateListStructure(key);
        int i = listStructure.indexOf((Object)text);
        if (i == -1) {
            listStructure.add(0, (Object)text);
            int size = listStructure.size();
            if (size > 32) {
                listStructure.remove(size - 1);
            }
        } else {
            listStructure.remove(i);
            listStructure.add(0, (Object)text);
        }
    }

    public int getScope() {
        return this._hash.getInt(FIND_SCOPE, 2);
    }

    public void setScope(int scope) {
        this._hash.putInt(FIND_SCOPE, scope);
    }
}

