/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.RelationValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;

public class TableValidator<T extends Table>
extends RelationValidator<T> {
    public TableValidator(DBObjectProvider prov) {
        super(prov);
    }

    @DBObjectValidator.PropertyValidator(value={"TableType"})
    public void validateTableType(ValidationContext<T> context) throws ValidationException {
        Table updated = (Table)context.getUpdatedObject();
        Table.TableType tableType = (Table.TableType)updated.getProperty("TableType");
        if (tableType != Table.TableType.NORMAL) {
            Collection allowed;
            boolean invalid = true;
            if (this.supportsOtherTableTypes() && (allowed = this.getProvider().getPropertyManager().getAllowedPropertyValues(context.getOriginalObject(), (DBObject)updated, "TableType")) != null) {
                boolean bl = invalid = !allowed.contains(tableType);
            }
            if (invalid) {
                throw new ValidationException((DBObject)updated, APIBundle.format((String)"UNSUPPORTED_TABLE_TYPE", (Object[])new Object[]{tableType == null ? "" : tableType.toString()}));
            }
        }
    }

    protected boolean supportsOtherTableTypes() {
        return false;
    }

    protected CascadeAction removeReference(DBObjectID id, DBObject referer, PropertyInfo info) throws DBException {
        CascadeAction retval = CascadeAction.NONE;
        String propName = info.getPropertyName();
        if (referer instanceof Column && ColumnSequenceProcessor.isColumnSequenceProp(propName)) {
            retval = CascadeAction.UPDATE;
            ColumnSequenceProcessor.clearColumnSequenceProps((Column)referer);
        } else {
            retval = super.removeReference(id, referer, info);
        }
        return retval;
    }

    @Override
    public CascadeAction cascadeDelete(DBObject removed, T obj) throws DBException {
        CascadeAction action;
        CascadeAction retval = CascadeAction.NONE;
        if (removed instanceof Column) {
            for (Index index : obj.getIndexes()) {
                boolean found = false;
                ArrayList<IndexObject> ios = new ArrayList<IndexObject>();
                for (IndexObject io : index.getColumnExpressions()) {
                    if (DBUtil.findUsagesIn((DBObject)removed, (DBObject)io).isEmpty()) {
                        ios.add(io);
                        continue;
                    }
                    found = true;
                }
                if (!found) continue;
                retval = CascadeAction.UPDATE;
                if (ios.isEmpty()) {
                    obj.removeIndex(index);
                    continue;
                }
                index.setColumnExpressions(ios.toArray(new IndexObject[ios.size()]));
            }
        }
        return (action = super.cascadeDelete(removed, obj)).compareTo((Enum)retval) > 0 ? action : retval;
    }

    @Override
    protected CascadeAction cascadePropertyChange(Difference objDiff, String propName, Object oldValue, Object newValue, T obj) throws DBException {
        DBObject origObj;
        CascadeAction retval = super.cascadePropertyChange(objDiff, propName, oldValue, newValue, obj);
        if ("columnIDs".equals(propName) && (origObj = (DBObject)objDiff.getOriginalObject()) instanceof UniqueConstraint) {
            Difference colIDDiff = objDiff.getChildDifference("columnIDs");
            if (colIDDiff == null) {
                this.getLogger().warning("No difference found for columnIDs on updated UK");
            } else {
                TreeSet<Integer> added = new TreeSet<Integer>();
                TreeSet<Integer> removed = new TreeSet<Integer>();
                TreeMap<Integer, Integer> reordered = new TreeMap<Integer, Integer>();
                DBObjectID[] newUKColIDs = (DBObjectID[])colIDDiff.getUpdatedObject();
                for (Difference diff : colIDDiff.getChildren()) {
                    int origi = diff.getIndexOfOriginalObject();
                    int updi = diff.getIndexOfUpdatedObject();
                    if (updi < 0) {
                        removed.add(origi);
                        continue;
                    }
                    if (origi < 0) {
                        added.add(updi);
                        continue;
                    }
                    if (origi == updi) continue;
                    reordered.put(updi, origi);
                }
                removed.removeAll(added);
                added.removeAll(removed);
                if (!reordered.isEmpty() || !removed.isEmpty()) {
                    Collection usages = DBUtil.findUsagesIn((DBObject)origObj, obj);
                    for (DBObject usage : usages) {
                        if (!(usage instanceof FKConstraint)) continue;
                        DBObjectID[] oldFKCols = ((FKConstraint)usage).getColumnIDs();
                        DBObjectID[] newFKCols = new DBObjectID[newUKColIDs.length];
                        for (int i = 0; i < newUKColIDs.length; ++i) {
                            int index = i;
                            if (reordered.containsKey(i)) {
                                index = (Integer)reordered.get(i);
                            } else if (added.contains(i)) {
                                index = -1;
                            }
                            if (index < 0 || index >= oldFKCols.length) continue;
                            newFKCols[i] = oldFKCols[index];
                        }
                        ((FKConstraint)usage).setColumnIDs(newFKCols);
                        retval = CascadeAction.UPDATE;
                    }
                }
            }
        }
        return retval;
    }

    @Override
    protected boolean cascadeColumnRename(Column renamedCol, T obj) {
        boolean retval = super.cascadeColumnRename(renamedCol, obj);
        for (Index index : obj.getIndexes()) {
            for (IndexObject io : index.getColumnExpressions()) {
                SQLFragment frag = io.getExpression();
                if (DBUtil.findUsagesIn((DBObject)renamedCol, (DBObject)frag).isEmpty()) continue;
                io.setExpressionSource(frag.getSQLText());
                io.setExpression(frag);
                retval = true;
            }
        }
        return retval;
    }

    public Set<String> getCascadeProperties() {
        Set retval = super.getCascadeProperties();
        retval.add("columnIDs");
        return retval;
    }
}

