/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenPattern;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.sql.SqlAliasExpander;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenPattern;

public class BaseSqlAliasExpander
implements SqlAliasExpander {
    private final DBObjectProvider m_prov;
    private Schema m_defaultSchema;
    boolean m_anyCols = false;
    private final PlSqlTokenPattern m_relationAlias = new PlSqlTokenPattern("{from|,|insert into|update|delete [from]} <rel ?.> <alias [?]>");

    public BaseSqlAliasExpander() {
        this(null, null);
    }

    public BaseSqlAliasExpander(DBObjectProvider prov, Schema defaultSchema) {
        this.m_prov = prov;
        if (defaultSchema == null && prov != null) {
            try {
                this.m_defaultSchema = prov.getDefaultSchema();
            }
            catch (DBException dBException) {}
        } else {
            this.m_defaultSchema = defaultSchema;
        }
    }

    public Collection<SqlAliasExpander.Usage> getUsages(String sql) {
        PlSqlToken startToken;
        PlSqlToken endToken = startToken = PlSqlTokenizer.tokenize((String)sql, (String[])new String[0]);
        while (endToken.getType() != Token.Type.END_MARKER) {
            endToken = (PlSqlToken)endToken.getNextToken();
        }
        endToken = (PlSqlToken)endToken.getPrevCodeToken();
        return this.getUsages(startToken, endToken);
    }

    public Collection<SqlAliasExpander.Usage> getUsages(PlSqlToken startToken, PlSqlToken endToken) {
        return this.parse(startToken, endToken);
    }

    public void setDefaultSchema(Schema schema) {
        this.m_defaultSchema = schema;
    }

    private Collection<SqlAliasExpander.Usage> parse(PlSqlToken startToken, PlSqlToken endToken) {
        SqlFragment.Type type;
        if (startToken.matches("select") || startToken.matches("with")) {
            type = SqlFragment.Type.QUERY;
        } else if (startToken.matches("insert")) {
            type = SqlFragment.Type.INSERT;
        } else if (startToken.matches("update")) {
            type = SqlFragment.Type.UPDATE;
        } else if (startToken.matches("delete")) {
            type = SqlFragment.Type.DELETE;
        } else {
            throw new IllegalArgumentException("Not SQL");
        }
        SqlFragment root = new SqlFragment(type, startToken, null);
        try {
            this.buildTree(root, startToken, endToken);
        }
        catch (EndOfStatement endOfStatement) {
            // empty catch block
        }
        this.m_anyCols = false;
        if (!(this.m_prov instanceof Database) && this.m_prov != null) {
            this.findColumns(root);
        }
        ArrayList<SqlAliasExpander.Usage> usages = new ArrayList<SqlAliasExpander.Usage>();
        this.expandAliases(root, usages);
        return usages;
    }

    private PlSqlToken buildTree(SqlFragment frag, PlSqlToken token, PlSqlToken endToken) throws EndOfStatement {
        PlSqlToken tk = token;
        PlSqlToken lastTk = null;
        int parens = 0;
        boolean inSelect = false;
        boolean inFrom = false;
        boolean inInto = false;
        SqlFragment prefix = null;
        SqlFragment insertTab = null;
        Boolean insertCols = null;
        while (lastTk != tk) {
            SqlFragment nextFrag;
            lastTk = tk;
            if (tk == null || tk.matches(";") || tk.getStart() > endToken.getStart() || tk.getType() == Token.Type.END_MARKER) {
                throw new EndOfStatement();
            }
            if (tk.matches("(")) {
                ++parens;
            } else if (tk.matches(")")) {
                --parens;
                insertCols = Boolean.FALSE;
            }
            if (parens < 0) break;
            if (inSelect && parens == 0 && tk.matches(",")) {
                this.checkSLIAlias(tk, prefix);
            }
            if (tk.matches("select")) {
                inSelect = true;
            } else if (inSelect && tk.matches("into")) {
                this.checkSLIAlias(tk, prefix);
                inSelect = false;
                inInto = true;
            } else if (SqlFragment.Type.SELECT.equals((Object)frag.getType()) && tk.matches("FROM")) {
                this.checkSLIAlias(tk, prefix);
                inSelect = false;
                inFrom = true;
            } else if (this.endOfFrom(tk)) {
                inFrom = false;
            } else if (SqlFragment.Type.DELETE.equals((Object)frag.getType()) && tk.matches("delete")) {
                inFrom = true;
            } else if (SqlFragment.Type.UPDATE.equals((Object)frag.getType()) && tk.matches("update")) {
                inFrom = true;
            } else if (SqlFragment.Type.INSERT.equals((Object)frag.getType()) && tk.matches("insert")) {
                inFrom = true;
            }
            if (SqlFragment.Type.QUERY.equals((Object)frag.getType()) && tk.matches("select")) {
                nextFrag = new SqlFragment(SqlFragment.Type.SELECT, tk, frag);
                tk = this.buildTree(nextFrag, tk, endToken);
                continue;
            }
            if (tk.matches("(") && ((PlSqlToken)tk.getNextCodeToken()).matches("select")) {
                tk = (PlSqlToken)tk.getNextCodeToken();
                nextFrag = new SqlFragment(SqlFragment.Type.QUERY, tk, frag);
                tk = this.buildTree(nextFrag, tk, endToken);
                tk = (PlSqlToken)tk.getNextCodeToken(2);
                continue;
            }
            if (SqlFragment.Type.SELECT.equals((Object)frag.getType()) && (tk.matches("union") || tk.matches("minus") || tk.matches("intesect"))) {
                if (tk.matches("union") && ((PlSqlToken)tk.getNextCodeToken()).matches("all")) {
                    tk = (PlSqlToken)tk.getNextCodeToken();
                }
                return (PlSqlToken)tk.getNextCodeToken();
            }
            if (inFrom) {
                inInto = false;
                if (((PlSqlToken)tk.getNextCodeToken()).matches("(")) {
                    tk = (PlSqlToken)tk.getNextCodeToken(2);
                    nextFrag = new SqlFragment(SqlFragment.Type.QUERY, tk, frag);
                    tk = this.buildTree(nextFrag, tk, endToken);
                    if (this.endOfFrom(tk = (PlSqlToken)tk.getNextCodeToken()) || tk.getType() == Token.Type.PUNCTUATION) continue;
                    frag.addAlias(BaseSqlAliasExpander.getTokenSource(tk), "0");
                    tk = (PlSqlToken)tk.getNextCodeToken();
                    continue;
                }
                TokenPattern.PatternResult mr = this.m_relationAlias.getResult((Token)tk);
                if (mr == null) continue;
                PlSqlToken aliasTk = (PlSqlToken)mr.getNamedMatchStartToken("alias");
                String rel = mr.getNamedMatch("rel", true);
                if (aliasTk != null && !this.endOfFrom(aliasTk)) {
                    tk = (PlSqlToken)aliasTk.getNextCodeToken();
                    String alias = BaseSqlAliasExpander.getTokenSource(aliasTk);
                    frag.addAlias(alias, rel);
                } else {
                    tk = (PlSqlToken)mr.getNamedMatchEndToken("rel").getNextCodeToken();
                    frag.addNonAliasedRelation(rel);
                }
                PlSqlToken t = (PlSqlToken)mr.getNamedMatchStartToken("rel");
                SqlFragment nextFrag2 = new SqlFragment(SqlFragment.Type.TOKEN, t, frag);
                nextFrag2.setName(BaseSqlAliasExpander.getTokenSource(t));
                while (((PlSqlToken)t.getNextCodeToken()).matches(".")) {
                    t = (PlSqlToken)t.getNextCodeToken(2);
                    prefix = nextFrag2;
                    nextFrag2 = new SqlFragment(SqlFragment.Type.TOKEN, t, frag);
                    nextFrag2.setPrefix(prefix);
                }
                if (frag.getType() == SqlFragment.Type.INSERT && tk.matches("(")) {
                    insertCols = Boolean.TRUE;
                    insertTab = nextFrag2;
                }
                prefix = null;
                continue;
            }
            if (tk.matches(".") && ((PlSqlToken)tk.getPrevToken()).isCode(true) && ((PlSqlToken)tk.getNextToken()).isCode(true)) {
                tk = (PlSqlToken)tk.getNextToken();
            } else {
                prefix = tk.isCode(true) && insertCols == Boolean.TRUE ? insertTab : null;
            }
            nextFrag = new SqlFragment(SqlFragment.Type.TOKEN, tk, frag);
            nextFrag.setIgnore(inInto);
            nextFrag.setPrefix(prefix);
            prefix = nextFrag;
            tk = (PlSqlToken)tk.getNextCodeToken();
        }
        return tk;
    }

    private static String getTokenSource(PlSqlToken t) {
        String ret;
        if (t.getType() == Token.Type.DOUBLE_QUOTED_STRING) {
            String n = t.getSource(false);
            ret = n.substring(1, n.length() - 1);
        } else {
            ret = t.getSource(true);
        }
        return ret;
    }

    private void findColumns(SqlFragment frag) {
        for (String relName : frag.m_nonAliasedRels) {
            Relation rel = this.findRelation(relName);
            if (rel == null) continue;
            this.m_anyCols = true;
            for (Column col : rel.getColumns()) {
                frag.m_colMap.put(col.getName(), rel);
            }
        }
        for (SqlFragment kid : frag.getChildren()) {
            this.findColumns(kid);
        }
    }

    private Relation findRelation(String relName) {
        String[] names = relName.split("\\.");
        try {
            String name;
            Schema schema;
            if (names.length > 1) {
                schema = this.m_prov.getSchema(this.m_prov.getInternalName(names[0]));
                name = this.m_prov.getInternalName(names[1]);
            } else {
                schema = this.m_defaultSchema;
                name = this.m_prov.getInternalName(names[0]);
            }
            for (String type : this.m_prov.listObjectTypes()) {
                SchemaObject so = this.m_prov.getObject(type, schema, name);
                if (so instanceof Relation) {
                    return (Relation)so;
                }
                if (!(so instanceof Synonym)) continue;
                Synonym synonym = (Synonym)so;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return null;
    }

    private void expandAliases(SqlFragment frag, Collection<SqlAliasExpander.Usage> usages) {
        List kids = frag.getChildren();
        if (kids.size() > 0) {
            for (SqlFragment kid : kids) {
                this.expandAliases(kid, usages);
            }
        } else {
            ArrayList<String> context = new ArrayList<String>();
            if (frag.getType() == SqlFragment.Type.TOKEN) {
                Relation rel;
                PlSqlToken tk = frag.getToken();
                if (!((PlSqlToken)tk.getPrevToken()).isCode(true) && ((PlSqlToken)tk.getNextCodeToken()).matches(".")) {
                    String str = this.findAlias(frag, tk);
                    if (str != null) {
                        frag.setName(str);
                        frag.setIgnore(true);
                    }
                } else if (!((PlSqlToken)tk.getPrevToken()).isCode(true) && !((PlSqlToken)tk.getNextCodeToken()).matches(".") && frag.m_prefix == null && (rel = this.findRelation(frag, BaseSqlAliasExpander.getTokenSource(tk))) != null) {
                    context.add(rel.getSchema().getName());
                    context.add(rel.getName());
                }
                if (!frag.isIgnore()) {
                    UsageImpl u = new UsageImpl();
                    context.addAll(frag.getNames());
                    u.m_tokens = context;
                    u.m_start = frag.getToken().getStart();
                    u.m_end = frag.getToken().getEnd();
                    usages.add(u);
                }
            }
        }
    }

    private String findAlias(SqlFragment frag, PlSqlToken tk) {
        String tok = BaseSqlAliasExpander.getTokenSource(tk);
        String retval = frag.getAliasFor(tok);
        if (retval != null) {
            return retval;
        }
        if (frag.getParent() != null) {
            return this.findAlias(frag.getParent(), tk);
        }
        return null;
    }

    private Relation findRelation(SqlFragment frag, String colName) {
        if (this.m_anyCols) {
            Relation retval = (Relation)frag.m_colMap.get(colName);
            if (retval != null) {
                return retval;
            }
            if (frag.getParent() != null) {
                return this.findRelation(frag.getParent(), colName);
            }
        }
        return null;
    }

    private boolean endOfFrom(PlSqlToken tk) {
        if (tk.matches(",")) {
            return false;
        }
        return tk.matches("where") || tk.matches("group") && ((PlSqlToken)tk.getNextCodeToken()).matches("by") || tk.matches("order") && ((PlSqlToken)tk.getNextCodeToken()).matches("by") || tk.matches("connect") && ((PlSqlToken)tk.getNextCodeToken()).matches("by") || tk.matches("union") || tk.matches("minus") || tk.matches("intersect") || tk.matches("log") && ((PlSqlToken)tk.getNextCodeToken()).matches("errors") || tk.matches("return") || tk.matches("returning") || tk.matches("set") || tk.matches("values") || tk.matches("select") || tk.getType() == Token.Type.PUNCTUATION || tk.getType() == Token.Type.END_MARKER;
    }

    private void checkSLIAlias(PlSqlToken tk, SqlFragment prefix) {
        PlSqlToken t = (PlSqlToken)((PlSqlToken)tk.getPrevCodeToken()).getPrevCodeToken();
        if (t.matches(")")) {
            prefix.setIgnore(true);
        } else if (!t.matches("select") && !t.matches("into") && t.getType() != Token.Type.PUNCTUATION) {
            prefix.setIgnore(true);
        }
    }

    private static class SqlFragment {
        private final Type m_type;
        private final PlSqlToken m_token;
        private final SqlFragment m_parent;
        private final List<SqlFragment> m_children = new ArrayList<SqlFragment>();
        private final Map<String, String> m_aliasMap = new HashMap<String, String>();
        private final List<String> m_nonAliasedRels = new ArrayList<String>();
        private final Map<String, Relation> m_colMap = new HashMap<String, Relation>();
        private SqlFragment m_prefix;
        private List<String> m_names = new ArrayList<String>();
        private boolean m_ignore = false;

        private SqlFragment(Type type, PlSqlToken token, SqlFragment parent) {
            this.m_type = type;
            this.m_token = token;
            this.m_parent = parent;
            if (parent != null) {
                this.m_parent.m_children.add(this);
            }
        }

        private SqlFragment getParent() {
            return this.m_parent;
        }

        private void setPrefix(SqlFragment prefix) {
            this.m_prefix = prefix;
        }

        private Type getType() {
            return this.m_type;
        }

        private PlSqlToken getToken() {
            return this.m_token;
        }

        private List<SqlFragment> getChildren() {
            return this.m_children;
        }

        private void addAlias(String alias, String rel) {
            this.m_aliasMap.put(alias, rel);
        }

        private String getAliasFor(String alias) {
            return this.m_aliasMap.get(alias);
        }

        private void addNonAliasedRelation(String rel) {
            this.m_nonAliasedRels.add(rel);
        }

        private void setIgnore(boolean ignore) {
            this.m_ignore = ignore;
        }

        private boolean isIgnore() {
            if (this.m_ignore) {
                return true;
            }
            if ("0".equals(this.getNames().get(0))) {
                return true;
            }
            if (this.m_token != null) {
                if (this.m_token.getType() == Token.Type.PUNCTUATION) {
                    return true;
                }
                if (this.m_token.getType() == Token.Type.SINGLE_QUOTED_STRING) {
                    return true;
                }
                if (this.m_token.matches("select")) {
                    return true;
                }
                if (this.m_token.getType() == Token.Type.ALPHANUMERIC) {
                    try {
                        Float f = Float.valueOf(this.m_token.getSource(false));
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return false;
            }
            return true;
        }

        private void setName(String name) {
            this.m_names.clear();
            for (String chunk : name.split("\\.")) {
                this.m_names.add(chunk);
            }
        }

        private List<String> getNames() {
            if (this.m_names.size() == 0) {
                if (this.m_prefix != null) {
                    this.m_names.addAll(this.m_prefix.getNames());
                }
                this.m_names.add(BaseSqlAliasExpander.getTokenSource(this.m_token));
            }
            return this.m_names;
        }

        static enum Type {
            QUERY,
            SELECT,
            INSERT,
            UPDATE,
            DELETE,
            TOKEN;

        }
    }

    private static class EndOfStatement
    extends Throwable {
        private EndOfStatement() {
        }
    }

    private static class UsageImpl
    implements SqlAliasExpander.Usage {
        private List<String> m_tokens;
        private int m_start;
        private int m_end;

        private UsageImpl() {
        }

        public List<String> getTokens() {
            return this.m_tokens;
        }

        public int getStartOffset() {
            return this.m_start;
        }

        public int getEndOffset() {
            return this.m_end;
        }
    }
}

