/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.Collection;
import java.util.HashSet;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.util.ModelUtil;

public class CascadeTriggerLister
extends DBObjectLister {
    public CascadeTriggerLister(DBObjectProvider pro) {
        super(pro);
    }

    public Collection<DBObjectLister.ObjectInfo> listObjects(DBObjectCriteria criteria) throws DBException {
        HashSet<DBObjectLister.ObjectInfo> ret = new HashSet<DBObjectLister.ObjectInfo>();
        try {
            for (SystemObject so : this.getProvider().listObjects(criteria)) {
                ret.addAll(this.getRelatedObjectInfos(so));
            }
        }
        catch (DBException dbe) {
            DBLog.getLogger((Object)((Object)this)).warning(dbe.getMessage());
        }
        return ret;
    }

    private Collection<DBObjectLister.ObjectInfo> getRelatedObjectInfos(SystemObject so) throws DBException {
        DBObjectID requiredBaseId;
        HashSet<DBObjectLister.ObjectInfo> retval = new HashSet<DBObjectLister.ObjectInfo>();
        HashSet<Trigger> trigSet = new HashSet<Trigger>();
        if (so != null) {
            requiredBaseId = so.getID();
            CascadeManager.LookupCriteria criteria = new CascadeManager.LookupCriteria();
            criteria.setTypes(new String[]{"TRIGGER"});
            for (DBObjectID refererID : this.getProvider().getCascadeManager().listTopLevelReferers(so, criteria)) {
                Trigger trig;
                BaseObjectID bid;
                if (!(refererID instanceof BaseObjectID) || !"TRIGGER".equals((bid = (BaseObjectID)refererID).getType()) || (trig = (Trigger)bid.resolveID()) == null) continue;
                trigSet.add(trig);
            }
        } else {
            requiredBaseId = null;
            for (CascadeManager.LookupCriteria schema : this.getProvider().listSchemas()) {
                DBObjectCriteria crit = DBObjectCriteria.createCriteria((String)"TRIGGER", (Schema)schema, (String)"%");
                for (SystemObject s : this.getProvider().listObjects(crit)) {
                    if (!(s instanceof Trigger)) continue;
                    trigSet.add((Trigger)s);
                }
            }
        }
        Trigger.BaseType requiredBaseType = so instanceof Table ? Trigger.BaseType.TABLE : (so instanceof View ? Trigger.BaseType.VIEW : (so instanceof Schema ? Trigger.BaseType.SCHEMA : Trigger.BaseType.DATABASE));
        for (Trigger trig : trigSet) {
            if (!ModelUtil.areEqual((Object)trig.getBaseType(), (Object)requiredBaseType) || !ModelUtil.areEqual((Object)trig.getBaseObjectID(), (Object)requiredBaseId)) continue;
            retval.add(new DBObjectLister.ObjectInfo(trig.getType(), trig.getSchema(), trig.getName(), (Object)trig.getID()));
        }
        return retval;
    }
}

