/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class OracleTablespaceValidator
extends DBObjectValidator<Tablespace> {
    public OracleTablespaceValidator(DBObjectProvider prov) {
        super(prov);
    }

    @DBObjectValidator.PropertyValidator(value={"fileType"}, level=ValidationLevel.FULL)
    public void validateFileTypeUpdate(Tablespace original, Tablespace updated) throws ValidationException {
        if (original != null) {
            if (original.getFileType() == Tablespace.FileType.SMALLFILE && updated.getFileType() == Tablespace.FileType.BIGFILE && updated.getFileSpecifications() != null && updated.getFileSpecifications().length > 1) {
                throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_FILE_TYPE_UPDATE"));
            }
        } else if (updated.getFileType() == Tablespace.FileType.BIGFILE && updated.getFileSpecifications() != null && updated.getFileSpecifications().length > 1) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_FILE_TYPE"));
        }
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("TablespaceType");
        return retval;
    }
}

