/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class MaterializedViewLogValidator
extends SchemaObjectValidator<MaterializedViewLog> {
    public MaterializedViewLogValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("cache");
        retval.add("columnIDs");
        retval.add("newValues");
        retval.add("parallelDegree");
        retval.add("primaryKeyLogged");
        retval.add("rowidLogged");
        retval.add("sequenceLogged");
        return retval;
    }

    @DBObjectValidator.PropertyValidator(value={"masterTableID"})
    public void validateMasterTableID(ValidationContext<MaterializedViewLog> context) throws ValidationException {
        MaterializedViewLog original = (MaterializedViewLog)context.getOriginalObject();
        MaterializedViewLog updated = (MaterializedViewLog)context.getUpdatedObject();
        DBObjectID masterID = updated.getMasterTableID();
        if (masterID == null) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"MVIEW_LOG_MISSING_MASTER"));
        }
        if (ModelUtil.areDifferent((Object)updated.getName(), (Object)DBUtil.getDBObjectName((DBObjectID)masterID))) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"MVIEW_LOG_NAME_MASTER_MISMATCH", (Object[])new Object[]{updated.getName(), DBUtil.getDBObjectName((DBObjectID)masterID)}));
        }
        if (context.getLevel() == ValidationLevel.FULL) {
            try {
                DBObject o = masterID.resolveID();
                if (o instanceof Table) {
                    Table master = (Table)o;
                    Table.TableType tabType = (Table.TableType)master.getProperty("TableType");
                    String name = updated.getName();
                    MaterializedViewLog preExisting = (MaterializedViewLog)this.getProvider().getObject("MATERIALIZED VIEW LOG", master.getSchema(), name);
                    if (preExisting != null && preExisting != original && preExisting != updated) {
                        throw new ValidationException((DBObject)updated, APIBundle.format((String)"MVIEW_LOG_MASTER_ALREADY_HAS_MVL", (Object[])new Object[]{name}));
                    }
                    if (tabType == Table.TableType.SESSION_TEMP || tabType == Table.TableType.TRANSACTION_TEMP) {
                        throw new ValidationException((DBObject)updated, APIBundle.format((String)"MVIEW_LOG_TEMP_MASTER_UNSUPPORTED", (Object[])new Object[]{name}));
                    }
                    if (master instanceof MaterializedView) {
                        MaterializedView mvMaster = (MaterializedView)master;
                        if (mvMaster.getKeyType() != MaterializedView.RefreshWith.PRIMARY_KEY) {
                            throw new ValidationException((DBObject)updated, APIBundle.format((String)"MVIEW_LOG_NO_PK_MASTER_MV_UNSUPPORTED", (Object[])new Object[]{name}));
                        }
                    } else {
                        PKConstraint pk = PKConstraint.getPrimaryKey((Relation)master);
                        if (pk == null) {
                            throw new ValidationException((DBObject)updated, APIBundle.format((String)"MVIEW_LOG_NO_PK_MASTER_UNSUPPORTED", (Object[])new Object[]{name}));
                        }
                    }
                }
            }
            catch (DBException e) {
                throw new ValidationException((DBObject)updated, e.getMessage());
            }
        }
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.NONE;
    }

    protected CascadeAction cascadePropertyChange(Difference objDiff, String propName, Object oldValue, Object newValue, MaterializedViewLog obj) throws DBException {
        boolean isLogFor = ModelUtil.areEqual((Object)obj.getMasterTableID(), (Object)((DBObject)objDiff.getOriginalObject()).getID());
        CascadeAction retval = super.cascadePropertyChange(objDiff, propName, oldValue, newValue, (SchemaObject)obj);
        if (isLogFor && retval == CascadeAction.UPDATE) {
            if ("name".equals(propName)) {
                obj.setName((String)newValue);
            } else if ("schema".equals(propName)) {
                obj.setSchema((Schema)newValue);
            }
        }
        return retval;
    }
}

