/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.LocalIndexPartitionHelper;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class IndexPartitionsValidator
extends AbstractChildDBObjectValidator<OracleIndexPartitions> {
    public IndexPartitionsValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    @DBObjectValidator.PropertyValidator(value={"globalPartitionColumns"})
    public void validateGlobalPartitionColumns(ValidationContext<OracleIndexPartitions> context) throws ValidationException {
        OracleIndexPartitions oip = (OracleIndexPartitions)context.getUpdatedObject();
        OracleIndexPartitions.PartitionType partitionType = oip.getPartitionType();
        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH || partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            DBObjectID[] partitionColumns = oip.getGlobalPartitionColumns();
            if (partitionColumns.length == 0) {
                throw new ValidationException((DBObject)oip, APIBundle.get((String)"INDEX_PARTITION_ERROR_MISSING_GLOBAL_COLUMN"));
            }
            if (context.getLevel() == ValidationLevel.FULL) {
                Table table;
                Index index = (Index)DBUtil.findParentOfType((DBObject)oip, Index.class);
                Table table2 = table = index instanceof Index ? index.getTable() : null;
                if (table != null) {
                    Column[] validColumns = OracleIndexPartitions.getValidGlobalPartitionColumns((Index)index);
                    for (int i = 0; i < partitionColumns.length; ++i) {
                        Column column = (Column)table.findOwnedObject(partitionColumns[i]);
                        if (column == null) {
                            try {
                                column = (Column)partitionColumns[i].resolveID();
                            }
                            catch (DBException e) {
                                this.logException(e, Level.FINE);
                            }
                        }
                        if (column == null || i < validColumns.length && validColumns.length >= 1 && column.getName().equals(validColumns[i].getName())) continue;
                        throw new ValidationException((DBObject)oip, APIBundle.format((String)"INDEX_PARTITION_ERROR_INVALID_GLOBAL_COLUMN", (Object[])new Object[]{column.getName()}));
                    }
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"globalHashQuantity"})
    @DBObjectValidator.PropertyDependency(value={"partitions"})
    public void validateGlobalHashPartitions(ValidationContext<OracleIndexPartitions> context) throws ValidationException {
        DBObject parent;
        OracleIndexPartitions oip = (OracleIndexPartitions)context.getUpdatedObject();
        OracleIndexPartitions.PartitionType partitionType = oip.getPartitionType();
        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH) {
            Integer globalHashQuantity = oip.getGlobalHashQuantity();
            IndexPartition[] partitions = oip.getPartitions();
            if ((globalHashQuantity == null || globalHashQuantity == 0) && partitions.length == 0) {
                throw new ValidationException((DBObject)oip, APIBundle.get((String)"INDEX_PARTITION_ERROR_MISSING_GLOBAL_HASH_PARTITIONS"));
            }
        }
        if (context.getLevel() == ValidationLevel.FULL && (parent = oip.getParent()) instanceof Index && ((Index)parent).getIndexType() == Index.IndexType.BITMAP && (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH || partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE)) {
            throw new ValidationException((DBObject)oip, APIBundle.get((String)"ORACLE_INDEX_ERROR_BITMAP_WITH_GLOBAL_PARTN"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"partitions"}, level=ValidationLevel.FULL)
    public void validatePartitions(OracleIndexPartitions orig, OracleIndexPartitions oip) throws ValidationException {
        ValidationException ve = null;
        IndexPartition[] partitions = oip.getPartitions();
        try {
            this.validateOwnedObjects(ValidationLevel.FULL, (DBObject[])partitions);
        }
        catch (ValidationException ve2) {
            ve = (ValidationException)((Object)DBException.append(ve, (DBException)((Object)ve2)));
        }
        if (oip.getParent() instanceof Index) {
            try {
                this.validatePartitionExtras(oip);
            }
            catch (ValidationException ve2) {
                ve = (ValidationException)((Object)DBException.append((DBException)((Object)ve), (DBException)((Object)ve2)));
            }
        }
        if (ve != null) {
            throw ve;
        }
    }

    private void validatePartitionExtras(OracleIndexPartitions oip) throws ValidationException {
        IndexPartition[] partitions = oip.getPartitions();
        OracleIndexPartitions.PartitionType partitionType = oip.getPartitionType();
        Index index = (Index)oip.getParent();
        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            if (partitions.length == 0) {
                throw new ValidationException((DBObject)oip, APIBundle.get((String)"INDEX_PARTITION_ERROR_MISSING_GLOBAL_RANGE_PARTITIONS"));
            }
            IndexPartition lastPartition = partitions[partitions.length - 1];
            for (Object value : lastPartition.getValuesLessThan()) {
                if (value != null && value == TablePartition.RangeValue.MAXVALUE) continue;
                throw new ValidationException((DBObject)oip, APIBundle.get((String)"INDEX_PARTITION_ERROR_INVALID_LAST_PARTITION_VALUES"));
            }
        } else if (index != null && (partitionType == OracleIndexPartitions.PartitionType.DOMAIN || partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP || partitionType == OracleIndexPartitions.PartitionType.LOCAL_HASH || partitionType == OracleIndexPartitions.PartitionType.LOCAL_OTHER)) {
            OracleTablePartitions otp;
            Table table = index.getTable();
            OracleTablePartitions oracleTablePartitions = otp = table == null ? null : (OracleTablePartitions)table.getProperty("OracleTablePartitions");
            if (partitionType == OracleIndexPartitions.PartitionType.DOMAIN && otp != null && (otp.getPartitionType() == OracleTablePartitions.PartitionType.HASH || otp.getPartitionType() == OracleTablePartitions.PartitionType.LIST || otp.getSubpartitionModel() != null)) {
                String partitionTypeString = otp.getPartitionType().toString();
                if (otp.getSubpartitionModel() != null) {
                    partitionTypeString = partitionTypeString + "-" + otp.getSubpartitionModel().getPartitionType().toString();
                }
                throw new ValidationException((DBObject)oip, APIBundle.format((String)"INDEX_PARTITION_ERROR_INELIGIBLE_DOMAIN_INDEX", (Object[])new Object[]{partitionTypeString}));
            }
            if (partitions.length > 0) {
                if (otp == null) {
                    throw new ValidationException((DBObject)oip, APIBundle.get((String)"INDEX_PARTITION_ERROR_NO_TABLE_PARTITIONS"));
                }
                int tablePartitionCount = otp.getPartitions().length;
                if (tablePartitionCount == 0 && otp.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                    int n = tablePartitionCount = otp.getHashQuantity() == null ? 1 : otp.getHashQuantity();
                }
                if (!LocalIndexPartitionHelper.areTableAndIndexPartitionsSameShape(otp, oip)) {
                    throw new ValidationException((DBObject)oip, APIBundle.get((String)"INDEX_PARTITION_ERROR_INVALID_LOCAL_PARTITIONS_COUNT"));
                }
            }
        }
    }
}

