/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import java.util.HashSet;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import oracle.javatools.db.ora.sxml.SXMLReaderException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class PartitionSXMLGenerator
extends SXMLFragmentGenerator {
    static final String SUBPART_TYPE = "PARTITION_SUB";
    static final String HASHPART_TYPE = "PARTITION_HASH";

    PartitionSXMLGenerator() {
    }

    @Override
    protected void populateNode(Node parent, Document doc, Object obj) {
        DBObject dbobj = (DBObject)obj;
        if (dbobj instanceof TablePartition) {
            OracleTablePartitions otp = ((TablePartition)dbobj).getPartitionLevelSubpartitions();
            if (otp != null) {
                this.createSubpartitionList(otp, doc, parent, "SUBPARTITION_LIST");
            }
        } else if (dbobj instanceof OracleTablePartitions) {
            OracleTablePartitions otp = ((OracleTablePartitions)dbobj).getSubpartitionModel();
            if (otp != null) {
                OracleTablePartitions.PartitionType spType = otp.getPartitionType();
                Node subpartNode = this.findOrCreateNodeAfter(doc, parent, spType + "_SUBPARTITIONING", "COL_LIST");
                this.processPropertyMapping(subpartNode, doc, otp, "COL_LIST//COL_LIST_ITEM/NAME", "partitionColumns");
                Integer quantity = otp.getHashQuantity();
                if (spType == OracleTablePartitions.PartitionType.HASH && quantity != null && quantity > 0) {
                    Node qNode = this.findOrCreateNode(doc, subpartNode, "SUBPARTITION_COUNT");
                    qNode.appendChild(doc.createTextNode(quantity.toString()));
                } else {
                    this.createSubpartitionList(otp, doc, subpartNode, "SUBPARTITION_TEMPLATE/SUBPARTITION_LIST");
                }
            }
        } else {
            OracleTablePartitions otp = (OracleTablePartitions)dbobj.getProperty("OracleTablePartitions");
            if (otp != null) {
                Node partitioningNode;
                String partitioningNodeLocation;
                OracleTablePartitions.PartitionType pType = otp.getPartitionType();
                if (obj instanceof MaterializedView) {
                    partitioningNodeLocation = pType + "_PARTITIONING";
                    HashSet<String> nodesToFollow = new HashSet<String>();
                    nodesToFollow.add("SCHEMA");
                    nodesToFollow.add("NAME");
                    nodesToFollow.add("OF_TYPE");
                    nodesToFollow.add("SCOPE_CONSTRAINT_LIST");
                    nodesToFollow.add("ON_PREBUILT_TABLE");
                    nodesToFollow.add("PHYSICAL_PROPERTIES");
                    nodesToFollow.add("COLUMN_PROPERTIES");
                    String nodeToPreceed = null;
                    for (int i = 0; i < parent.getChildNodes().getLength(); ++i) {
                        if (nodesToFollow.contains(parent.getChildNodes().item(i).getNodeName())) continue;
                        nodeToPreceed = parent.getChildNodes().item(i).getNodeName();
                        break;
                    }
                    partitioningNode = this.findOrCreateNodeBefore(doc, parent, partitioningNodeLocation, nodeToPreceed);
                } else {
                    partitioningNodeLocation = "RELATIONAL_TABLE/TABLE_PROPERTIES/" + pType + "_PARTITIONING";
                    partitioningNode = this.findOrCreateNodeBefore(doc, parent, partitioningNodeLocation, "PARALLEL");
                }
                if (pType == OracleTablePartitions.PartitionType.HASH) {
                    this.processPropertyMapping(partitioningNode, doc, otp, "COL_LIST//COL_LIST_ITEM/NAME", "partitionColumns");
                    Integer quantity = otp.getHashQuantity();
                    if (quantity != null && quantity > 0) {
                        Node qNode = this.findOrCreateNode(doc, partitioningNode, "PARTITIONS_BY_QUANTITY/QUANTITY");
                        qNode.appendChild(doc.createTextNode(quantity.toString()));
                        DBObjectID[] tbls = otp.getHashQuantityTablespaceIds();
                        if (tbls != null && tbls.length > 0) {
                            Node tNode = this.findOrCreateNode(doc, partitioningNode, "PARTITIONS_BY_QUANTITY/TABLESPACE_LIST");
                            for (int i = 0; i < tbls.length; ++i) {
                                Node tblsNode = this.createNode(doc, tNode, "TABLESPACE");
                                tblsNode.appendChild(doc.createTextNode(DBUtil.getDBObjectName((DBObjectID)tbls[i])));
                            }
                        }
                    } else {
                        Node list = this.findOrCreateNode(doc, partitioningNode, "PARTITION_LIST");
                        TablePartition[] parts = otp.getPartitions();
                        for (int i = 0; i < parts.length; ++i) {
                            Node node = this.createNode(doc, list, "PARTITION_LIST_ITEM");
                            ((SXMLGenerator)this.getParentGenerator()).populateNodeImpl(node, doc, parts[i], HASHPART_TYPE);
                        }
                    }
                } else {
                    this.getParentGenerator().populateNode(partitioningNode, doc, otp);
                }
            }
        }
    }

    private void createSubpartitionList(OracleTablePartitions otp, Document doc, Node parent, String path) {
        Node list = this.findOrCreateNode(doc, parent, path);
        TablePartition[] subparts = otp.getPartitions();
        for (int i = 0; i < subparts.length; ++i) {
            Node node = this.createNode(doc, list, "SUBPARTITION_LIST_ITEM");
            ((SXMLGenerator)this.getParentGenerator()).populateNodeImpl(node, doc, subparts[i], SUBPART_TYPE);
        }
    }

    @Override
    protected void readNode(Node parent, Object obj) throws SXMLReaderException {
        SXMLReader reader = (SXMLReader)this.getParentGenerator();
        if (obj instanceof Table) {
            Table tab = (Table)obj;
            NameBasedID tabID = new NameBasedID("TABLE", tab.getSchema().getName(), tab.getName());
            Node partitioningNode = parent;
            if (!(obj instanceof MaterializedView) && (partitioningNode = this.findNode(parent, "RELATIONAL_TABLE/TABLE_PROPERTIES")) == null) {
                return;
            }
            boolean partitioned = false;
            boolean hash = false;
            OracleTablePartitions otp = new OracleTablePartitions();
            otp.setObjectType(OracleTablePartitions.ObjectType.PARTITION);
            if (this.nodeExists(partitioningNode, "RANGE_PARTITIONING")) {
                partitioned = true;
                otp.setPartitionType(OracleTablePartitions.PartitionType.RANGE);
                partitioningNode = this.findNode(partitioningNode, "RANGE_PARTITIONING");
            } else if (this.nodeExists(partitioningNode, "LIST_PARTITIONING")) {
                partitioned = true;
                otp.setPartitionType(OracleTablePartitions.PartitionType.LIST);
                partitioningNode = this.findNode(partitioningNode, "LIST_PARTITIONING");
            } else if (this.nodeExists(partitioningNode, "HASH_PARTITIONING")) {
                partitioned = true;
                hash = true;
                otp.setPartitionType(OracleTablePartitions.PartitionType.HASH);
                partitioningNode = this.findNode(partitioningNode, "HASH_PARTITIONING");
            } else if (this.nodeExists(partitioningNode, "REFERENCE_PARTITIONING")) {
                partitioned = true;
                otp.setPartitionType(OracleTablePartitions.PartitionType.REFERENCE);
                partitioningNode = this.findNode(partitioningNode, "REFERENCE_PARTITIONING");
            }
            if (partitioned) {
                tab.setProperty("OracleTablePartitions", (Object)otp);
                if (hash) {
                    Node n;
                    SXMLFragmentGenerator.childXMLElementIterator it;
                    ArrayList<NameBasedID> partitionCols = new ArrayList<NameBasedID>();
                    Node colListNode = this.findNode(partitioningNode, "COL_LIST");
                    if (colListNode != null) {
                        SXMLFragmentGenerator.childXMLElementIterator it2 = new SXMLFragmentGenerator.childXMLElementIterator(colListNode);
                        while (it2.hasNext()) {
                            Node n2 = (Node)it2.next();
                            String colName = this.nodeText(n2, "NAME");
                            NameBasedID colID = new NameBasedID("COLUMN", colName, (DBObjectID)tabID);
                            partitionCols.add(colID);
                        }
                    }
                    otp.setPartitionColumns(partitionCols.toArray(new DBObjectID[partitionCols.size()]));
                    if (this.nodeExists(partitioningNode, "PARTITIONS_BY_QUANTITY/QUANTITY")) {
                        otp.setHashQuantity(Integer.valueOf(this.nodeText(partitioningNode, "PARTITIONS_BY_QUANTITY/QUANTITY")));
                        Node tablespacesNode = this.findNode(partitioningNode, "PARTITIONS_BY_QUANTITY/TABLESPACE_LIST");
                        if (tablespacesNode != null) {
                            ArrayList<NameBasedID> tablespaceIDs = new ArrayList<NameBasedID>();
                            it = new SXMLFragmentGenerator.childXMLElementIterator(tablespacesNode);
                            while (it.hasNext()) {
                                n = (Node)it.next();
                                NameBasedID tbspId = new NameBasedID("TABLESPACE", null, n.getTextContent());
                                tablespaceIDs.add(tbspId);
                            }
                            otp.setHashQuantityTablespaceIds(tablespaceIDs.toArray(new DBObjectID[tablespaceIDs.size()]));
                        }
                    } else {
                        Node partitionListNode = this.findNode(partitioningNode, "PARTITION_LIST");
                        if (partitionListNode != null) {
                            ArrayList<TablePartition> parts = new ArrayList<TablePartition>();
                            it = new SXMLFragmentGenerator.childXMLElementIterator(partitionListNode);
                            while (it.hasNext()) {
                                n = (Node)it.next();
                                TablePartition part = new TablePartition();
                                ((SXMLReader)this.getParentGenerator()).fillInObject(part, n, null, HASHPART_TYPE);
                                parts.add(part);
                            }
                            otp.setPartitions(parts.toArray(new TablePartition[parts.size()]));
                        }
                    }
                } else {
                    reader.fillInObject(otp, partitioningNode, null);
                }
            }
        } else if (obj instanceof TablePartition) {
            TablePartition tabPart = (TablePartition)obj;
            Node subPartitionListNode = this.findNode(parent, "SUBPARTITION_LIST");
            if (subPartitionListNode != null) {
                OracleTablePartitions otp = new OracleTablePartitions();
                tabPart.setPartitionLevelSubpartitions(otp);
                otp.setObjectType(OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
                this.readSubpartitionList(subPartitionListNode, otp);
            }
        } else if (obj instanceof OracleTablePartitions) {
            Node subPartNode = null;
            boolean subPartitioned = false;
            OracleTablePartitions otp = (OracleTablePartitions)obj;
            OracleTablePartitions subPartitions = new OracleTablePartitions();
            subPartitions.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE);
            if (this.nodeExists(parent, "RANGE_SUBPARTITIONING")) {
                subPartitioned = true;
                subPartitions.setPartitionType(OracleTablePartitions.PartitionType.RANGE);
                subPartNode = this.findNode(parent, "RANGE_SUBPARTITIONING");
            } else if (this.nodeExists(parent, "LIST_SUBPARTITIONING")) {
                subPartitioned = true;
                subPartitions.setPartitionType(OracleTablePartitions.PartitionType.LIST);
                subPartNode = this.findNode(parent, "LIST_SUBPARTITIONING");
            } else if (this.nodeExists(parent, "HASH_SUBPARTITIONING")) {
                subPartitioned = true;
                subPartitions.setPartitionType(OracleTablePartitions.PartitionType.HASH);
                subPartNode = this.findNode(parent, "HASH_SUBPARTITIONING");
                String quantity = this.nodeText(subPartNode, "SUBPARTITION_COUNT");
                if (quantity != null) {
                    subPartitions.setHashQuantity(Integer.valueOf(quantity));
                }
            }
            if (subPartitioned) {
                Node subPartitionListNode;
                otp.setSubpartitionModel(subPartitions);
                Table tab = (Table)otp.getParent();
                NameBasedID tabID = new NameBasedID("TABLE", tab.getSchema().getName(), tab.getName());
                Node colListNode = this.findNode(subPartNode, "COL_LIST");
                if (colListNode != null) {
                    ArrayList<NameBasedID> colIds = new ArrayList<NameBasedID>();
                    SXMLFragmentGenerator.childXMLElementIterator it = new SXMLFragmentGenerator.childXMLElementIterator(colListNode);
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        String colName = this.nodeText(n, "NAME");
                        NameBasedID colID = new NameBasedID("COLUMN", colName, (DBObjectID)tabID);
                        colIds.add(colID);
                    }
                    subPartitions.setPartitionColumns(colIds.toArray(new DBObjectID[colIds.size()]));
                }
                if ((subPartitionListNode = this.findNode(subPartNode, "SUBPARTITION_TEMPLATE/SUBPARTITION_LIST")) != null) {
                    this.readSubpartitionList(subPartitionListNode, subPartitions);
                }
            }
        }
    }

    private void readSubpartitionList(Node subPartitionListNode, OracleTablePartitions otp) throws SXMLReaderException {
        ArrayList<TablePartition> subParts = new ArrayList<TablePartition>();
        SXMLFragmentGenerator.childXMLElementIterator it = new SXMLFragmentGenerator.childXMLElementIterator(subPartitionListNode);
        while (it.hasNext()) {
            Node n = (Node)it.next();
            TablePartition subPart = new TablePartition();
            ((SXMLReader)this.getParentGenerator()).fillInObject(subPart, n, null, SUBPART_TYPE);
            subParts.add(subPart);
        }
        otp.setPartitions(subParts.toArray(new TablePartition[subParts.size()]));
    }
}

