/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.StringTokenizer;
import oracle.javatools.db.ora.owb.OMBPropertyResolver;
import oracle.javatools.db.ora.owb.OMBPropsStatementBuilder;
import oracle.javatools.db.plsql.Procedure;

class OMBPlsSubProgPropsBuilder
extends OMBPropsStatementBuilder {
    public OMBPlsSubProgPropsBuilder(Object forTable) {
        this.setContextObject(forTable);
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        this.registerPropertyMapping("returnTypeID/name", "RETURN_TYPE");
        this.registerPropertyMapping("source", new OMBImplementationPropResolver((Procedure)this.getContextObject()));
    }

    public final class OMBImplementationPropResolver
    extends OMBPropertyResolver {
        Procedure m_plsSubProg = null;

        public OMBImplementationPropResolver(Procedure plsSubProg) {
            this.m_plsSubProg = plsSubProg;
        }

        @Override
        public String resolvePropertyValue() {
            String query = this.m_plsSubProg.getSource();
            StringBuffer queryBuff = new StringBuffer();
            BufferingMode bufferingMode = BufferingMode.NOT_STARTED;
            StringTokenizer st = new StringTokenizer(query, " \n;'", true);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equals("IS") || token.equals("AS")) {
                    bufferingMode = BufferingMode.INITIALIZING;
                } else if (bufferingMode.equals((Object)BufferingMode.INITIALIZING) && !token.equals("\n") && !token.equals(" ")) {
                    bufferingMode = BufferingMode.BUFFERING;
                }
                if (!bufferingMode.equals((Object)BufferingMode.BUFFERING)) continue;
                if (token.equals("\n")) {
                    queryBuff.append("\\n\\\n");
                    continue;
                }
                if (token.equals("'")) {
                    queryBuff.append("''");
                    continue;
                }
                if (token.equals(";")) {
                    queryBuff.append("\\;");
                    continue;
                }
                queryBuff.append(token);
            }
            query = queryBuff.toString().trim();
            return query;
        }

        @Override
        public String resolvePropertyName() {
            return "IMPLEMENTATION";
        }
    }

    private static enum BufferingMode {
        NOT_STARTED,
        INITIALIZING,
        BUFFERING;

    }
}

