/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.bigdata;

import java.util.Iterator;
import java.util.ServiceLoader;
import oracle.dbtools.plugin.api.json.JSONReader;
import oracle.dbtools.plugin.api.json.JSONStreams;
import oracle.dbtools.plugin.api.json.JSONToken;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterBuilder;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.db.ora.bigdata.BigDataJsonArray;
import oracle.javatools.db.ora.bigdata.BigDataJsonEntry;
import oracle.javatools.db.ora.bigdata.BigDataJsonObject;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SimpleSQLFragment;

public class BigDataJsonValueBuilder
extends BigDataAccessParameterBuilder.ValueBuilder {
    @Override
    public void buildFragment(BigDataAccessParameter param) throws DBException {
        Iterator<JSONStreams> facIter;
        String val = BigDataAccessParameterMetadata.stripLineEscapes((String)param.getParameterValue());
        JSONStreams streams = null;
        ServiceLoader<JSONStreams> factory = ServiceLoader.load(JSONStreams.class, this.getClass().getClassLoader());
        if (factory != null && (facIter = factory.iterator()) != null && facIter.hasNext()) {
            streams = facIter.next();
        }
        if (streams == null) {
            throw new DBException((DBObject)param, (Throwable)new IllegalStateException("No JSON reader available"));
        }
        SQLFragment top = null;
        SQLFragment stack = null;
        try (JSONReader iter = streams.jsonReader((CharSequence)val);){
            while (iter.hasNext()) {
                JSONToken evt = iter.next();
                JSONToken.Type type = evt.type();
                int pop = 0;
                switch (type) {
                    case START_OBJECT: {
                        stack = this.addToStack(stack, (SQLFragment)new BigDataJsonObject());
                        break;
                    }
                    case START_ARRAY: {
                        stack = this.addToStack(stack, (SQLFragment)new BigDataJsonArray());
                        break;
                    }
                    case END_OBJECT: {
                        if (stack instanceof BigDataJsonEntry) {
                            ++pop;
                        }
                    }
                    case END_ARRAY: {
                        ++pop;
                        break;
                    }
                    case PROPERTY_NAME: {
                        stack = this.addToStack(stack, (SQLFragment)new BigDataJsonEntry());
                        stack.setName(evt.propertyName());
                        break;
                    }
                    default: {
                        this.addToStack(stack, this.buildValue(evt, stack));
                        if (!(stack instanceof BigDataJsonEntry)) break;
                        ++pop;
                    }
                }
                for (int i = 0; i < pop; ++i) {
                    stack = (SQLFragment)stack.getParent();
                }
                if (top != null) continue;
                top = stack;
                param.setParameterValueFragment(top);
            }
        }
        catch (Exception e) {
            throw new DBException((DBObject)param, e.getMessage(), (Throwable)e);
        }
    }

    private SQLFragment addToStack(SQLFragment stack, SQLFragment child) {
        if (stack instanceof BigDataJsonEntry) {
            ((BigDataJsonEntry)stack).setValueFragment(child);
        } else if (stack instanceof BigDataJsonArray) {
            ((BigDataJsonArray)stack).addArgument(child);
        } else if (stack instanceof BigDataJsonObject && child instanceof BigDataJsonEntry) {
            ((BigDataJsonObject)stack).addBigDataEntry((BigDataJsonEntry)child);
        } else if (stack != null) {
            throw new IllegalStateException("Cannot add " + child.getClass().getSimpleName() + " to " + stack.getClass().getSimpleName());
        }
        return child;
    }

    protected SQLFragment buildValue(JSONToken evt, SQLFragment parent) {
        DBObjectID colID;
        Column col;
        Relation tab;
        Object val;
        JSONToken.Type type = evt.type();
        switch (type) {
            case BOOLEAN_VALUE: {
                val = evt.booleanValue();
                break;
            }
            case NUMERIC_VALUE: {
                val = evt.numberValue();
                break;
            }
            case NULL_VALUE: {
                val = "";
                break;
            }
            case STRING_VALUE: {
                val = evt.stringValue();
                break;
            }
            default: {
                throw new IllegalStateException("unknown value type " + type);
            }
        }
        String name = null;
        BigDataJsonEntry entry = (BigDataJsonEntry)DBUtil.findParentOfType((DBObject)parent, BigDataJsonEntry.class);
        if (entry != null) {
            name = entry.getName();
        }
        if ("col".equals(name) && (tab = (Relation)DBUtil.findParentOfType((DBObject)entry, Relation.class)) != null && (col = tab.getColumn(val.toString())) != null && (colID = col.getID()) != null) {
            return new ColumnUsage(colID);
        }
        return new SimpleSQLFragment(val.toString());
    }
}

