/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class MaterializedViewBuilder
extends OracleTableBuilder<MaterializedView> {
    private static String TENG_REPLACE_COL = "A.UNKNOWN_TRUSTED_FD";
    private static String NON_TENG_REPLACE_COL = "'NULL'";

    MaterializedViewBuilder(BaseOracleDatabase db) {
        super(db, "MATERIALIZED VIEW");
    }

    @Override
    public void fillInConstraints(MaterializedView relation) throws DBException {
    }

    @Override
    public void fillInColumnSequenceColumns(MaterializedView relation) throws DBException {
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"updatable", "queryRewrite", "rewriteType", "refreshMode", "refreshMethod", "fastRefresh", "lastRefreshType", "lastRefreshDate", "staleness", "buildType", "onPrebuilt", "defaultIndex", "rollbackSegmentName", "rollbackSegmentType", "usingConstraints", "keyType", "nextRefreshDate", "interval", "masters"})
    public void fillInMViewProperties(final MaterializedView mview) throws DBException {
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)mview, this.getQuery(this.getDatabase().getDatabaseVersion()), mview.getSchema(), mview);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        int index = 1;
                        mview.setUpdatable(MaterializedViewBuilder.this.parseYNBoolean(rs.getString(index++)));
                        mview.setQueryRewrite(Boolean.valueOf(MaterializedViewBuilder.this.parseYNBoolean(rs.getString(index++))));
                        mview.setRewriteType(MaterializedViewBuilder.this.parseRewriteCapability(rs.getString(index++)));
                        mview.setRefreshMode(MaterializedViewBuilder.this.parseRefreshMode(rs.getString(index++)));
                        mview.setRefreshMethod(MaterializedViewBuilder.this.parseRefreshMethod(rs.getString(index++)));
                        mview.setFastRefresh(MaterializedViewBuilder.this.parseFastRefreshable(rs.getString(index++)));
                        mview.setLastRefreshType(MaterializedViewBuilder.this.parseRefreshMethod(rs.getString(index++)));
                        Timestamp timestamp = rs.getTimestamp(index++);
                        Date date = timestamp == null ? null : new Date(timestamp.getTime());
                        mview.setLastRefreshDate(date);
                        mview.setStaleness(MaterializedViewBuilder.this.parseStaleness(rs.getString(index++)));
                        mview.setBuildType(MaterializedViewBuilder.this.parseBuildType(rs.getString(index++)));
                        mview.setOnPrebuilt(MaterializedViewBuilder.this.parsePrebuilt(rs.getString(index++)));
                        mview.setDefaultIndex(Boolean.valueOf(!MaterializedViewBuilder.this.parseYNBoolean(rs.getString(index++))));
                        mview.setRollbackSegmentName(rs.getString(index++));
                        if (ModelUtil.hasLength((String)mview.getRollbackSegmentName())) {
                            mview.setRollbackSegmentType(MaterializedView.RollbackSegmentType.MASTER);
                        } else {
                            mview.setRollbackSegmentType(MaterializedView.RollbackSegmentType.LOCAL);
                            mview.setRollbackSegmentName(null);
                        }
                        mview.setUsingConstraints(MaterializedViewBuilder.this.parseUsingConstraints(rs.getString(index++)));
                        mview.setKeyType(MaterializedViewBuilder.this.parseKeyType(rs.getString(index++)));
                        timestamp = rs.getTimestamp(index++);
                        date = timestamp == null ? null : new Date(timestamp.getTime());
                        mview.setNextRefreshDate(date);
                        mview.setInterval(rs.getString(index++));
                        if (ModelUtil.hasLength((String)mview.getInterval())) {
                            mview.setRefreshMode(MaterializedView.RefreshMode.SPECIFY);
                        }
                        ArrayList<String> masters = new ArrayList<String>();
                        String master = MaterializedViewBuilder.this.parseMasterName(rs.getString(index), rs.getString(index + 1));
                        while (master != null) {
                            if (master.length() > 0) {
                                masters.add(master);
                            }
                            master = rs.next() ? MaterializedViewBuilder.this.parseMasterName(rs.getString(index), rs.getString(index + 1)) : null;
                        }
                        mview.setMasters(masters.toArray(new String[masters.size()]));
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)mview, ex);
                }
            }
        };
        wrap.executeQuery(r);
    }

    @Override
    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleStorageProperties", "OracleTableProperties", "OracleInMemoryProperties", "cache"}, depends={"TableType", "PARTITIONED TABLE"})
    public void fillInBaseProperties(MaterializedView table) throws DBException {
        super.fillInBaseProperties(table);
    }

    @Override
    protected void setBasePropertiesFromRS(MaterializedView mview, ResultSet rs) throws SQLException, DBException {
        super.setBasePropertiesFromRS(mview, rs);
        mview.setCache(Boolean.valueOf(this.parseYNBoolean(rs.getString("CACHE"))));
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"SQLQuery"})
    public void fillInQuery(final MaterializedView mview) throws DBException {
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)mview, "SELECT /*OracleDictionaryQueries.ALL_MVIEW_QUERY_QUERY*/\n       A.QUERY\nFROM SYS.ALL_MVIEWS A\nWHERE A.OWNER = ? AND A.MVIEW_NAME = ? \n", mview.getSchema(), mview);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        SQLQuery query = (SQLQuery)MaterializedViewBuilder.this.newObject(SQLQuery.class, null);
                        query.setQueryString(rs.getString(1));
                        mview.setSQLQuery(query);
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException(ex);
                }
            }
        };
        wrap.executeQuery(r);
    }

    @Override
    @AbstractDBObjectBuilder.PropertyBuilder(value={"indexes", "MatViewIndexStorageProperties"}, depends={"columns"})
    public void fillInIndexes(final MaterializedView mview) throws DBException {
        final Holder usingIndexName = new Holder();
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)mview, "SELECT /*OracleDictionaryQueries.ALL_MVIEW_INDEX_QUERY*/\n       I.INDEX_NAME \n,      I.TABLESPACE_NAME \n,      I.PCT_FREE \n,      NULL PCT_USED \n,      I.INI_TRANS \n,      I.MAX_TRANS \n,      I.INITIAL_EXTENT \n,      I.NEXT_EXTENT \n,      I.MIN_EXTENTS \n,      I.MAX_EXTENTS \n,      I.PCT_INCREASE \n,      I.FREELISTS \n,      I.FREELIST_GROUPS \n,      I.LOGGING \n,      I.BUFFER_POOL \nFROM  SYS.ALL_INDEXES I \nWHERE I.TABLE_NAME = ? \n AND I.OWNER = ? \n AND I.INDEX_NAME = \n ( SELECT C.INDEX_NAME FROM SYS.ALL_CONSTRAINTS C \n   WHERE C.TABLE_NAME = I.TABLE_NAME \n     AND C.CONSTRAINT_TYPE = 'P' \n     AND I.OWNER = NVL( C.INDEX_OWNER, C.OWNER ) ) ", mview, mview.getSchema());
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        usingIndexName.set((Object)rs.getString(1));
                        OracleStorageProperties osp = OracleTableBuilder.getSegmentAttributeProperties(rs, MaterializedViewBuilder.this.getDatabase());
                        mview.setProperty("MatViewIndexStorageProperties", (Object)osp);
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)mview, ex);
                }
            }
        };
        wrap.executeQuery(r);
        OracleIndexBuilder ib = (OracleIndexBuilder)this.getDatabase().getBuilderForType("INDEX");
        ib.fillInIndexes(mview, (String)usingIndexName.get());
        this.updateTimestamp((AbstractBuildableObject)mview, true);
    }

    private String getQuery(int databaseType) {
        String toFormat = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_PROPERTIES_QUERY*/\n  A.UPDATABLE, A.REWRITE_ENABLED, A.REWRITE_CAPABILITY, \n  A.REFRESH_MODE, A.REFRESH_METHOD, A.FAST_REFRESHABLE, \n  A.LAST_REFRESH_TYPE, A.LAST_REFRESH_DATE, A.STALENESS, A.BUILD_MODE, \n  A.UNKNOWN_PREBUILT, A.USE_NO_INDEX, A.MASTER_ROLLBACK_SEG, %1$S, \n  ( SELECT E.REFRESH_METHOD FROM SYS.ALL_SNAPSHOTS E \n    WHERE A.OWNER = E.OWNER AND A.MVIEW_NAME = E.NAME ) KEY_TYPE, \n  ( SELECT D.NEXT_DATE FROM SYS.ALL_REFRESH D \n    WHERE A.OWNER = D.ROWNER AND A.MVIEW_NAME = D.RNAME ) NEXT_DATE, \n  ( SELECT D.INTERVAL FROM SYS.ALL_REFRESH D \n    WHERE A.OWNER = D.ROWNER AND A.MVIEW_NAME = D.RNAME ) INTERVAL, \n  ( SELECT B.DETAILOBJ_OWNER FROM SYS.ALL_MVIEW_DETAIL_RELATIONS B \n    WHERE A.OWNER = B.OWNER AND A.MVIEW_NAME = B.MVIEW_NAME ) DETAILOBJ_OWNER, \n  ( SELECT B.DETAILOBJ_NAME FROM SYS.ALL_MVIEW_DETAIL_RELATIONS B \n    WHERE A.OWNER = B.OWNER AND A.MVIEW_NAME = B.MVIEW_NAME ) DETAILOBJ_NAME \nFROM SYS.ALL_MVIEWS A \nWHERE A.OWNER = ? AND A.MVIEW_NAME = ? \n";
        String qry = databaseType >= 100 ? String.format("SELECT /*OracleDictionaryQueries.ALL_MVIEW_PROPERTIES_QUERY*/\n  A.UPDATABLE, A.REWRITE_ENABLED, A.REWRITE_CAPABILITY, \n  A.REFRESH_MODE, A.REFRESH_METHOD, A.FAST_REFRESHABLE, \n  A.LAST_REFRESH_TYPE, A.LAST_REFRESH_DATE, A.STALENESS, A.BUILD_MODE, \n  A.UNKNOWN_PREBUILT, A.USE_NO_INDEX, A.MASTER_ROLLBACK_SEG, %1$S, \n  ( SELECT E.REFRESH_METHOD FROM SYS.ALL_SNAPSHOTS E \n    WHERE A.OWNER = E.OWNER AND A.MVIEW_NAME = E.NAME ) KEY_TYPE, \n  ( SELECT D.NEXT_DATE FROM SYS.ALL_REFRESH D \n    WHERE A.OWNER = D.ROWNER AND A.MVIEW_NAME = D.RNAME ) NEXT_DATE, \n  ( SELECT D.INTERVAL FROM SYS.ALL_REFRESH D \n    WHERE A.OWNER = D.ROWNER AND A.MVIEW_NAME = D.RNAME ) INTERVAL, \n  ( SELECT B.DETAILOBJ_OWNER FROM SYS.ALL_MVIEW_DETAIL_RELATIONS B \n    WHERE A.OWNER = B.OWNER AND A.MVIEW_NAME = B.MVIEW_NAME ) DETAILOBJ_OWNER, \n  ( SELECT B.DETAILOBJ_NAME FROM SYS.ALL_MVIEW_DETAIL_RELATIONS B \n    WHERE A.OWNER = B.OWNER AND A.MVIEW_NAME = B.MVIEW_NAME ) DETAILOBJ_NAME \nFROM SYS.ALL_MVIEWS A \nWHERE A.OWNER = ? AND A.MVIEW_NAME = ? \n", TENG_REPLACE_COL) : String.format("SELECT /*OracleDictionaryQueries.ALL_MVIEW_PROPERTIES_QUERY*/\n  A.UPDATABLE, A.REWRITE_ENABLED, A.REWRITE_CAPABILITY, \n  A.REFRESH_MODE, A.REFRESH_METHOD, A.FAST_REFRESHABLE, \n  A.LAST_REFRESH_TYPE, A.LAST_REFRESH_DATE, A.STALENESS, A.BUILD_MODE, \n  A.UNKNOWN_PREBUILT, A.USE_NO_INDEX, A.MASTER_ROLLBACK_SEG, %1$S, \n  ( SELECT E.REFRESH_METHOD FROM SYS.ALL_SNAPSHOTS E \n    WHERE A.OWNER = E.OWNER AND A.MVIEW_NAME = E.NAME ) KEY_TYPE, \n  ( SELECT D.NEXT_DATE FROM SYS.ALL_REFRESH D \n    WHERE A.OWNER = D.ROWNER AND A.MVIEW_NAME = D.RNAME ) NEXT_DATE, \n  ( SELECT D.INTERVAL FROM SYS.ALL_REFRESH D \n    WHERE A.OWNER = D.ROWNER AND A.MVIEW_NAME = D.RNAME ) INTERVAL, \n  ( SELECT B.DETAILOBJ_OWNER FROM SYS.ALL_MVIEW_DETAIL_RELATIONS B \n    WHERE A.OWNER = B.OWNER AND A.MVIEW_NAME = B.MVIEW_NAME ) DETAILOBJ_OWNER, \n  ( SELECT B.DETAILOBJ_NAME FROM SYS.ALL_MVIEW_DETAIL_RELATIONS B \n    WHERE A.OWNER = B.OWNER AND A.MVIEW_NAME = B.MVIEW_NAME ) DETAILOBJ_NAME \nFROM SYS.ALL_MVIEWS A \nWHERE A.OWNER = ? AND A.MVIEW_NAME = ? \n", NON_TENG_REPLACE_COL);
        return qry;
    }

    private boolean parseYNBoolean(String s) {
        return "Y".equals(s.trim());
    }

    private MaterializedView.UsingConstraints parseUsingConstraints(String s) {
        Boolean boo = this.parseYNNullBoolean(s);
        if (boo != null) {
            return boo != false ? MaterializedView.UsingConstraints.TRUSTED : MaterializedView.UsingConstraints.ENFORCED;
        }
        return null;
    }

    private MaterializedView.RefreshWith parseKeyType(String s) {
        MaterializedView.RefreshWith ret = null;
        if (s != null) {
            s = s.trim();
            s = s.replace(" ", "_");
            try {
                ret = MaterializedView.RefreshWith.valueOf((String)s);
            }
            catch (IllegalArgumentException e) {
                ret = null;
            }
        }
        return ret;
    }

    private Boolean parseYNNullBoolean(String s) {
        String trim = s.trim();
        if ("Y".equals(trim) || "YES".equals(trim)) {
            return Boolean.TRUE;
        }
        if ("N".equals(trim) || "NO".equals(trim)) {
            return Boolean.FALSE;
        }
        return null;
    }

    private int parseParallel(String s) {
        int ret;
        try {
            ret = Integer.parseInt(s.trim());
        }
        catch (NumberFormatException nfe) {
            ret = 0;
        }
        return ret;
    }

    private MaterializedView.RewriteCapability parseRewriteCapability(String s) {
        MaterializedView.RewriteCapability rc;
        if (ModelUtil.hasLength((String)s) && !DBUtil.isDeprecated((Enum)(rc = MaterializedView.RewriteCapability.valueOf((String)s)))) {
            return rc;
        }
        return null;
    }

    private MaterializedView.RefreshMode parseRefreshMode(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.RefreshMode.valueOf((String)s) : null;
    }

    private MaterializedView.RefreshMethod parseRefreshMethod(String s) {
        MaterializedView.RefreshMethod retval;
        MaterializedView.RefreshMethod refreshMethod = retval = ModelUtil.hasLength((String)s) ? MaterializedView.RefreshMethod.valueOf((String)s) : null;
        if (retval == MaterializedView.RefreshMethod.NEVER) {
            retval = null;
        } else if (retval == MaterializedView.RefreshMethod.NA) {
            retval = null;
        }
        return retval;
    }

    private MaterializedView.FastRefreshable parseFastRefreshable(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.FastRefreshable.valueOf((String)s) : null;
    }

    private MaterializedView.PrebuiltType parsePrebuilt(String s) {
        MaterializedView.PrebuiltType result = MaterializedView.PrebuiltType.NONE;
        if ("Y".equals(s)) {
            result = MaterializedView.PrebuiltType.UNSPECIFIED_PRECISION;
        }
        return result;
    }

    private MaterializedView.Staleness parseStaleness(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.Staleness.valueOf((String)s) : null;
    }

    private MaterializedView.BuildType parseBuildType(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.BuildType.valueOf((String)s) : null;
    }

    private String parseMasterName(String schema, String name) {
        StringBuffer buf = new StringBuffer(64);
        if (ModelUtil.hasLength((String)schema)) {
            buf.append(schema);
        }
        if (ModelUtil.hasLength((String)name)) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name);
        }
        return buf.toString();
    }
}

