/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.mysql.MySQL5;
import oracle.javatools.db.mysql.MySQLDatabase;
import oracle.javatools.db.mysql.MySQLDatabaseDescriptor;
import oracle.javatools.db.mysql.MySQLDatabaseImpl;

public class MySQLDatabaseFactory
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        MySQLDatabaseImpl retval = null;
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String dbName = dmd.getDatabaseProductName();
                if (dbName.startsWith("MySQL")) {
                    int v = dmd.getDatabaseMajorVersion();
                    retval = v >= 5 ? new MySQL5(connStore, connName, conn) : new MySQLDatabaseImpl(connStore, connName, conn);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return retval;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (MySQLDatabase.class.isAssignableFrom(providerClass)) {
            return new MySQLDatabaseDescriptor(providerClass);
        }
        return null;
    }
}

