/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.informix.InformixDataTypeUsageValidator;
import oracle.javatools.db.jdbc.JdbcTableBuilder;
import oracle.javatools.util.ModelUtil;

public class InformixTableBuilder
extends JdbcTableBuilder<Table> {
    public InformixTableBuilder(JdbcDatabase jdbcDatabase, String catalog) {
        super(jdbcDatabase, catalog);
    }

    @Override
    protected Map<String, Object> createDataTypeAttributes(Table rel, Column column, DataType dataType, Long size, Long scale, String jdbcTypeName) {
        Map<String, Object> retval = super.createDataTypeAttributes(rel, column, dataType, size, scale, jdbcTypeName);
        if (dataType != null) {
            String dataTypeName = dataType.getName();
            if ("VARCHAR".equals(dataTypeName) || "NVARCHAR".equals(dataTypeName)) {
                if (size != null) {
                    long length = size < 0L ? size + 65536L : size;
                    long reserve = length / 256L;
                    retval.put("size", length - reserve * 256L);
                    retval.put("reserve", reserve);
                }
            } else if ("INTERVAL".equals(dataTypeName) || "DATETIME".equals(dataTypeName)) {
                if (size != null) {
                    int precision = size.intValue() / 256;
                    int fromType = (size.intValue() - precision * 256) / 16;
                    int toType = size.intValue() - precision * 256 - fromType * 16;
                    retval.put("from", InformixTableBuilder.getTimeTypeName(fromType));
                    retval.put("to", InformixTableBuilder.getTimeTypeName(toType));
                    retval.put("precision", precision);
                    if (toType > 10) {
                        retval.put("scale", toType - 10);
                    } else {
                        retval.remove("scale");
                    }
                }
            } else if ("DECIMAL".equals(dataTypeName) && scale != null && scale.equals(255L)) {
                retval.remove("scale");
            }
        }
        return retval;
    }

    public static String getTimeTypeName(int typeCode) {
        return typeCode > 10 ? InformixDataTypeUsageValidator.TIME_UNITS[6] : InformixDataTypeUsageValidator.TIME_UNITS[typeCode / 2];
    }

    @Override
    protected void addExtraColumnAttributes(Table rel) {
        Map<String, ColumnAttributes> m_colAttribs = this.getColAttributes(rel.getName());
        for (Column col : rel.getColumns()) {
            DataTypeUsage dtu;
            ColumnAttributes colAttribs = m_colAttribs.get(col.getName());
            if (colAttribs == null) continue;
            if (ModelUtil.hasLength((String)colAttribs.getDefault())) {
                col.setDefault((Object)colAttribs.getDefault());
            }
            if (colAttribs.isNull()) {
                col.setNotNull(colAttribs.isNull());
            }
            if ((dtu = colAttribs.getDataTypeUsage()) == null) continue;
            col.setDataTypeUsage(dtu);
        }
    }

    @Override
    protected FKConstraint.ReferentialAction getFkOnDeleteAction(short keyDelete) {
        FKConstraint.ReferentialAction onDelete = keyDelete == 0 ? FKConstraint.ReferentialAction.CASCADE : FKConstraint.ReferentialAction.NO_ACTION;
        return onDelete;
    }

    private Map<String, ColumnAttributes> getColAttributes(String tableName) {
        Object result = null;
        final HashMap<String, ColumnAttributes> m_colAttribs = new HashMap<String, ColumnAttributes>();
        final JdbcDatabase db = this.getDatabase();
        final QueryWrapper wrap = new QueryWrapper((Database)db, "SELECT     sc.colname, coltype, sd.default FROM (syscolumns sc LEFT OUTER JOIN sysdefaults sd on (sd.tabid = sc.tabid and sc.colno = sd.colno)) join systables st on (st.tabid = sc.tabid) where st.tabname = ?", new Object[]{tableName});
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String defaultValue;
                        Integer colTypeNum;
                        String colType;
                        ColumnAttributes colAttribs = new ColumnAttributes();
                        String name = rs.getString(1);
                        if (ModelUtil.hasLength((String)name)) {
                            colAttribs.setName(name);
                        }
                        if (ModelUtil.hasLength((String)(colType = rs.getString(2))) && (colTypeNum = new Integer(colType)) > 256) {
                            String dataTypeName;
                            DataType dataType;
                            if (colTypeNum != 3118 || colTypeNum != 2061) {
                                colAttribs.setNotNull(true);
                            }
                            if (colTypeNum == 4118 && (dataType = db.getOrCreateDataType(dataTypeName = db.normaliseDataTypeName("ROW"))) != null) {
                                colAttribs.setDataTypeUsage(dataType.createUsage(Collections.singletonMap("name", dataTypeName)));
                            }
                        }
                        if (ModelUtil.hasLength((String)(defaultValue = rs.getString(3)))) {
                            colAttribs.setDefault(defaultValue);
                        }
                        m_colAttribs.put(name, colAttribs);
                    }
                }
                catch (SQLException e) {
                    wrap.throwDBException(e);
                }
            }
        };
        try {
            wrap.executeQuery(r);
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.WARNING, "Couldn't build extra column attributes for {0}: {1}", new String[]{tableName, dbe.getMessage()});
        }
        return m_colAttribs;
    }

    private class ColumnAttributes {
        private String m_name;
        private String m_default;
        private boolean m_notNull;
        private DataTypeUsage m_dtu;

        private ColumnAttributes() {
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public void setDefault(String def) {
            boolean isStringLiteral = false;
            for (int i = 0; i < def.length(); ++i) {
                char cmpChar = def.charAt(i);
                if (cmpChar != '\u0000') continue;
                isStringLiteral = true;
                break;
            }
            if (!isStringLiteral) {
                if (def.indexOf(32) != -1) {
                    def = def.substring(def.indexOf(32) + 1, def.length() - 1);
                }
                try {
                    BigDecimal i = new BigDecimal(def.trim());
                }
                catch (NumberFormatException e) {
                    def = "'" + def.trim() + "'";
                }
            } else {
                def = "'" + def.trim() + "'";
            }
            this.m_default = def.trim();
        }

        public String getDefault() {
            return this.m_default;
        }

        public void setNotNull(boolean notNull) {
            this.m_notNull = notNull;
        }

        public boolean isNull() {
            return this.m_notNull;
        }

        public void setDataTypeUsage(DataTypeUsage dtu) {
            this.m_dtu = dtu;
        }

        public DataTypeUsage getDataTypeUsage() {
            return this.m_dtu;
        }
    }
}

