/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.informix.InformixDatabase;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;

public abstract class InformixDatabaseImpl
extends JdbcDDLDatabase
implements InformixDatabase {
    private static final String IBM_INFORMIX_JDBC_DRIVER = "IBM Informix JDBC Driver";
    private String m_driverName;

    protected InformixDatabaseImpl(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    @Override
    public String normaliseDataTypeName(String dmdDataTypeName) {
        String typeName = dmdDataTypeName.trim().replaceAll("\\s", " ");
        return typeName.compareToIgnoreCase("INT") == 0 ? "INTEGER" : typeName;
    }

    @Override
    public String normaliseDefaultValue(DataType dataType, String defaultValue) {
        if (dataType instanceof CharacterDataType) {
            defaultValue = defaultValue.replaceAll("'", "''");
            defaultValue = "'" + defaultValue + "'";
        }
        return defaultValue;
    }

    @Override
    public String getNameForDriver(String name) {
        if (name != null && this.getDriverName() != null && this.getDriverName().startsWith(IBM_INFORMIX_JDBC_DRIVER)) {
            String lc = name.toLowerCase();
            return name.equals(lc) ? name : null;
        }
        return name;
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> criteria) throws DBException {
        Collection<T> retval;
        if (!criteria.getTypes().contains("SCHEMA") && this.getDriverName().startsWith(IBM_INFORMIX_JDBC_DRIVER)) {
            Schema schema = this.findSchema(criteria.getSchemaName());
            String[] objectTypes = criteria.getTypeArray();
            String nameLike = criteria.getNameLike();
            retval = new ArrayList<T>();
            for (String type : objectTypes) {
                DBObjectCriteria dbc = DBObjectCriteria.createCriteria((String)type, (Schema)schema, (String)nameLike);
                retval.addAll(super.listObjectsImpl(dbc));
            }
        } else {
            retval = super.listObjectsImpl(criteria);
        }
        Iterator<T> iter = retval.iterator();
        while (iter.hasNext()) {
            SystemObject sysObj = (SystemObject)iter.next();
            if (sysObj.getType() != "VIEW" || !sysObj.getName().equals("sysdomains") && !sysObj.getName().equals("sysindexes")) continue;
            iter.remove();
        }
        return retval;
    }

    private String getDriverName() {
        if (this.m_driverName == null) {
            try {
                this.m_driverName = this.getConnection().getMetaData().getDriverName();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.m_driverName;
    }

    protected Boolean isConnectionClosedImpl(SQLException sqe, Connection conn) {
        Boolean retval = conn.getClass().getName().startsWith("com.informix.jdbc") ? Boolean.valueOf(sqe != null && "IX000".equals(sqe.getSQLState()) && sqe.getErrorCode() == -79730) : super.isConnectionClosedImpl(sqe, conn);
        return retval;
    }
}

