/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.derby;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.derby.DerbyDatabase;
import oracle.javatools.db.derby.DerbyDatabaseDescriptor;
import oracle.javatools.db.derby.DerbyDatabaseImpl;

public class DerbyDatabaseFactory
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        int t = this.getType(conn);
        switch (t) {
            case 1: {
                return new DerbyDatabaseImpl(connStore, connName, conn);
            }
        }
        return null;
    }

    protected int getType(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String dbName = dmd.getDatabaseProductName();
                if (dbName.startsWith("Apache Derby")) {
                    return 1;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (DerbyDatabase.class.isAssignableFrom(providerClass)) {
            return new DerbyDatabaseDescriptor(providerClass);
        }
        return null;
    }
}

