/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.db2.DB2ColumnValidator;
import oracle.javatools.db.db2.DB2DDLGenerator;
import oracle.javatools.db.db2.DB2IndexValidator;
import oracle.javatools.db.db2.DB2UniversalDatabase;
import oracle.javatools.db.db2.DB2v10UniversalDatabaseImpl;
import oracle.javatools.db.db2.DB2v9UniversalDatabaseImpl;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SynonymValidator;

public class DB2DatabaseDescriptor
extends JdbcDatabaseDescriptor {
    public static final int MAX_NAME_LENGTH = 128;
    public static final char QUOTE_IDENTIFIER = '\"';
    public static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "AFTER", "ALL", "ALLOCATE", "ALLOW", "ALTER", "AND", "ANY", "AS", "ASSOCIATE", "ASUTIME", "AUDIT", "AUX", "AUXILIARY", "BEFORE", "BEGIN", "BETWEEN", "BUFFERPOOL", "BY", "CALL", "CAPTURE", "CASCADED", "CASE", "CAST", "CCSID", "CHAR", "CHARACTER", "CHECK", "CLOSE", "CLUSTER", "COLLECTION", "COLLID", "COLUMN", "COMMENT", "COMMIT", "CONCAT", "CONDITION", "CONNECT", "CONNECTION", "CONSTRAINT", "CONTAINS", "CONTINUE", "CREATE", "CURRENT", "CURRENT_DATE", "CURRENT_LC_CTYPE", "CURRENT_PATH", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURSOR", "DATA", "DATABASE", "DAY", "DAYS", "DBINFO", "DB2SQL", "DECLARE", "DEFAULT", "DELETE", "DESCRIPTOR", "DETERMINISTIC", "DISALLOW", "DISTINCT", "DO", "DOUBLE", "DROP", "DSNHATTR", "DSSIZE", "DYNAMIC", "EDITPROC", "ELSE", "ELSEIF", "ENCODING", "END", "ERASE", "ESCAPE", "EXCEPT", "EXECUTE", "EXISTS", "EXIT", "EXTERNAL", "FENCED", "FETCH", "FIELDPROC", "FINAL", "FOR", "FROM", "FULL", "FUNCTION", "GENERAL", "GENERATED", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HANDLER", "HAVING", "HOUR", "HOURS", "IF", "IMMEDIATE", "IN", "INDEX", "INHERIT", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INTO", "IS", "ISOBID", "JAR", "JAVA", "JOIN", "KEY", "LABEL", "LANGUAGE", "LC_CTYPE", "LEAVE", "LEFT", "LIKE", "LOCAL", "LOCALE", "LOCATOR", "LOCATORS", "LOCK", "LOCKMAX", "LOCKSIZE", "LONG", "LOOP", "MICROSECOND", "MICROSECONDS", "MINUTE", "MINUTES", "MODIFIES", "MONTH", "MONTHS", "NO", "NOT", "NULL", "NULLS", "NUMPARTS", "OBID", "OF", "ON", "OPEN", "OPTIMIZATION", "OPTIMIZE", "OR", "ORDER", "OUT", "OUTER", "PACKAGE", "PARAMETER", "PART", "PATH", "PIECESIZE", "PLAN", "PRECISION", "PREPARE", "PRIQTY", "PRIVILEGES", "PROCEDURE", "PROGRAM", "PSID", "QUERYNO", "READS", "REFERENCES", "RELEASE", "RENAME", "REPEAT", "RESTRICT", "RESULT", "RESULT_SET_LOCATOR", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLLBACK", "RUN", "SAVEPOINT", "SCHEMA", "SCRATCHPAD", "SECOND", "SECONDS", "SECQTY", "SECURITY", "SELECT", "SENSITIVE", "SIMPLE", "SETUSER", "SOME", "SOURCE", "SPECIFIC", "STANDARD", "STATIC", "STAY", "STOGROUP", "STORES", "STYLE", "SUBPAGES", "SYNONYM", "SYSFUN", "SYSIBM", "SYSPROC", "SYSTEM", "TABLE", "TABLESPACE", "THEN", "TO", "TRIGGER", "UNDO", "UNION", "UNIQUE", "UNTIL", "UPDATE", "USER", "USING", "VALIDPROC", "VALUES", "VARIANT", "VCAT", "VIEW", "VOLUMES", "WHEN", "WHERE", "WHILE", "WITH", "WLM", "YEAR", "YEARS"));

    public DB2DatabaseDescriptor(Class<? extends DB2UniversalDatabase> clz) {
        super(clz);
    }

    @Override
    public int getCasePolicy() {
        return 2;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String type) {
        return 128;
    }

    @Override
    public void validateName(String type, String name) throws InvalidNameException {
        DB2DatabaseDescriptor.validateIdentifier((String)name, (char)'\"', (int)128, (String)"_$#@", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy());
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider pro) {
        Map<String, DBObjectValidator> v = super.getValidators(pro);
        v.put("INDEX", (DBObjectValidator)new DB2IndexValidator(pro));
        v.put("COLUMN", new DB2ColumnValidator(pro));
        v.put("ALIAS", (DBObjectValidator)new SynonymValidator(pro));
        return v;
    }

    protected boolean isValidFKDataTypeImpl(DataType fktype, DataType reftype) {
        boolean isValid = super.isValidFKDataTypeImpl(fktype, reftype);
        if (!isValid && this.isCharType(fktype) && this.isCharType(reftype)) {
            isValid = true;
        }
        return isValid;
    }

    private boolean isCharType(DataType dataType) {
        String dataTypeName = dataType == null ? null : dataType.getName();
        return "CHAR".equals(dataTypeName) || "CHAR VARYING".equals(dataTypeName) || "CHARACTER".equals(dataTypeName) || "CHARACTER VARYING".equals(dataTypeName) || "VARCHAR".equals(dataTypeName);
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new DB2DDLGenerator(this.getDatabaseClass(), pro);
    }

    @Override
    public final String getDatabaseType() {
        return "DB2";
    }

    @Override
    public int getDatabaseVersion() {
        int retval = DB2v10UniversalDatabaseImpl.class.isAssignableFrom(this.getDatabaseClass()) ? 101 : (DB2v9UniversalDatabaseImpl.class.isAssignableFrom(this.getDatabaseClass()) ? 95 : 81);
        return retval;
    }

    @Override
    public Collection<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    public String getPublicSchemaName() {
        return "SYSPUBLIC";
    }

    public boolean isNullConstraintColumnAllowed(ColumnConstraint con) {
        return !(con instanceof UniqueConstraint) || !con.isEnabled();
    }

    @Override
    protected void registerDataTypes(DataTypeCache cache) {
        int version = this.getDatabaseVersion();
        if (version == 95) {
            cache.registerDataType("XML");
        } else if (version == 81) {
            cache.registerDataType("BIGINT");
            cache.registerDataType("BLOB");
            cache.registerDataType("CHAR");
            cache.registerDataType("CLOB");
            cache.registerDataType("DATALINK");
            cache.registerDataType("DATE");
            cache.registerDataType("DBCLOB");
            cache.registerDataType("DEC");
            cache.registerDataType("DECIMAL");
            cache.registerDataType("DOUBLE PRECISION");
            cache.registerDataType("DOUBLE");
            cache.registerDataType("FLOAT");
            cache.registerDataType("GRAPHIC");
            cache.registerDataType("INT");
            cache.registerDataType("INTEGER");
            cache.registerDataType("LONG VARCHAR");
            cache.registerDataType("LONG VARGRAPHIC");
            cache.registerDataType("REAL");
            cache.registerDataType("REF");
            cache.registerDataType("SMALLINT");
            cache.registerDataType("TIME");
            cache.registerDataType("TIMESTAMP");
            cache.registerDataType("VARCHAR");
            cache.registerDataType("VARGRAPHIC");
            cache.registerDataTypeSynonym("BINARY LARGE OBJECT", "BLOB");
            cache.registerDataTypeSynonym("CHAR LARGE OBJECT", "CLOB");
            cache.registerDataTypeSynonym("CHAR VARYING", "VARCHAR");
            cache.registerDataTypeSynonym("CHARACTER", "CHAR");
            cache.registerDataTypeSynonym("CHARACTER LARGE OBJECT", "CLOB");
            cache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR");
            cache.registerDataTypeSynonym("NUM", "DEC");
            cache.registerDataTypeSynonym("NUMERIC", "DECIMAL");
        }
    }
}

