/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.profiler;

import java.awt.Component;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.TuningResources;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.plsql.CompileArb;
import oracle.dbtools.raptor.plsql.PLSQLProfiles;
import oracle.dbtools.raptor.runner.DBStarterFactory;
import oracle.dbtools.raptor.runner.ParamTableModel;
import oracle.dbtools.raptor.runner.PlSqlRunnerPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.dbtools.raptor.utils.RunPrivilegedScript;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;

public class PLSQLController
implements Controller {
    private static final Object LOCK = new Object();
    private static PLSQLController _controller;
    private static final int PROFILE_COMMAND;
    private static IdeAction s_actionProfile;
    public IdeAction actionProfile;
    public JMenuItem profileMenu;

    public static IdeAction getProfileAction() {
        if (s_actionProfile == null) {
            String string = CompileArb.getString((String)"PROFILE_MENU_LABEL");
            s_actionProfile = IdeAction.get((int)PROFILE_COMMAND, (String)StringUtils.stripMnemonic((String)string), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)));
            s_actionProfile.addController((Controller)PLSQLController.getInstance());
        }
        return s_actionProfile;
    }

    private PLSQLController() {
        this.createActions();
    }

    private void createActions() {
        this.hookAction(PROFILE_COMMAND);
    }

    private void hookAction(int n) {
        IdeAction ideAction = IdeAction.get((int)n);
        ideAction.addController((Controller)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PLSQLController getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_controller == null) {
                _controller = new PLSQLController();
            }
        }
        return _controller;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PROFILE_COMMAND) {
            Node node = context.getNode();
            if (node instanceof PlSqlNode) {
                boolean bl;
                PlSqlNode plSqlNode = (PlSqlNode)node;
                boolean bl2 = bl = Boolean.valueOf((String)plSqlNode.getProperty("INVALID")) == false;
                if ("BLOCK".equals(plSqlNode.getObjectType())) {
                    bl = false;
                }
                ideAction.setEnabled(bl);
                if (DBURLFormatHelper.isDBURL((URL)plSqlNode.getURL()) && Boolean.valueOf((String)plSqlNode.getProperty("INVALID")).booleanValue()) {
                    ideAction.setEnabled(false);
                }
                if (("TYPE".equals(plSqlNode.getObjectType()) || "PACKAGE".equals(plSqlNode.getObjectType())) && !plSqlNode.hasBody()) {
                    ideAction.setEnabled(false);
                }
            }
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, final Context context) {
        DBConfig dBConfig = DBConfig.getInstance();
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (n == PROFILE_COMMAND) {
            final PlSqlNode plSqlNode = (PlSqlNode)context.getNode();
            PlSqlRunnerPanel.PlSqlProfilerPanel plSqlProfilerPanel = new PlSqlRunnerPanel.PlSqlProfilerPanel(plSqlNode);
            TextBuffer textBuffer = plSqlProfilerPanel.runDialog();
            if (textBuffer == null) {
                return true;
            }
            final String string = textBuffer.getString(0, textBuffer.getLength());
            String string2 = dBConfig.getString("PLSQLPROFILERDIR");
            if (string2 == null || "".equals(string2.trim())) {
                string2 = "PLSHPROF_DIR";
            }
            final String string3 = string2;
            final String string4 = "begin dbms_hprof.start_profiling('" + string3 + "', 'test.trc');" + "end;";
            final String string5 = "begin :1 := dbms_hprof.analyze('" + string3 + "','test.trc'," + "run_comment=>'" + plSqlNode.getProperty("commentReturn") + "'); end; ";
            NamedSwingWorker namedSwingWorker = new NamedSwingWorker("PL/SQL Profiler Starter Thread"){
                private int attempt;
                {
                    super(string6);
                    this.attempt = 0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object construct() {
                    block75: {
                        if (this.attempt++ > 2) {
                            return new Object();
                        }
                        String string12 = plSqlNode.getConnectionName();
                        if (string12 == null) {
                            string12 = DBURLFormatHelper.getConnectionName((URL)plSqlNode.getURL());
                        }
                        Statement statement = null;
                        Statement statement2 = null;
                        Database database = null;
                        try {
                            database = Connections.getInstance().getDatabase(string12, true);
                        }
                        catch (DBException dBException) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)dBException.getMessage(), null, null);
                            return new Object();
                        }
                        Connection connection = database.getConnection();
                        String string2 = null;
                        try {
                            string2 = connection.getMetaData().getUserName();
                            statement = connection.createStatement();
                            statement2 = connection.prepareCall(string4);
                            statement2.execute();
                            try {
                                statement2 = connection.prepareCall(string);
                                DBStarterFactory.bindParameters((String)string, (Statement)statement2, (ParamTableModel)DBStarterFactory.PlSqlStarter.paramTableModel);
                                statement2.execute();
                            }
                            catch (SQLException sQLException) {
                                MessageDialog.error((Component)Ide.getMainWindow(), (Object)(TuningResources.getString("PLSQLController.31") + sQLException.getMessage()), null, null);
                            }
                            statement2 = connection.prepareCall("begin dbms_hprof.stop_profiling;end;");
                            statement2.execute();
                            statement2 = connection.prepareCall(string5);
                            statement2.registerOutParameter(1, 1);
                            statement2.execute();
                            int n = statement2.getInt(1);
                        }
                        catch (SQLException sQLException) {
                            String string32 = "grant READ, WRITE on directory " + string3 + " to " + string2;
                            String string42 = "grant execute on DBMS_HPROF to " + string2;
                            String string52 = "grant create table to " + string2;
                            String string6 = "grant create sequence to " + string2;
                            String string7 = "grant unlimited tablespace to " + string2;
                            if (sQLException.getErrorCode() == 29280 || sQLException.getErrorCode() == 29289 || sQLException.getErrorCode() == 6550) {
                                block77: {
                                    ResultSet resultSet = null;
                                    String string8 = null;
                                    try {
                                        resultSet = statement.executeQuery("select directory_path from all_directories where directory_name = '" + string3 + "'");
                                        boolean bl = resultSet.next();
                                        if (bl && sQLException.getErrorCode() == 29280) {
                                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MessageFormat.format(TuningResources.getString("PLSQLController.24"), resultSet.getString(1)), null, null);
                                            Object object = new Object();
                                            return object;
                                        }
                                        if (!bl) {
                                            String string9 = TuningResources.getString("PLSQLController.27") + TuningResources.getString("PLSQLController.28") + TuningResources.getString("PLSQLController.29");
                                            string8 = JOptionPane.showInputDialog(string9, (Object)"/tmp");
                                            if (string8 == null || string8.trim().length() == 0) {
                                                throw new Exception();
                                            }
                                        } else {
                                            string8 = resultSet.getString(1);
                                        }
                                    }
                                    catch (Exception exception) {
                                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)(TuningResources.getString("PLSQLController.31") + exception.getMessage()), null, null);
                                        Object object = new Object();
                                        try {
                                            if (statement != null) {
                                                statement.close();
                                            }
                                            if (statement2 != null) {
                                                statement2.close();
                                            }
                                        }
                                        catch (SQLException sQLException2) {
                                            // empty catch block
                                        }
                                        return object;
                                    }
                                    finally {
                                        if (resultSet != null) {
                                            try {
                                                resultSet.close();
                                            }
                                            catch (SQLException sQLException3) {}
                                        }
                                    }
                                    try {
                                        String[] stringArray = new String[]{"CREATE OR REPLACE directory " + string3 + " as '" + string8 + "'", string32, string42, string52, string6, string7};
                                        boolean bl = RunPrivilegedScript.runWithPreview((String[])stringArray, (String)string12, (String)"sys", (String)"sysdba");
                                        if (bl) break block77;
                                        Object object = new Object();
                                        return object;
                                    }
                                    catch (Exception exception) {
                                        String string10 = exception.getMessage();
                                        if (sQLException.getErrorCode() == 29289) {
                                            string10 = string10 + TuningResources.getString("PLSQLController.37") + TuningResources.getString("PLSQLController.38") + "connect / as sysdba;\n" + "GRANT READ, WRITE on directory " + string3 + " to " + string2 + ";";
                                        } else if (sQLException.getErrorCode() == 6550) {
                                            string10 = string10 + TuningResources.getString("PLSQLController.43") + TuningResources.getString("PLSQLController.44") + "connect / as sysdba;\n" + "grant execute on DBMS_HPROF to " + string2 + ";\n";
                                        } else if (sQLException.getErrorCode() == 29280) {
                                            string10 = string10 + TuningResources.getString("PLSQLController.48") + TuningResources.getString("PLSQLController.49") + "connect / as sysdba;\n" + "CREATE directory " + string3 + " as '/private/plshprof/results';";
                                        }
                                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string10, null, null);
                                        Object object = new Object();
                                        try {
                                            if (statement != null) {
                                                statement.close();
                                            }
                                            if (statement2 != null) {
                                                statement2.close();
                                            }
                                        }
                                        catch (SQLException sQLException4) {
                                            // empty catch block
                                        }
                                        return object;
                                    }
                                }
                                this.construct();
                                break block75;
                            }
                            if (sQLException.getErrorCode() == 942) {
                                block78: {
                                    try {
                                        if (MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)MessageFormat.format(TuningResources.getString("PLSQLController.53"), string2), null, null) == 1) break block78;
                                        Object object = new Object();
                                        return object;
                                    }
                                    catch (Exception exception) {
                                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)(TuningResources.getString("PLSQLController.59") + TuningResources.getString("PLSQLController.60") + TuningResources.getString("PLSQLController.0") + "@?/rdbms/admin/dbmshptab.sql\n\n" + exception.getMessage() != null ? exception.getMessage() : ""), null, null);
                                        Object object = new Object();
                                        try {
                                            if (statement != null) {
                                                statement.close();
                                            }
                                            if (statement2 != null) {
                                                statement2.close();
                                            }
                                        }
                                        catch (SQLException sQLException5) {
                                            // empty catch block
                                        }
                                        return object;
                                    }
                                }
                                URL uRL = ((Object)((Object)this)).getClass().getResource("/oracle/dbtools/raptor/profiler/dbmshptab.sql");
                                InputStream inputStream = uRL.openStream();
                                String string11 = Service.readFile((InputStream)inputStream);
                                inputStream.close();
                                ScriptExecutor scriptExecutor = new ScriptExecutor(string11, connection);
                                scriptExecutor.run();
                                this.construct();
                                break block75;
                            }
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), null, null);
                        }
                        finally {
                            try {
                                if (statement != null) {
                                    statement.close();
                                }
                                if (statement2 != null) {
                                    statement2.close();
                                }
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                    return new Object();
                }

                public void finished() {
                    PLSQLController.this.setSelection(context);
                }
            };
            namedSwingWorker.start();
            return true;
        }
        return bl;
    }

    private void setSelection(Context context) {
        EditorManager editorManager = EditorManager.getEditorManager();
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, PLSQLProfiles.class);
        PLSQLProfiles pLSQLProfiles = (PLSQLProfiles)editorManager.openEditor(openEditorOptions);
    }

    static {
        PROFILE_COMMAND = Ide.findOrCreateCmdID((String)"ProfileSelectionCommand");
    }
}

