/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.build.spi.BuildSystemHook;
import javax.ide.editor.spi.EditorHook;
import javax.ide.extension.DeferredElementVisitorHook;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MultiDeferredElementVisitorHook;
import javax.ide.extension.ParameterizedExtensionHook;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.extension.spi.FeatureHook;
import javax.ide.extension.spi.ScopedMap;
import javax.ide.log.spi.LogHook;
import javax.ide.menu.spi.MenuHook;
import javax.ide.model.spi.DocumentHook;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.net.spi.VFSHook;
import javax.ide.property.spi.PropertyHook;
import javax.ide.spi.IDEListenerHook;
import javax.ide.util.MetaClass;
import javax.ide.wizard.spi.WizardHook;
import oracle.ide.extension.HashStructureHook;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.extension.IDEElementContext;
import oracle.ideimpl.extension.IDEExtension;
import oracle.ideimpl.extension.LayerCache;
import oracle.ideimpl.extension.LayerReader;
import oracle.ideimpl.extension.LayerRegistrationHook;
import oracle.ideimpl.extension.LayerRegistrations;
import oracle.ideimpl.extension.RoleExtensionSource;
import oracle.ideimpl.extension.TriggerHookRegistry;
import oracle.ideimpl.extension.TriggerHooksVisitor;
import oracle.ideimpl.extension.rules.CompositeRuleVisitor;
import oracle.ideimpl.extension.rules.RuleTypeVisitor;
import oracle.ideimpl.extension.rules.RuleVisitor;
import oracle.ideimpl.extension.util.ExtensionLoadingDiagnostics;
import org.openide.filesystems.FileObject;

class LayerHookRegistry
extends TriggerHookRegistry {
    private static Logger LOG = Logger.getLogger(LayerHookRegistry.class.getName());
    private ExtensionManagerImpl em;
    private Map<ElementName, HookHandlerProxy> proxies = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, IDEElementContext> contexts = new HashMap<String, IDEElementContext>();

    public LayerHookRegistry(ExtensionManagerImpl em) {
        this.em = em;
    }

    void initialize() {
        this.proxies.put(BuildSystemHook.ELEMENT, new HookHandlerProxy(BuildSystemHook.ELEMENT, (ExtensionHook)new BuildSystemHook()));
        this.proxies.put(FeatureHook.ELEMENT, new HookHandlerProxy(FeatureHook.ELEMENT, (ExtensionHook)new FeatureHook()));
        this.proxies.put(LogHook.ELEMENT, new HookHandlerProxy(LogHook.ELEMENT, (ExtensionHook)new LogHook()));
        this.proxies.put(MenuHook.ELEMENT, new HookHandlerProxy(MenuHook.ELEMENT, (ExtensionHook)new MenuHook()));
        this.proxies.put(DocumentHook.ELEMENT, new HookHandlerProxy(DocumentHook.ELEMENT, (ExtensionHook)new DocumentHook()));
        this.proxies.put(PropertyHook.ELEMENT, new HookHandlerProxy(PropertyHook.ELEMENT, (ExtensionHook)new PropertyHook()));
        this.proxies.put(IDEListenerHook.ELEMENT, new HookHandlerProxy(IDEListenerHook.ELEMENT, (ExtensionHook)new IDEListenerHook()));
        this.proxies.put(WizardHook.ELEMENT, new HookHandlerProxy(WizardHook.ELEMENT, (ExtensionHook)new WizardHook()));
        this.proxies.put(VFSHook.ELEMENT, new HookHandlerProxy(VFSHook.ELEMENT, (ExtensionHook)new VFSHook()));
        this.proxies.put(EditorHook.ELEMENT, new HookHandlerProxy(EditorHook.ELEMENT, (ExtensionHook)new EditorHook()));
    }

    void initExtension(IDEExtension ext, IDEExtension.State targetState) {
        IDEElementContext ctx = this.em.createInitialContext();
        LayerReader.extToContext(ctx, ext);
        this.contexts.put(ext.getID(), ctx);
        this.checkUnhandledElements(ext, ctx);
        this.checkDeprecatedElement(ext, ctx, "dependencies", " contains deprecated <dependencies> element ");
        this.checkDeprecatedElement(ext, ctx, "classpaths", " contains deprecated <classpaths> element ");
        this.checkDeprecatedElement(ext, ctx, "hooks/feature-hook", " contains deprecated <feature-hook> hook; use the new <feature> hook instead ");
        ext.setState(IDEExtension.State.TRIGGERS_LOADING);
        this.registerExtensions(ext, targetState, ctx);
        ext.setState(IDEExtension.State.TRIGGERS_LOADED);
        if (targetState == IDEExtension.State.FULLY_LOADED) {
            ext.setState(IDEExtension.State.HOOKS_LOADING);
            this.loadHooks(ext, ctx);
            ext.setState(IDEExtension.State.FULLY_LOADED);
        } else {
            Map capturedScopeData = ScopedMap.copyScopeData((Map)ctx.getScopeData(), null);
            ext.setHooksParsingContext(capturedScopeData);
            ctx.getScopeData().put("oracle.ide.parse.interrupt", true);
        }
        if (ExtensionManagerImpl.getHooksProcessingMode() != ExtensionManagerImpl.HooksProcessingMode.EAGER && ext.getState() == IDEExtension.State.FULLY_LOADED) {
            ExtensionLoadingDiagnostics.getInstance().logExtensionLoadingDiagnostics((Extension)ext, ctx.getLogger());
        }
    }

    public Collection<ExtensionHook> getAllHooks() {
        ArrayList<ExtensionHook> l = new ArrayList<ExtensionHook>(this.proxies.size());
        for (HookHandlerProxy hhp : this.proxies.values()) {
            l.add(hhp.getHook());
        }
        return Collections.unmodifiableList(l);
    }

    @Override
    public Collection<ExtensionHook> getAllTriggerHooks() {
        ArrayList<ExtensionHook> result = new ArrayList<ExtensionHook>(this.proxies.size());
        for (HookHandlerProxy hhp : this.proxies.values()) {
            if (!hhp.isTrigger) continue;
            result.add(hhp.hook);
        }
        return result;
    }

    @Override
    public ExtensionHook getTriggerHook(ElementName elementName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean isNameRegistered(ElementName elementName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void registerTriggerHook(ElementName elementName, ExtensionHook triggerHook) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private void checkUnhandledElements(IDEExtension ext, IDEElementContext ctx) {
        FileObject fo = LayerReader.getJDevRoot().getFileObject(ext.getID() + "/all");
        if (fo != null) {
            List<FileObject> children = LayerReader.getOrderedChildren(fo);
            if (children == null) {
                return;
            }
            for (FileObject t : children) {
                Object location = t.getAttribute("location");
                int line = location == null || !(location instanceof Integer) ? 0 : (Integer)location;
                ctx.getLogger().log((LogRecord)new ExtensionLogRecord(Level.WARNING, " contains unhandled element " + t.getAttribute("#T"), (Extension)ext, line));
            }
        }
    }

    private void checkDeprecatedElement(IDEExtension ext, IDEElementContext ctx, String tag, String message) {
        FileObject fo = LayerReader.getJDevRoot().getFileObject(ext.getID() + "/extension/" + tag);
        if (fo != null) {
            ctx.getLogger().log((LogRecord)new ExtensionLogRecord(Level.WARNING, message, (Extension)ext, ((Integer)fo.getAttribute("location")).intValue()));
        }
    }

    void registerExtensions(IDEExtension ext, IDEExtension.State targetState, IDEElementContext ctx) {
        long startTime = System.nanoTime();
        this.loadHandlers(ext, targetState);
        this.loadRules(ext, ctx);
        this.loadTriggers(ext, ctx);
        long endTime = System.nanoTime();
        ext.setRegTime(endTime - startTime);
    }

    void loadHandlers(IDEExtension ext, IDEExtension.State targetState) {
        FileObject hfo;
        if (ext.getState() == IDEExtension.State.TRIGGERS_LOADING) {
            hfo = LayerReader.getJDevRoot().getFileObject(ext.getID() + "/hook-handlers/triggers");
            this.loadProxies(hfo, true);
        }
        if (targetState == IDEExtension.State.FULLY_LOADED && ext.hasHooksSection()) {
            hfo = LayerReader.getJDevRoot().getFileObject(ext.getID() + "/hook-handlers/jdev-hooks");
            this.loadProxies(hfo, false);
            hfo = LayerReader.getJDevRoot().getFileObject(ext.getID() + "/hook-handlers/hooks");
            this.loadProxies(hfo, false);
        }
    }

    private void loadProxies(FileObject hfo, boolean isTriggers) {
        if (hfo == null) {
            return;
        }
        for (FileObject tfo : LayerReader.getOrderedChildren(hfo)) {
            HookHandlerProxy hhp = new HookHandlerProxy(tfo, isTriggers);
            this.proxies.put(hhp.element, hhp);
        }
    }

    void loadRules(IDEExtension ext, IDEElementContext ctx) {
        FileObject rfo = LayerReader.getJDevRoot().getFileObject(ext.getID() + "/rules");
        if (rfo == null) {
            return;
        }
        ctx.registerChildVisitor(TriggerHooksVisitor.RULE_TYPE_ELEMENT, new RuleTypeVisitor());
        ctx.registerChildVisitor(TriggerHooksVisitor.RULE_ELEMENT, new RuleVisitor());
        ctx.registerChildVisitor(TriggerHooksVisitor.COMPOSITE_RULE_ELEMENT, new CompositeRuleVisitor());
        LayerReader.scanChildren(rfo, ctx);
    }

    void loadTriggers(IDEExtension ext, IDEElementContext ctx) {
        this.scanHooks(ext, "triggers", ctx, true);
    }

    void loadHooks(IDEExtension ext, IDEElementContext ctx) {
        long startTime = System.nanoTime();
        this.scanHooks(ext, "jdev-hooks", ctx, false);
        this.scanHooks(ext, "hooks", ctx, false);
        long endTime = System.nanoTime();
        ext.addInitTime(endTime - startTime);
    }

    void scanHooks(IDEExtension ext, String path, IDEElementContext ctx, boolean triggersOnly) {
        FileObject thFO = LayerReader.getJDevRoot().getFileObject(ext.getID() + "/" + path);
        if (thFO == null) {
            return;
        }
        for (FileObject hFO : LayerReader.getOrderedChildren(thFO)) {
            String hookHandlerExtensionId;
            ElementName element = new ElementName((String)hFO.getAttribute("#U"), hFO.getNameExt());
            long s = LayerCache.TIMERS.nanoTime();
            HookHandlerProxy hhp = this.proxies.get(element);
            if (hhp == null || triggersOnly && !"menu-hook".equals(element.getLocalName()) && !hhp.isTrigger && !hhp.registerAsHook && !hhp.registerAsJDevHook) {
                LayerReader.setFileObjectToCtx(hFO, ctx);
                ctx.getLogger().log((LogRecord)new ExtensionLogRecord((ElementContext)ctx, Level.SEVERE, "Can't find handler for " + element));
                break;
            }
            if (!(ext.getSource() instanceof RoleExtensionSource) && (hookHandlerExtensionId = hhp.hook.getProvider()) != null && !hookHandlerExtensionId.equals(ext.getID())) {
                Collection dependencies = ext.getDependencies();
                boolean providerFound = false;
                for (ExtensionDependency dependency : dependencies) {
                    if (!hookHandlerExtensionId.equals(dependency.getID())) continue;
                    providerFound = true;
                    break;
                }
                if (!providerFound) {
                    LayerReader.setFileObjectToCtx(hFO, ctx);
                    ctx.getLogger().log((LogRecord)new ExtensionLogRecord((ElementContext)ctx, Level.WARNING, "No extension dependency from " + ext.getID() + " to " + hookHandlerExtensionId + " although " + ext.getID() + " consumes hook " + hhp.element + " , defined in " + hookHandlerExtensionId + " . The hook will be processed, " + "but is not guaranteed to work every " + "time unless a direct dependency exists."));
                }
            }
            if (hhp.isDeclarative()) {
                LayerRegistrationHook lrh = (LayerRegistrationHook)hhp.hook;
                for (FileObject cFO : hFO.getChildren()) {
                    lrh.register(LayerRegistrations.create(ext, cFO, lrh.getAnnotationClass()));
                }
            } else if (hhp.isLazy()) {
                hhp.addLazyData(ext, hFO);
            } else {
                ctx.registerChildVisitor(hhp.element, (ElementVisitor)hhp.hook);
                LayerReader.scanChildren(hFO, ctx);
            }
            LayerCache.TIMERS.addCurrentNanos("HOOK-load." + element.getLocalName() + ":" + (hhp.isLazy() ? "lazzy" : (hhp.isDeclarative() ? "decl" : "")), s);
        }
    }

    synchronized ExtensionHook getHook(ElementName element) {
        HookHandlerProxy proxy = this.proxies.get(element);
        if (proxy == null) {
            return null;
        }
        return proxy.getHook();
    }

    synchronized void fullyLoad(IDEExtension ext) {
        IDEElementContext ctx = this.contexts.get(ext.getID());
        if (ctx == null) {
            ctx = this.em.createInitialContext();
            LayerReader.extToContext(ctx, ext);
        }
        ctx.getScopeData().putAll(ext.getHooksParsingContext());
        ext.setState(IDEExtension.State.HOOKS_LOADING);
        this.loadHandlers(ext, IDEExtension.State.FULLY_LOADED);
        this.loadHooks(ext, ctx);
        ext.setState(IDEExtension.State.FULLY_LOADED);
    }

    public static @interface HookHandler {
        @LayerRegistrationHook.Attr(value="tag-name")
        public String tagName();

        @LayerRegistrationHook.Attr(value="namespace")
        public String namespace();

        @LayerRegistrationHook.Attr(value="handler-class")
        public String handlerClass();

        @LayerRegistrationHook.Attr(value="provider")
        public String provider();

        @LayerRegistrationHook.Attr(value="register-as-hook")
        public boolean registerAsHook() default false;

        @LayerRegistrationHook.Attr(value="register-as-jdeveloper-hook")
        public boolean registerAsJDevHook() default false;

        @LayerRegistrationHook.Attr(value="schema-location")
        public String schemaLocation() default "";

        @LayerRegistrationHook.Tag(value={"param"})
        public Parameter[] parameters();

        public static @interface Parameter {
            @LayerRegistrationHook.Attr(value="name")
            public String name();

            @LayerRegistrationHook.Attr(value="value")
            public String value();
        }
    }

    private class HookHandlerProxy {
        private ExtensionHook hook;
        private LayerRegistrationHook lrHook;
        private ElementName element;
        private String handlerClass;
        private String provider;
        private boolean isTrigger;
        private boolean registerAsJDevHook;
        private boolean registerAsHook;
        private Map<String, String> parameters = new HashMap<String, String>();
        private String schemaLocation;
        private Map<IDEExtension, List<FileObject>> lazyData;

        public HookHandlerProxy(FileObject fo, boolean isTrigger) {
            HashStructureHook hsh;
            long s = LayerCache.TIMERS.nanoTime();
            HookHandler hookHandler = LayerRegistrations.createAnnotation(fo, HookHandler.class);
            this.element = new ElementName(hookHandler.namespace(), hookHandler.tagName());
            this.handlerClass = hookHandler.handlerClass();
            this.provider = hookHandler.provider();
            this.isTrigger = isTrigger;
            this.registerAsHook = hookHandler.registerAsHook();
            this.registerAsJDevHook = hookHandler.registerAsJDevHook();
            this.schemaLocation = hookHandler.schemaLocation();
            this.instantiateHook(hookHandler, isTrigger);
            if (this.hook instanceof HashStructureHook && !HashStructureHook.class.getName().equals(this.handlerClass) && (hsh = (HashStructureHook)this.hook).getListenersCount() == 0) {
                this.lazyData = new LinkedHashMap<IDEExtension, List<FileObject>>();
            }
            if (HashStructureHook.class.getName().equals(this.handlerClass) || DeferredElementVisitorHook.class.getName().equals(this.handlerClass) || MultiDeferredElementVisitorHook.class.getName().equals(this.handlerClass)) {
                this.lazyData = new LinkedHashMap<IDEExtension, List<FileObject>>();
            }
            LayerCache.TIMERS.addCurrentNanos("read proxy", s);
        }

        public HookHandlerProxy(ElementName element, ExtensionHook hook) {
            this.element = element;
            this.hook = hook;
            this.provider = "oracle.ide";
        }

        public boolean isLazy() {
            return this.lazyData != null;
        }

        public boolean isDeclarative() {
            return this.hook instanceof LayerRegistrationHook;
        }

        public void addLazyData(IDEExtension ext, FileObject fo) {
            List<FileObject> lf = this.lazyData.get((Object)ext);
            if (lf == null) {
                lf = new ArrayList<FileObject>();
                this.lazyData.put(ext, lf);
            }
            lf.add(fo);
        }

        private void instantiateHook(HookHandler handler, boolean isTrigger) {
            long s = LayerCache.TIMERS.nanoTime();
            MetaClass mc = new MetaClass(LayerHookRegistry.this.em.getClassLoader(this.provider), this.handlerClass);
            try {
                this.hook = (ExtensionHook)mc.newInstance();
                this.hook.setProvider(this.provider);
                this.hook.setSchemaLocation(this.sanitizeSchemaLocation());
                if (this.hook instanceof ParameterizedExtensionHook) {
                    for (HookHandler.Parameter p : handler.parameters()) {
                        this.parameters.put(p.name(), p.value());
                    }
                    ((ParameterizedExtensionHook)this.hook).setHookHandlerParameters(this.parameters);
                }
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.SEVERE, "Can't instantiate hook " + this.element.getLocalName(), ex);
            }
            catch (InstantiationException ex) {
                LOG.log(Level.SEVERE, "Can't instantiate hook " + this.element.getLocalName(), ex);
            }
            catch (IllegalAccessException ex) {
                LOG.log(Level.SEVERE, "Can't instantiate hook " + this.element.getLocalName(), ex);
            }
            LayerCache.TIMERS.addCurrentNanos("Instantiation", s);
        }

        public ExtensionHook getHook() {
            if (this.hook == null) {
                throw new IllegalStateException("Hook not innstantiated for " + this.element);
            }
            if (this.isLazy()) {
                this.replayLazyData();
            }
            return this.hook;
        }

        private void replayLazyData() {
            for (Map.Entry<IDEExtension, List<FileObject>> e : this.lazyData.entrySet()) {
                IDEElementContext ctx = (IDEElementContext)((Object)LayerHookRegistry.this.contexts.get(e.getKey().getID()));
                if (ctx == null) {
                    throw new NullPointerException("Not seen " + e.getKey().getID() + " " + this.element.getLocalName());
                }
                ctx.registerChildVisitor(this.element, (ElementVisitor)this.hook);
                for (FileObject fo : e.getValue()) {
                    LayerReader.scanChildren(fo, ctx);
                }
            }
            this.lazyData = null;
        }

        private String sanitizeSchemaLocation() {
            String schemaLocation = this.schemaLocation;
            if (schemaLocation != null) {
                URI sourceUri = ((IDEExtension)LayerHookRegistry.this.em.findMinimalExtension(this.provider)).getSource().getURI();
                URI schemaUri = URIFactory.newJarURI((URI)sourceUri, (String)("META-INF/" + schemaLocation.replace('\\', '/')));
                if (!VirtualFileSystem.getVirtualFileSystem().exists(schemaUri)) {
                    LOG.log(Level.SEVERE, "Schema not found: " + VirtualFileSystem.getVirtualFileSystem().getPlatformPathName(schemaUri));
                    schemaLocation = null;
                } else if (schemaLocation.trim().length() == 0) {
                    LOG.log(Level.FINE, "No schema location for " + this.element);
                    schemaLocation = null;
                } else if (!schemaUri.getPath().endsWith(".xsd")) {
                    LOG.log(Level.SEVERE, "Schema file of hook " + this.element + " is not an xsd file. Was " + VirtualFileSystem.getVirtualFileSystem().getPlatformPathName(schemaUri));
                    schemaLocation = null;
                }
            }
            return schemaLocation;
        }
    }
}

