/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.ide.util.BitField;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;

public final class VisibilityLayout {
    private static final int FLAG_VISIBLE = 1;
    private static final int FLAG_MINIMIZED = 2;
    private static final int FLAG_RAISED = 4;
    private static final String KEY_VISIBLE = "visible";
    private static final String KEY_MINIMIZED = "minimized";
    private static final String KEY_RAISED = "raised";
    private static final String KEY_DISPLAY_NAME = "displayName";
    private static final String EXCLUSIVE_ROLE = "exclusiveRole";
    private String _internalName;
    private String _displayName;
    private HashMap<String, Integer> _visibilityInfo = new HashMap();
    private Map<String, String> _exclusiveDockableRoles = new HashMap<String, String>();
    private Map<String, Boolean> _dockableVisibleStateOnSave = new HashMap<String, Boolean>();

    public VisibilityLayout(String internalName, String displayName) {
        this._internalName = internalName;
        this._displayName = displayName;
    }

    private String getInternalName() {
        return this._internalName;
    }

    private String getDisplayName() {
        return this._displayName;
    }

    private int getFlags(String name) {
        Integer flags = this._visibilityInfo.get(name);
        return flags == null ? 0 : flags;
    }

    private void setFlags(String name, int value) {
        this._visibilityInfo.put(name, value);
    }

    private boolean getFlag(String dockablename, int flagVisible) {
        int visibilityFlags = this.getFlags(dockablename);
        return BitField.isSet(visibilityFlags, flagVisible);
    }

    private void setFlag(String dockableName, boolean set, int flag) {
        int oldValue = this.getFlags(dockableName);
        int newValue = set ? BitField.set(oldValue, flag) : BitField.unset(oldValue, flag);
        this.setFlags(dockableName, newValue);
    }

    public void setVisible(String dockableName, boolean visible) {
        this.setFlag(dockableName, visible, 1);
    }

    public boolean isVisible(String dockablename) {
        return this.getFlag(dockablename, 1);
    }

    public void setMinimized(String dockableName, boolean minimized) {
        this.setFlag(dockableName, minimized, 2);
    }

    public boolean isMinimized(String dockableName) {
        return this.getFlag(dockableName, 2);
    }

    public void setRaised(String dockableName, boolean selected) {
        this.setFlag(dockableName, selected, 4);
    }

    public boolean isRaised(String dockableName) {
        return this.getFlag(dockableName, 4);
    }

    public void setExclusiveRoleForDockable(String dockableName, String roleId) {
        this._exclusiveDockableRoles.put(dockableName, roleId);
    }

    public String getExclusiveRoleForDockable(String dockableName) {
        return this._exclusiveDockableRoles.get(dockableName);
    }

    public void setDockableVisibleStateOnSave(String dockableName, boolean state) {
        this._dockableVisibleStateOnSave.put(dockableName, state);
    }

    public static String[] getNewDockables(VisibilityLayout from, VisibilityLayout to) {
        Set<String> knownDockablesFrom = from._visibilityInfo.keySet();
        Set<String> knownDockablesTo = to._visibilityInfo.keySet();
        HashSet<String> removedDockables = new HashSet<String>(knownDockablesFrom);
        removedDockables.removeAll(knownDockablesTo);
        return removedDockables.toArray(new String[removedDockables.size()]);
    }

    public void clear() {
        this._visibilityInfo.clear();
    }

    public StructuredPropertyAccess save() {
        String internalName = this.getInternalName();
        DefaultStructuredPropertyAccess root = new DefaultStructuredPropertyAccess(internalName);
        String displayName = this.getDisplayName();
        root.setProperty(KEY_DISPLAY_NAME, displayName);
        Set<String> set = this._visibilityInfo.keySet();
        for (String dockableName : set) {
            boolean raised;
            boolean minimized;
            DefaultStructuredPropertyAccess dockableNode = new DefaultStructuredPropertyAccess(dockableName);
            boolean visible = this.isVisible(dockableName);
            if (visible) {
                dockableNode.setProperty(KEY_VISIBLE, Boolean.TRUE.toString());
            }
            if (minimized = this.isMinimized(dockableName)) {
                dockableNode.setProperty(KEY_MINIMIZED, Boolean.TRUE.toString());
            }
            if (raised = this.isRaised(dockableName)) {
                dockableNode.setProperty(KEY_RAISED, Boolean.TRUE.toString());
            }
            if (this._dockableVisibleStateOnSave.get(dockableName) != null) {
                dockableNode.setProperty(KEY_VISIBLE, this._dockableVisibleStateOnSave.get(dockableName).toString());
            }
            if (this._exclusiveDockableRoles.get(dockableName) != null) {
                dockableNode.setProperty(EXCLUSIVE_ROLE, this._exclusiveDockableRoles.get(dockableName));
            }
            root.appendChild(dockableNode);
        }
        return root;
    }

    public static VisibilityLayout load(StructuredPropertyAccess root) {
        String internalName = root.getName();
        String displayName = root.getProperty(KEY_DISPLAY_NAME, internalName);
        VisibilityLayout visibilityLayout = new VisibilityLayout(internalName, displayName);
        Iterator childNodes = root.getChildNodes();
        while (childNodes.hasNext()) {
            StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
            String childName = child.getName();
            boolean visible = child.getBooleanProperty(KEY_VISIBLE, false);
            visibilityLayout.setVisible(childName, visible);
            boolean minimized = child.getBooleanProperty(KEY_MINIMIZED, false);
            visibilityLayout.setMinimized(childName, minimized);
            boolean raised = child.getBooleanProperty(KEY_RAISED, false);
            visibilityLayout.setRaised(childName, raised);
            String roleId = child.getProperty(EXCLUSIVE_ROLE, null);
            if (roleId == null) continue;
            visibilityLayout.setExclusiveRoleForDockable(childName, roleId);
        }
        return visibilityLayout;
    }
}

