/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.util.Iterator;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.Layout;
import oracle.ide.util.BitField;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.layout.LayoutsImpl;

public final class ClientLayoutData {
    private static final String KEY_ELEMENT_GLOBAL = "global";
    private static final String KEY_ELEMENT_VIEW_DATA = "view-data";
    private static final String KEY_ATTRIBUTE_ID = "ID";
    private static final String KEY_ATTRIBUTE_LAYOUT_NAME = "layout-name";

    public static DefaultStructuredPropertyAccess newViewStorage() {
        return new DefaultStructuredPropertyAccess(KEY_ELEMENT_VIEW_DATA);
    }

    public static void addOrReplaceViewStorage(Dockable dockable, StructuredPropertyAccess clientStore, Layout layout) {
        LayoutsImpl layouts = LayoutsImpl.getInstance();
        StructuredPropertyAccess rootStore = layouts.getClientLayoutData();
        StructuredPropertyAccess store = null;
        store = ClientLayoutData.isGlobal(dockable) ? ClientLayoutData.getGlobalStorage(rootStore, true) : ClientLayoutData.getLayoutStorage(rootStore, layout, true);
        ClientLayoutData.addOrReplaceDockableStorage(dockable, store, clientStore);
    }

    public static StructuredPropertyAccess findStructuredPropertyAccess(Dockable dockable, Layout layout) {
        LayoutsImpl layouts = LayoutsImpl.getInstance();
        StructuredPropertyAccess pa = layouts.findClientLayoutData();
        if (pa == null) {
            return null;
        }
        if (ClientLayoutData.isGlobal(dockable)) {
            return ClientLayoutData.getClientGlobalStorage(dockable, pa, false);
        }
        return ClientLayoutData.getClientLayoutStorage(dockable, layout, pa, false);
    }

    private static StructuredPropertyAccess getClientGlobalStorage(Dockable dockable, StructuredPropertyAccess pa, boolean create) {
        StructuredPropertyAccess gpa = ClientLayoutData.getGlobalStorage(pa, create);
        if (gpa != null) {
            gpa = ClientLayoutData.getDockableStorage(dockable, gpa, create);
        }
        return gpa;
    }

    private static StructuredPropertyAccess getGlobalStorage(StructuredPropertyAccess pa, boolean create) {
        StructuredPropertyAccess gpa = null;
        Iterator childNodes = pa.getChildNodes();
        while (childNodes.hasNext()) {
            StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
            if (!child.getName().equals(KEY_ELEMENT_GLOBAL)) continue;
            gpa = child;
            break;
        }
        if (gpa == null && create) {
            gpa = new DefaultStructuredPropertyAccess(KEY_ELEMENT_GLOBAL);
            pa.appendChild(gpa);
        }
        return gpa;
    }

    private static StructuredPropertyAccess getClientLayoutStorage(Dockable dockable, Layout layout, StructuredPropertyAccess pa, boolean create) {
        StructuredPropertyAccess lpa = ClientLayoutData.getLayoutStorage(pa, layout, create);
        if (lpa != null) {
            lpa = ClientLayoutData.getDockableStorage(dockable, lpa, create);
        }
        return lpa;
    }

    private static StructuredPropertyAccess getLayoutStorage(StructuredPropertyAccess pa, Layout layout, boolean create) {
        StructuredPropertyAccess lpa = null;
        String layoutName = ClientLayoutData.getLayoutInternalName(layout);
        Iterator childNodes = pa.getChildNodes();
        while (childNodes.hasNext()) {
            StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
            if (!child.getName().equals(layoutName)) continue;
            lpa = child;
            break;
        }
        if (lpa == null && create) {
            lpa = new DefaultStructuredPropertyAccess(layoutName);
            lpa.setProperty(KEY_ATTRIBUTE_LAYOUT_NAME, layout.getName());
            pa.appendChild(lpa);
        }
        return lpa;
    }

    private static StructuredPropertyAccess getDockableStorage(Dockable dockable, StructuredPropertyAccess pa, boolean create) {
        StructuredPropertyAccess dpa = null;
        Iterator childNodes = pa.getChildNodes();
        while (childNodes.hasNext()) {
            String id;
            StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
            if (!child.getName().equals(KEY_ELEMENT_VIEW_DATA) || !(id = child.getProperty(KEY_ATTRIBUTE_ID, "")).equals(dockable.getUniqueName())) continue;
            dpa = child;
            break;
        }
        if (dpa == null && create) {
            dpa = new DefaultStructuredPropertyAccess(KEY_ELEMENT_VIEW_DATA);
            dpa.setProperty(KEY_ATTRIBUTE_ID, dockable.getUniqueName());
            pa.appendChild(dpa);
        }
        return dpa;
    }

    private static void addOrReplaceDockableStorage(Dockable dockable, StructuredPropertyAccess pa, StructuredPropertyAccess dpa) {
        StructuredPropertyAccess oldDPA = ClientLayoutData.getDockableStorage(dockable, pa, false);
        if (oldDPA != null) {
            pa.removeChild(oldDPA);
        }
        dpa.setProperty(KEY_ATTRIBUTE_ID, dockable.getUniqueName());
        pa.appendChild(dpa);
    }

    private static String getLayoutInternalName(Layout layout) {
        String displayName = layout.getName();
        return displayName.replace(' ', '_');
    }

    private static boolean isGlobal(Dockable dockable) {
        int dockableType = dockable.getType();
        return BitField.isSet(dockableType, 32);
    }

    private ClientLayoutData() {
    }
}

