/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.view;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.AbstractPinnable;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;

public abstract class MultiManager
implements Controller,
Addin {
    private IdeAction _showAction;
    private IdeAction _toggleToolbarAction;
    private final List _views = new ArrayList();
    private final L _listener = new L();
    private DockableView defaultView;
    private static Collection<String> clones = new HashSet<String>();
    private static final String TOOLBAR_VISIBLE_PROP = ".Toolbar.visible";

    @Override
    public void initialize() {
        Menubar mgr;
        DockStation dockStation;
        DockableFactory factory = this.getDockableFactory();
        if (factory != null && (dockStation = DockStation.getDockStation()) != null) {
            dockStation.registerDockableFactory(this.getViewCategory(), factory);
        }
        Menubar menubar = mgr = Ide.getIdeArgs().getCreateUI() ? Ide.getMenubar() : null;
        if (mgr != null) {
            String acceleratorFile;
            this._toggleToolbarAction = this.createToggleToolbarAction();
            if (this._toggleToolbarAction != null) {
                this._toggleToolbarAction.putValue("Check", Boolean.TRUE);
                this._toggleToolbarAction.addController(this);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.createToggleToolbarMenuItem(mgr);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MultiManager.this.createToggleToolbarMenuItem(mgr);
                        }
                    });
                }
            }
            if ((acceleratorFile = this.getAcceleratorFile()) != null) {
                KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
                keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), acceleratorFile);
            }
        }
    }

    private void createToggleToolbarMenuItem(MenuManager mgr) {
        JMenuItem item = mgr.createMenuItem(this._toggleToolbarAction, this.getToggleToolbarMenuWeight());
        mgr.add(item, MenuManager.getJMenu("ViewToolbars"), MenuConstants.SECTION_VIEW_TOOLBARS_SUBMENU_OTHERS);
    }

    public final IdeAction getShowAction() {
        if (this._showAction == null) {
            this._showAction = this.createShowAction();
        }
        return this._showAction;
    }

    public DockableView showLastView(Context context) {
        DockableView last = this.getLastView();
        if (last == null) {
            return this.showView(context);
        }
        if (last == Ide.getMainWindow().getLastActiveView() && this._views.size() > 1) {
            this._views.remove(last);
            this._views.add(0, last);
            last = this.getLastView();
        }
        last.show();
        DockStation.getDockStation().activateDockable(last);
        return last;
    }

    public DockableView showView(Context context) {
        DockableView view = this.findOrCreateView(context);
        if (view != null) {
            view.show();
            DockStation.getDockStation().activateDockable(view);
        }
        return view;
    }

    public DockableView getLastView() {
        if (this._views.isEmpty()) {
            return null;
        }
        return (DockableView)this._views.get(this._views.size() - 1);
    }

    public DockableView getNewView(Context context, ViewId viewId) {
        DockableView view;
        DockableView dockableView = view = this.isDefaultView(viewId) ? this.getDefaultView(context) : this.createDockableView(context, viewId);
        if (view != null) {
            view.setToolbarVisible(this.isToolbarVisible());
            this.registerView(view);
        }
        return view;
    }

    public Collection getViews() {
        return new ArrayList(this._views);
    }

    public ViewId getDefaultViewId() {
        return new ViewId(this.getViewCategory(), this.getDefaultName());
    }

    protected abstract String getViewCategory();

    protected abstract String getDefaultName();

    protected String getAcceleratorFile() {
        return null;
    }

    protected abstract DockableView createDockableView(Context var1, ViewId var2);

    protected abstract IdeAction createShowAction();

    @Deprecated
    protected abstract DockableFactory getDockableFactory();

    protected IdeAction createToggleToolbarAction() {
        return null;
    }

    protected float getToggleToolbarMenuWeight() {
        return Float.MAX_VALUE;
    }

    protected ViewId getViewId(Context context) {
        if (context == null) {
            return null;
        }
        ViewId defaultViewId = this.getDefaultViewId();
        Node node = context.getNode();
        if (node == null) {
            return defaultViewId;
        }
        ArrayList views = new ArrayList(this.getViews());
        for (View view : views) {
            Node viewNode;
            Context viewContext;
            if (view == null || (viewContext = view.getContext()) == null || (viewNode = viewContext.getNode()) != node) continue;
            return new ViewId(view.getId());
        }
        return defaultViewId;
    }

    protected DockableView findView(ViewId viewId) {
        Dockable dockable;
        if (viewId != null && (dockable = DockStation.getDockStation().getDockable(viewId)) instanceof DockableView) {
            return (DockableView)dockable;
        }
        return null;
    }

    protected DockableView findOrCreateView(Context context) {
        DockableView view;
        ViewId viewId = this.getViewId(context);
        boolean clone = false;
        if (viewId == null || viewId.getName() == null) {
            viewId = new ViewId(this.getViewCategory(), Long.toString(new Date().getTime()));
            clone = true;
        }
        if ((view = this.findView(viewId)) == null) {
            DockableView relative = this.getRelativeView(context, viewId);
            Collection views = this.getViews();
            int count = views != null ? views.size() : 0;
            view = this.getNewView(context, viewId);
            if (view != null) {
                int status;
                if (view instanceof AbstractPinnable && clone) {
                    clones.add(view.getUniqueName());
                }
                DockStation ds = DockStation.getDockStation();
                if (relative != null && ((status = ds.getDockableStatus(relative)) & 1) != 1) {
                    relative = null;
                }
                DockingParam dockingParam = new DockingParam();
                if (count == 0) {
                    int orientation = this.getOrientation(viewId, relative);
                    if (relative != null) {
                        dockingParam.setPosition(relative, orientation);
                    } else {
                        dockingParam.setPosition(orientation);
                    }
                } else {
                    dockingParam.setTabbedWith(relative);
                }
                ds.dock(view, dockingParam);
            }
        }
        return view;
    }

    protected DockableView getRelativeView(Context context, ViewId viewId) {
        ActionEvent actionEvent;
        String name;
        String string = name = viewId != null ? viewId.getName() : null;
        if (name != null && name.equals(this.getDefaultName())) {
            return null;
        }
        EventObject eventObject = context.getEvent();
        if (eventObject instanceof ActionEvent && (actionEvent = (ActionEvent)eventObject).getActionCommand().equals(IdeArb.getString(25)) && this instanceof NavigatorManager) {
            return ((NavigatorManager)this).getNavigatorWindow();
        }
        return this.getLastView();
    }

    protected int getOrientation(ViewId viewId, DockableView relative) {
        return relative != null ? 4 : 0;
    }

    protected boolean isToolbarVisible() {
        String visible = Ide.getProperty(this.getViewCategory() + TOOLBAR_VISIBLE_PROP, Boolean.TRUE.toString());
        return Boolean.valueOf(visible);
    }

    protected void setToolbarVisible(boolean visible) {
        Ide.setProperty(this.getViewCategory() + TOOLBAR_VISIBLE_PROP, Boolean.toString(visible));
        Iterator i = this._views.iterator();
        if (i != null) {
            while (i.hasNext()) {
                ((View)i.next()).setToolbarVisible(visible);
            }
        }
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        if (action != null) {
            int cmdId = action.getCommandId();
            if (cmdId == 67) {
                this.showView(context);
                return true;
            }
            if (this._toggleToolbarAction != null && cmdId == this._toggleToolbarAction.getCommandId()) {
                this.setToolbarVisible(!this.isToolbarVisible());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        if (action != null) {
            int cmdId = action.getCommandId();
            if (cmdId == 67) {
                action.setEnabled(true);
                return true;
            }
            if (this._toggleToolbarAction != null && cmdId == this._toggleToolbarAction.getCommandId()) {
                action.setEnabled(true);
                action.setState(this.isToolbarVisible());
                return true;
            }
        }
        return false;
    }

    private void registerView(View view) {
        this.addView(view);
        view.addViewListener(this._listener);
    }

    private void addView(View view) {
        this._views.remove(view);
        this._views.add(view);
    }

    private void removeView(View view) {
        if (this._views.contains(view)) {
            this._views.remove(view);
        }
    }

    private boolean isDefaultView(ViewId viewId) {
        return viewId != null ? viewId.equals(this.getDefaultViewId()) : false;
    }

    protected synchronized DockableView getDefaultView(Context context) {
        if (this.defaultView != null) {
            return this.defaultView;
        }
        this.defaultView = this.createDockableView(context, this.getDefaultViewId());
        return this.defaultView;
    }

    public static final boolean isClone(String uniqueDockableName) {
        return clones.contains(uniqueDockableName);
    }

    public static final Collection<String> getClonesIDs() {
        return new HashSet<String>(clones);
    }

    private class L
    implements ViewListener {
        private L() {
        }

        @Override
        public void viewClosed(ViewEvent e) {
            View view;
            if (e != null && (view = e.getView()) != null) {
                MultiManager.this.removeView(view);
            }
        }

        @Override
        public void viewActivated(ViewEvent e) {
            View view;
            if (e != null && (view = e.getView()) != null) {
                MultiManager.this.addView(view);
            }
        }

        @Override
        public void viewDeactivated(ViewEvent e) {
        }
    }
}

